/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.expansion.UriExpansion;
import com.apicatalog.jsonld.lang.Direction;
import com.apicatalog.tree.io.TreeAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ValueExpansion {
    public static Map<String, ?> expand(Context context, String property, Object value, TreeAdapter adapter, Expansion.Params params) throws JsonLdException {
        String typeMapping;
        Optional<TermDefinition> definition = context.findTerm(property);
        switch (typeMapping = definition.map(TermDefinition::getTypeMapping).orElse("@none")) {
            case "@id": {
                String idValue = null;
                if (adapter.isString(value)) {
                    idValue = adapter.stringValue(value);
                } else if (params.options().useNumericId() && adapter.isNumber(value)) {
                    idValue = adapter.asString(value);
                }
                if (idValue == null) break;
                return Map.of("@id", UriExpansion.with(context, params.options().loader(), params.runtime()).documentRelative(true).vocab(false).expand(idValue));
            }
            case "@vocab": {
                if (!adapter.isString(value)) break;
                return Map.of("@id", UriExpansion.with(context, params.options().loader(), params.runtime()).documentRelative(true).vocab(true).expand(adapter.stringValue(value)));
            }
            case "@none": {
                break;
            }
            default: {
                return Map.of("@type", typeMapping, "@value", ValueExpansion.asScalar(value, adapter));
            }
        }
        if (adapter.isString(value)) {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("@value", adapter.stringValue(value));
            String language = definition.map(TermDefinition::getLanguageMapping).orElseGet(context::getDefaultLanguage);
            if (language != null && !"@null".equals(language)) {
                map.put("@language", language);
            }
            Direction direction = definition.map(TermDefinition::getDirectionMapping).orElseGet(context::getDefaultBaseDirection);
            if (direction != null && !Direction.NULL.equals((Object)direction)) {
                map.put("@direction", direction.name().toLowerCase());
            }
            return map;
        }
        return Map.of("@value", ValueExpansion.asScalar(value, adapter));
    }

    private static Object asScalar(Object node, TreeAdapter adapter) {
        if (node == null) {
            return null;
        }
        switch (adapter.type(node)) {
            case NULL: {
                return null;
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case NUMBER: {
                return adapter.numericValue(node);
            }
            case STRING: {
                return adapter.stringValue(node);
            }
        }
        return adapter.asString(node);
    }
}

