/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.expansion.ObjectExpansion1314;
import com.apicatalog.jsonld.expansion.UriExpansion;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.web.uri.UriUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ObjectExpansion {
    private final Object element;
    private final TreeAdapter adapter;
    private final TreeIO propertyContext;
    private final Expansion.Params params;
    private Context activeContext;

    public ObjectExpansion(TreeIO propertyContext, Object element, TreeAdapter adapter, Expansion.Params params) {
        this.propertyContext = propertyContext;
        this.element = element;
        this.adapter = adapter;
        this.params = params;
    }

    public Object expand(Context context, String property) throws JsonLdException {
        Object contextValue;
        this.params.runtime().onBeforeMap(property);
        this.activeContext = ObjectExpansion.initPreviousContext(context, this.element, this.adapter, this.params);
        if (this.propertyContext != null) {
            this.activeContext = this.activeContext.newContext(this.params.options().loader(), this.params.runtime()).overrideProtected(true).build(this.propertyContext.node(), this.propertyContext.adapter(), this.activeContext.findTerm(property).map(TermDefinition::getBaseUrl).orElse(null));
        }
        if ((contextValue = this.adapter.property((Object)"@context", this.element)) != null) {
            this.activeContext = this.activeContext.newContext(this.params.options().loader(), this.params.runtime()).build(contextValue, this.adapter, this.params.baseUrl());
        }
        Context typeContext = this.activeContext;
        String typeKey = this.processTypeScoped(typeContext);
        String inputType = this.findInputType(typeKey);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ObjectExpansion1314.with(this.params).inputType(inputType).result(result).typeContext(typeContext).nest(new LinkedHashMap<String, Object>()).expand(this.activeContext, this.element, this.adapter, property);
        this.params.runtime().onAfterMap(property);
        if (result.containsKey("@value")) {
            return ObjectExpansion.normalizeValue(result, property, this.params.frameExpansion());
        }
        if (result.containsKey("@type")) {
            return this.normalizeType(result, property, this.params.frameExpansion());
        }
        if (result.containsKey("@list") || result.containsKey("@set")) {
            return this.normalizeContainer(result, property, this.params.frameExpansion());
        }
        return ObjectExpansion.normalize(result, property, this.params.frameExpansion());
    }

    private static Context initPreviousContext(Context context, Object element, TreeAdapter adapter, Expansion.Params params) throws JsonLdException {
        if (context.getPreviousContext() != null && !params.fromMap()) {
            boolean revert = true;
            Iterator it = adapter.keyStream(element).sorted(TreeIO.comparingElement(arg_0 -> ((TreeAdapter)adapter).stringValue(arg_0))).iterator();
            while (it.hasNext()) {
                params.runtime().tick();
                String key = adapter.stringValue(it.next());
                String expandedKey = UriExpansion.with(context, params.options().loader(), params.runtime()).vocab(true).expand(key);
                if (!"@value".equals(expandedKey) && (!"@id".equals(expandedKey) || !adapter.isSingleEntry(element))) continue;
                revert = false;
                break;
            }
            if (revert) {
                return context.getPreviousContext();
            }
        }
        return context;
    }

    private String processTypeScoped(Context typeContext) throws JsonLdException {
        String typeKey = null;
        Iterator typeKeys = this.adapter.keyStream(this.element).sorted(TreeIO.comparingElement(arg_0 -> ((TreeAdapter)this.adapter).asString(arg_0))).iterator();
        while (typeKeys.hasNext()) {
            String key = this.adapter.asString(typeKeys.next());
            this.params.runtime().tick();
            String expandedKey = UriExpansion.with(this.activeContext, this.params.options().loader(), this.params.runtime()).vocab(true).expand(key);
            if (!"@type".equals(expandedKey)) continue;
            if (typeKey == null) {
                typeKey = key;
            }
            this.params.runtime().onTypeKey(key);
            Iterator terms = this.adapter.asStream(this.adapter.property((Object)key, this.element)).filter(arg_0 -> ((TreeAdapter)this.adapter).isString(arg_0)).map(arg_0 -> ((TreeAdapter)this.adapter).stringValue(arg_0)).sorted().iterator();
            while (terms.hasNext()) {
                this.params.runtime().tick();
                String term = (String)terms.next();
                TreeIO localContext = typeContext.findTerm(term).map(TermDefinition::getLocalContext).orElse(null);
                if (localContext == null) continue;
                this.activeContext = this.activeContext.newContext(this.params.options().loader(), this.params.runtime()).propagate(false).build(localContext.node(), localContext.adapter(), this.activeContext.findTerm(term).map(TermDefinition::getBaseUrl).orElse(null));
            }
        }
        return typeKey;
    }

    private String findInputType(String typeKey) throws JsonLdException {
        if (typeKey != null) {
            Object type = this.adapter.property((Object)typeKey, this.element);
            if (this.adapter.isCollection(type)) {
                Optional<String> lastValue = this.adapter.elementStream(type).filter(arg_0 -> ((TreeAdapter)this.adapter).isString(arg_0)).map(arg_0 -> ((TreeAdapter)this.adapter).stringValue(arg_0)).sorted().reduce((first, second) -> second);
                if (lastValue.isPresent()) {
                    return UriExpansion.with(this.activeContext, this.params.options().loader(), this.params.runtime()).vocab(true).expand(lastValue.get());
                }
            } else if (this.adapter.isString(type)) {
                return UriExpansion.with(this.activeContext, this.params.options().loader(), this.params.runtime()).vocab(true).expand(this.adapter.stringValue(type));
            }
        }
        return null;
    }

    private static Map<String, ?> normalizeValue(Map<String, ?> result, String activeProperty, boolean frameExpansion) throws JsonLdException {
        String s;
        Collection c;
        if (LdAdapter.isNotValueNode(result)) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_VALUE_OBJECT);
        }
        if ((result.containsKey("@direction") || result.containsKey("@language")) && result.containsKey("@type")) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_VALUE_OBJECT, "Invalid @value [" + String.valueOf(result) + "]");
        }
        Object type = result.get("@type");
        if (type == null || type instanceof Collection && !(c = (Collection)type).contains("@json") || type instanceof String && !(s = (String)type).equals("@json")) {
            String uri;
            Collection c2;
            Object value = result.get("@value");
            if (value == null || value instanceof Collection && (c2 = (Collection)value).isEmpty()) {
                return null;
            }
            if (!frameExpansion && !(value instanceof String) && result.containsKey("@language")) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_LANGUAGE_TAGGED_VALUE);
            }
            if (!(frameExpansion || type == null || type instanceof String && !UriUtils.isNotURI(uri = (String)type))) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TYPED_VALUE, "Invalid @type [" + String.valueOf(type) + "].");
            }
        }
        return ObjectExpansion.normalize(result, activeProperty, frameExpansion);
    }

    private Map<String, ?> normalizeType(Map<String, Object> result, String activeProperty, boolean frameExpansion) throws JsonLdException {
        Object type = result.get("@type");
        if (!(type instanceof Collection)) {
            result.put("@type", List.of(type));
        }
        return ObjectExpansion.normalize(result, activeProperty, frameExpansion);
    }

    private Object normalizeContainer(Map<String, ?> result, String activeProperty, boolean frameExpansion) throws JsonLdException {
        if (result.size() > 2 || result.size() == 2 && !result.containsKey("@index")) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_SET_OR_LIST_OBJECT, "Invalid object [" + String.valueOf(result) + "].");
        }
        Object set = result.get("@set");
        if (set instanceof Map) {
            Map rawMap;
            Map map = rawMap = (Map)set;
            return ObjectExpansion.normalize(map, activeProperty, frameExpansion);
        }
        if (set != null) {
            return set;
        }
        return ObjectExpansion.normalize(result, activeProperty, frameExpansion);
    }

    private static Map<String, ?> normalize(Map<String, ?> result, String activeProperty, boolean frameExpansion) throws JsonLdException {
        if (result.containsKey("@annotation") && (activeProperty == null || activeProperty.isBlank() || "@graph".equals(activeProperty) || "@included".equals(activeProperty) || !LdAdapter.isAnnotation(result.get("@annotation")))) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_ANNOTATION);
        }
        if (result.size() == 1 && result.containsKey("@language")) {
            return null;
        }
        if (activeProperty == null || "@graph".equals(activeProperty)) {
            if (!frameExpansion && result.isEmpty() || result.containsKey("@value") || result.containsKey("@list")) {
                return null;
            }
            if (!frameExpansion && result.size() == 1 && result.containsKey("@id")) {
                return null;
            }
        }
        return result;
    }
}

