/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.expansion.UriExpansion;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Direction;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeIOException;
import com.apicatalog.tree.io.java.NativeAdapter;
import com.apicatalog.tree.io.java.NativeMaterializer;
import com.apicatalog.web.lang.LanguageTag;
import com.apicatalog.web.uri.UriResolver;
import com.apicatalog.web.uri.UriUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ContextBuilder {
    private static final int MAX_REMOTE_CONTEXTS = 256;
    private static final Logger LOGGER = Logger.getLogger(ContextBuilder.class.getName());
    private final ActiveContext activeContext;
    private final DocumentLoader loader;
    private final Execution runtime;
    private Collection<String> remoteContexts;
    private boolean overrideProtected;
    private boolean propagate;
    private boolean validateScopedContext;
    private ActiveContext result;

    private ContextBuilder(ActiveContext activeContext, DocumentLoader loader, Execution runtime) {
        this.activeContext = activeContext;
        this.loader = loader;
        this.runtime = runtime;
        this.remoteContexts = new ArrayList<String>();
        this.overrideProtected = false;
        this.propagate = true;
        this.validateScopedContext = true;
        this.result = null;
    }

    public static final ContextBuilder with(ActiveContext activeContext, DocumentLoader loader, Execution runtime) {
        return new ContextBuilder(activeContext, loader, runtime);
    }

    public ActiveContext build(TreeIO context, URI baseUrl) throws JsonLdException, IOException {
        return this.build(context.node(), context.adapter(), baseUrl);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ActiveContext build(Object localContext, TreeAdapter adapter, URI baseUrl) throws JsonLdException {
        this.result = new ActiveContext(this.activeContext);
        this.result.setInverseContext(null);
        if (adapter.isMap(localContext) && !adapter.isNull(propagateValue = adapter.property((Object)"@propagate", localContext))) {
            if (!adapter.isBoolean(propagateValue)) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_PROPAGATE_VALUE);
            }
            this.propagate = adapter.isTrue(propagateValue);
        }
        if (!this.propagate && this.result.getPreviousContext() == null) {
            this.result.setPreviousContext(this.activeContext);
        }
        for (T itemContext : adapter.asIterable(localContext)) {
            block57: {
                block58: {
                    block55: {
                        block56: {
                            block52: {
                                block54: {
                                    block53: {
                                        if (adapter.isNull(itemContext)) {
                                            if (!this.overrideProtected && this.result.containsProtectedTerm()) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTEXT_NULLIFICATION);
                                            }
                                            this.result = this.propagate != false ? new ActiveContext(this.activeContext.getBaseUrl(), this.activeContext.getBaseUrl(), this.activeContext.version()) : new ActiveContext(this.activeContext.getBaseUrl(), this.activeContext.getBaseUrl(), this.result.getPreviousContext(), this.activeContext.version());
                                            continue;
                                        }
                                        if (adapter.isString(itemContext)) {
                                            this.fetch(adapter.stringValue(itemContext), baseUrl);
                                            continue;
                                        }
                                        if (!adapter.isMap(itemContext)) {
                                            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_LOCAL_CONTEXT);
                                        }
                                        versionNode = adapter.property((Object)"@version", itemContext);
                                        if (versionNode != null) {
                                            versionString = null;
                                            if (adapter.isString(versionNode)) {
                                                versionString = adapter.stringValue(versionNode);
                                            } else if (adapter.isNumber(versionNode)) {
                                                versionString = versionNode.toString();
                                            }
                                            if (!"1.1".equals(versionString)) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_VERSION_VALUE);
                                            }
                                            if (this.activeContext.isV10()) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.PROCESSING_MODE_CONFLICT);
                                            }
                                            this.result.setVersion(JsonLd.Version.V1_1);
                                        }
                                        contextImport = adapter.property((Object)"@import", itemContext);
                                        contextDefinition /* !! */  = itemContext;
                                        contextAdapter = adapter;
                                        if (contextImport != null) {
                                            if (this.activeContext.isV10()) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTEXT_ENTRY);
                                            }
                                            if (!adapter.isString(contextImport)) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_IMPORT_VALUE, "Invalid context @import value [" + String.valueOf(contextImport) + "].");
                                            }
                                            contextImportUri = UriResolver.resolveAsUri(baseUrl, adapter.stringValue(contextImport));
                                            if (this.loader == null) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED);
                                            }
                                            loaderOptions = new DocumentLoader.Options(false, "http://www.w3.org/ns/json-ld#context", List.of("http://www.w3.org/ns/json-ld#context"));
                                            importedContent = null;
                                            try {
                                                importedDocument = this.loader.loadDocument(contextImportUri, loaderOptions);
                                                if (importedDocument == null) {
                                                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT, "Imported context[" + String.valueOf(contextImportUri) + "] is null.");
                                                }
                                                importedContent = importedDocument.content();
                                            }
                                            catch (JsonLdException e) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_IMPORT_VALUE, (Throwable)e);
                                            }
                                            importedNode = importedContent.node();
                                            importAdapter = importedContent.adapter();
                                            if (!importAdapter.isMap(importedNode)) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT);
                                            }
                                            importedContext = importAdapter.property((Object)"@context", importedNode);
                                            if (importedContext == null || !importAdapter.isMap(importedContext)) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT);
                                            }
                                            if (importAdapter.keys(importedContext).contains("@import")) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTEXT_ENTRY);
                                            }
                                            try {
                                                if (importAdapter.isCompatibleWith((TreeAdapter)NativeAdapter.instance()) && importedContext instanceof Map) {
                                                    map = (Map)importedContext;
                                                    merged = new LinkedHashMap<K, V>(map);
                                                } else {
                                                    merged = new LinkedHashMap<K, V>((Map)NativeMaterializer.node((Object)importedContext, (TreeAdapter)importAdapter));
                                                }
                                                if (importAdapter.isCompatibleWith((TreeAdapter)NativeAdapter.instance()) && contextDefinition /* !! */  instanceof Map) {
                                                    map = (Map)contextDefinition /* !! */ ;
                                                    merged.putAll(map);
                                                } else {
                                                    merged.putAll((Map)NativeMaterializer.node(contextDefinition /* !! */ , (TreeAdapter)adapter));
                                                }
                                            }
                                            catch (TreeIOException e) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.UNSPECIFIED, (Throwable)e);
                                            }
                                            contextAdapter = NativeAdapter.instance();
                                            contextDefinition /* !! */  = merged;
                                        }
                                        if ((baseValue = contextAdapter.property((Object)"@base", contextDefinition /* !! */ )) == null) break block52;
                                        if (!contextAdapter.isNull(baseValue)) break block53;
                                        this.result.setBaseUri(null);
                                        break block52;
                                    }
                                    if (!contextAdapter.isString(baseValue)) break block54;
                                    valueString = contextAdapter.stringValue(baseValue);
                                    v0 = valueUri = valueString != null && valueString.isBlank() == false ? UriUtils.create(valueString) : null;
                                    if (valueUri == null) ** GOTO lbl96
                                    if (valueUri.isAbsolute()) {
                                        this.result.setBaseUri(valueUri);
                                    } else if (this.result.getBaseUri() != null) {
                                        this.result.setBaseUri(UriResolver.resolveAsUri(this.result.getBaseUri(), valueUri));
                                    } else {
                                        ContextBuilder.LOGGER.log(Level.FINE, "5.7.4: valueString={0}, localContext={1}, baseUrl={2}", new Object[]{valueString, localContext, baseUrl});
                                        throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_IRI, "A relative base IRI cannot be resolved [@base = " + valueString + "]. Please use JsonLdOptions.setBase() method to set an absolute IRI.");
lbl96:
                                        // 1 sources

                                        if (valueString != null && !valueString.isBlank()) {
                                            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_IRI, "An invalid base IRI has been detected [@base = " + valueString + "].");
                                        }
                                    }
                                    break block52;
                                }
                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_IRI, "An invalid base IRI has been detected [@base = " + String.valueOf(baseValue) + "].");
                            }
                            if ((vocabValue = contextAdapter.property((Object)"@vocab", contextDefinition /* !! */ )) == null) break block55;
                            if (!contextAdapter.isNull(vocabValue)) break block56;
                            this.result.setVocabularyMapping(null);
                            break block55;
                        }
                        if (!contextAdapter.isString(vocabValue)) ** GOTO lbl116
                        valueString = contextAdapter.stringValue(vocabValue);
                        if (valueString != null && !valueString.isBlank() && !BlankNode.hasPrefix(valueString) && !UriUtils.isURI(valueString)) ** GOTO lbl115
                        vocabularyMapping = UriExpansion.with(this.result, this.loader, this.runtime).vocab(true).documentRelative(true).expand(valueString);
                        if (BlankNode.hasPrefix(valueString) || UriUtils.isURI(vocabularyMapping)) {
                            this.result.setVocabularyMapping(vocabularyMapping);
                        } else {
                            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_VOCAB_MAPPING, "An invalid vocabulary mapping [" + vocabularyMapping + "] has been detected.");
lbl115:
                            // 1 sources

                            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_VOCAB_MAPPING, "An invalid vocabulary mapping [" + valueString + "] has been detected.");
lbl116:
                            // 1 sources

                            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_VOCAB_MAPPING);
                        }
                    }
                    if ((langValue = contextAdapter.property((Object)"@language", contextDefinition /* !! */ )) != null) {
                        if (contextAdapter.isNull(langValue)) {
                            this.result.setDefaultLanguage(null);
                        } else if (contextAdapter.isString(langValue)) {
                            this.result.setDefaultLanguage(contextAdapter.stringValue(langValue));
                            if (!LanguageTag.isWellFormed(this.result.getDefaultLanguage())) {
                                ContextBuilder.LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", this.result.getDefaultLanguage());
                            }
                        } else {
                            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_DEFAULT_LANGUAGE);
                        }
                    }
                    if ((dirValue = contextAdapter.property((Object)"@direction", contextDefinition /* !! */ )) == null) break block57;
                    if (this.activeContext.isV10()) {
                        throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTEXT_ENTRY);
                    }
                    if (!contextAdapter.isNull(dirValue)) break block58;
                    this.result.setDefaultBaseDirection(Direction.NULL);
                    break block57;
                }
                if (!contextAdapter.isString(dirValue)) ** GOTO lbl144
                direction = contextAdapter.stringValue(dirValue);
                if ("ltr".equalsIgnoreCase(direction)) {
                    this.result.setDefaultBaseDirection(Direction.LTR);
                } else if ("rtl".equalsIgnoreCase(direction)) {
                    this.result.setDefaultBaseDirection(Direction.RTL);
                } else {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_DIRECTION);
lbl144:
                    // 1 sources

                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_DIRECTION);
                }
            }
            if ((propagateValue = contextAdapter.property((Object)"@propagate", contextDefinition /* !! */ )) != null) {
                if (this.activeContext.isV10()) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTEXT_ENTRY);
                }
                if (!contextAdapter.isBoolean(propagateValue)) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_PROPAGATE_VALUE, "Expected boolean but got %s".formatted(new Object[]{propagateValue}));
                }
            }
            termBuilder = this.result.newTerm(contextDefinition /* !! */ , contextAdapter, new HashMap<String, Boolean>(), this.loader, this.runtime).baseUrl(baseUrl).overrideProtectedFlag(this.overrideProtected);
            for (E keyValue : contextAdapter.keys(contextDefinition /* !! */ )) {
                if (!(keyValue instanceof String) || !Keywords.noneMatch(key = (String)keyValue, new String[]{"@base", "@direction", "@import", "@language", "@propagate", "@protected", "@version", "@vocab"})) continue;
                termBuilder.protectedFlag(contextAdapter.isTrue(contextAdapter.property((Object)"@protected", contextDefinition /* !! */ ))).remoteContexts(new ArrayList<String>(this.remoteContexts)).create(key);
            }
        }
        return this.result;
    }

    public ContextBuilder remoteContexts(Collection<String> value) {
        this.remoteContexts = value;
        return this;
    }

    public ContextBuilder overrideProtected(boolean value) {
        this.overrideProtected = value;
        return this;
    }

    public ContextBuilder propagate(boolean value) {
        this.propagate = value;
        return this;
    }

    public ContextBuilder validateScopedContext(boolean value) {
        this.validateScopedContext = value;
        return this;
    }

    private void fetch(String uri, URI baseUrl) throws JsonLdException {
        TreeIO importedContent;
        URI contextUri;
        try {
            contextUri = URI.create(uri);
            if (baseUrl != null) {
                contextUri = UriResolver.resolveAsUri(baseUrl, contextUri);
            }
            if (!contextUri.isAbsolute()) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Context URI is not absolute [" + String.valueOf(contextUri) + "].");
            }
        }
        catch (IllegalArgumentException e) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Context URI is not URI [" + uri + "].");
        }
        String contextKey = contextUri.toString();
        if (!this.validateScopedContext && this.remoteContexts.contains(contextKey)) {
            return;
        }
        if (this.remoteContexts.size() > 256) {
            throw new JsonLdException(JsonLdException.ErrorCode.CONTEXT_OVERFLOW, "Too many contexts [>256].");
        }
        this.remoteContexts.add(contextKey);
        if (this.loader == null) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(contextUri) + "].");
        }
        Document remoteDocument = null;
        if (remoteDocument == null) {
            DocumentLoader.Options loaderOptions = new DocumentLoader.Options(false, "http://www.w3.org/ns/json-ld#context", List.of("http://www.w3.org/ns/json-ld#context"));
            try {
                remoteDocument = this.loader.loadDocument(contextUri, loaderOptions);
            }
            catch (JsonLdException e) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "There was a problem encountered loading a remote context [" + String.valueOf(contextUri) + "]", e);
            }
            if (remoteDocument == null) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is null.");
            }
        }
        if (!TreeIO.isMap((TreeIO)(importedContent = remoteDocument.content()))) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is not valid JSON-LD context: " + String.valueOf(importedContent.node()) + ".");
        }
        LinkedHashMap importedContext = importedContent.property("@context");
        if (importedContext == null) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT, "Imported context does not contain @context key and is not valid JSON-LD context.");
        }
        LinkedHashMap newContext = importedContext;
        TreeAdapter newContextAdapter = importedContent.adapter();
        if (newContextAdapter.isMap((Object)newContext) && newContextAdapter.keys((Object)newContext).contains("@base")) {
            try {
                Map map;
                newContext = NativeMaterializer.node((Object)importedContext, (TreeAdapter)importedContent.adapter());
                newContextAdapter = NativeAdapter.instance();
                if (newContext instanceof Map && (map = (Map)newContext).containsKey("@base")) {
                    LinkedHashMap hashMap = new LinkedHashMap(map);
                    hashMap.remove("@base");
                    newContext = hashMap;
                }
            }
            catch (TreeIOException e) {
                throw new JsonLdException(JsonLdException.ErrorCode.UNSPECIFIED, (Throwable)e);
            }
        }
        try {
            this.result = this.result.newContext(this.loader, this.runtime).remoteContexts(new ArrayList<String>(this.remoteContexts)).validateScopedContext(this.validateScopedContext).build(newContext, newContextAdapter, remoteDocument.url());
        }
        catch (JsonLdException e) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED, (Throwable)e);
        }
    }
}

