/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.ContextBuilder;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.InverseContextBuilder;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.context.TermDefinitionBuilder;
import com.apicatalog.jsonld.context.TermSelector;
import com.apicatalog.jsonld.lang.Direction;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.tree.io.TreeAdapter;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

final class ActiveContext
implements Context {
    private final Map<String, TermDefinition> terms;
    private JsonLd.Version version;
    private URI baseUri;
    private URI baseUrl;
    private InverseContext inverseContext;
    private ActiveContext previousContext;
    private String vocabularyMapping;
    private String defaultLanguage;
    private Direction defaultBaseDirection;

    ActiveContext(JsonLd.Version version) {
        this(null, null, null, version);
    }

    ActiveContext(URI baseUri, URI baseUrl, JsonLd.Version version) {
        this(baseUri, baseUrl, null, version);
    }

    ActiveContext(URI baseUri, URI baseUrl, ActiveContext previousContext, JsonLd.Version version) {
        this.baseUri = baseUri;
        this.baseUrl = baseUrl;
        this.previousContext = previousContext;
        this.terms = new LinkedHashMap<String, TermDefinition>();
        this.version = version;
    }

    ActiveContext(ActiveContext origin) {
        this.terms = new LinkedHashMap<String, TermDefinition>(origin.terms);
        this.baseUri = origin.baseUri;
        this.baseUrl = origin.baseUrl;
        this.inverseContext = origin.inverseContext;
        this.previousContext = origin.previousContext;
        this.vocabularyMapping = origin.vocabularyMapping;
        this.defaultLanguage = origin.defaultLanguage;
        this.defaultBaseDirection = origin.defaultBaseDirection;
        this.version = origin.version;
    }

    @Override
    public void createInverseContext() {
        this.inverseContext = InverseContextBuilder.with(this).build();
    }

    public boolean containsProtectedTerm() {
        return this.terms.values().stream().anyMatch(TermDefinition::isProtected);
    }

    @Override
    public boolean containsTerm(String term) {
        return this.terms.containsKey(term);
    }

    @Override
    public Optional<TermDefinition> findTerm(String value) {
        return Optional.ofNullable(this.terms.get(value));
    }

    protected Optional<TermDefinition> removeTerm(String term) {
        if (this.terms.containsKey(term)) {
            return Optional.of(this.terms.remove(term));
        }
        return Optional.empty();
    }

    @Override
    public Direction getDefaultBaseDirection() {
        return this.defaultBaseDirection;
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public String getVocabularyMapping() {
        return this.vocabularyMapping;
    }

    @Override
    public ActiveContext getPreviousContext() {
        return this.previousContext;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    @Override
    public InverseContext getInverseContext() {
        return this.inverseContext;
    }

    @Override
    public Map<String, TermDefinition> getTermsMapping() {
        return this.terms;
    }

    public Collection<String> getTerms() {
        return this.terms.keySet();
    }

    @Override
    public ContextBuilder newContext(DocumentLoader loader, Execution runtime) {
        return ContextBuilder.with(this, loader, runtime);
    }

    @Override
    public TermDefinitionBuilder newTerm(Object localContext, TreeAdapter adapter, Map<String, Boolean> defined, DocumentLoader loader, Execution runtime) {
        return TermDefinitionBuilder.with(this, localContext, adapter, defined, loader, runtime);
    }

    @Override
    public Optional<String> selectTerm(Collection<String> preferredValues, String variable, Collection<String> containerMapping, String typeLanguage) {
        return TermSelector.match(preferredValues, this, variable, containerMapping, typeLanguage);
    }

    protected void setDefaultBaseDirection(Direction defaultBaseDirection) {
        this.defaultBaseDirection = defaultBaseDirection;
    }

    protected void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    protected void setVocabularyMapping(String vocabularyMapping) {
        this.vocabularyMapping = vocabularyMapping;
    }

    protected void setPreviousContext(ActiveContext previousContext) {
        this.previousContext = previousContext;
    }

    protected void setInverseContext(InverseContext inverseContext) {
        this.inverseContext = inverseContext;
    }

    protected void setTerm(String term, TermDefinition definition) {
        this.terms.put(term, definition);
    }

    public String toString() {
        return "ActiveContext[uri=" + String.valueOf(this.baseUri) + ", terms=" + String.valueOf(this.terms) + ", previousContext=" + String.valueOf(this.previousContext) + "]";
    }

    @Override
    public JsonLd.Version version() {
        return this.version;
    }

    public void setVersion(JsonLd.Version version) {
        this.version = version;
    }
}

