/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.compaction;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.tree.io.java.NativeAdapter;
import com.apicatalog.web.uri.UriRelativizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class UriCompaction {
    public static String compact(Context context, String variable, Options options) throws JsonLdException {
        return UriCompaction.compact(context, variable, null, false, false, options);
    }

    public static String withVocab(Context context, String variable, Options options) throws JsonLdException {
        return UriCompaction.compact(context, variable, null, true, false, options);
    }

    public static String withVocab(Context context, String variable, Object value, boolean reverse, Options options) throws JsonLdException {
        return UriCompaction.compact(context, variable, value, true, reverse, options);
    }

    private static String compact(Context context, String variable, Object value, boolean vocab, boolean reverse, Options options) throws JsonLdException {
        String suffix;
        if (variable == null) {
            return null;
        }
        if (context.getInverseContext() == null) {
            context.createInverseContext();
        }
        InverseContext inverseContext = context.getInverseContext();
        Object node = value;
        if (vocab && inverseContext.contains(variable)) {
            Object valueMap;
            Map map;
            Map map2;
            Map valueMap2;
            Map map3;
            Object preserve;
            Map map4;
            Object defaultLanguage = "@none";
            if (context.getDefaultLanguage() != null) {
                defaultLanguage = context.getDefaultLanguage().toLowerCase();
                if (context.getDefaultBaseDirection() != null) {
                    defaultLanguage = (String)defaultLanguage + "_".concat(context.getDefaultBaseDirection().name().toLowerCase());
                }
            } else if (context.getDefaultBaseDirection() != null) {
                defaultLanguage = "_".concat(context.getDefaultBaseDirection().name().toLowerCase());
            }
            if (node instanceof Map && (map4 = (Map)node).containsKey("@preserve") && (preserve = map4.get("@preserve")) != null) {
                node = NativeAdapter.asCollection(preserve).iterator().next();
            }
            ArrayList containers = new ArrayList();
            String typeLanguage = "@language";
            Object typeLanguageValue = "@null";
            if (node instanceof Map && (map3 = (Map)node).containsKey("@index") && LdAdapter.isNotGraph(map3)) {
                containers.add("@index");
                containers.add("@index".concat("@set"));
            }
            if (reverse) {
                typeLanguage = "@type";
                typeLanguageValue = "@reverse";
                containers.add("@set");
            } else if (node instanceof Map && LdAdapter.isList(valueMap2 = (Map)node)) {
                if (!valueMap2.containsKey("@index")) {
                    containers.add("@list");
                }
                Collection list = (Collection)valueMap2.get("@list");
                String commonType = null;
                commonLanguage = list.isEmpty() ? defaultLanguage : null;
                for (Object item : list) {
                    Map itemMap;
                    Map map5;
                    Object itemLanguage = "@none";
                    String itemType = "@none";
                    if (item instanceof Map && (map5 = (Map)item).containsKey("@value")) {
                        Object v = map5.get("@direction");
                        if (v instanceof String) {
                            String dirString = (String)v;
                            itemLanguage = "";
                            Object v2 = map5.get("@language");
                            if (v2 instanceof String) {
                                String langString = (String)v2;
                                itemLanguage = langString.toLowerCase();
                            }
                            itemLanguage = (String)itemLanguage + "_".concat(dirString.toLowerCase());
                        } else {
                            v = map5.get("@language");
                            if (v instanceof String) {
                                String langString = (String)v;
                                itemLanguage = langString.toLowerCase();
                            } else {
                                v = map5.get("@type");
                                if (v instanceof String) {
                                    String typeString;
                                    itemType = typeString = (String)v;
                                } else {
                                    itemLanguage = "@null";
                                }
                            }
                        }
                    } else {
                        itemType = "@id";
                    }
                    if (commonLanguage == null) {
                        commonLanguage = itemLanguage;
                    } else if (!Objects.equals(itemLanguage, commonLanguage) && item instanceof Map && (itemMap = (Map)item).containsKey("@value")) {
                        commonLanguage = "@none";
                    }
                    if (commonType == null) {
                        commonType = itemType;
                    } else if (!Objects.equals(itemType, commonType)) {
                        commonType = "@none";
                    }
                    if (!"@none".equals(commonLanguage) || !"@none".equals(commonType)) continue;
                    break;
                }
                if (commonLanguage == null) {
                    commonLanguage = "@none";
                }
                if (commonType == null) {
                    commonType = "@none";
                }
                if (!"@none".equals(commonType)) {
                    typeLanguage = "@type";
                    typeLanguageValue = commonType;
                } else {
                    typeLanguageValue = commonLanguage;
                }
            } else if (node instanceof Map && LdAdapter.isGraph(map2 = (Map)node)) {
                if (map2.containsKey("@index")) {
                    containers.add("@graph".concat("@index"));
                    containers.add("@graph".concat("@index").concat("@set"));
                }
                if (map2.containsKey("@id")) {
                    containers.add("@graph".concat("@id"));
                    containers.add("@graph".concat("@id").concat("@set"));
                }
                containers.add("@graph");
                containers.add("@graph".concat("@set"));
                containers.add("@set");
                if (!map2.containsKey("@index")) {
                    containers.add("@graph".concat("@index"));
                    containers.add("@graph".concat("@index").concat("@set"));
                }
                if (!map2.containsKey("@id")) {
                    containers.add("@graph".concat("@id"));
                    containers.add("@graph".concat("@id").concat("@set"));
                }
                containers.add("@index");
                containers.add("@index".concat("@set"));
                typeLanguage = "@type";
                typeLanguageValue = "@id";
            } else {
                if (node instanceof Map && LdAdapter.isValueNode(map = (Map)node)) {
                    if (map.containsKey("@direction") && !map.containsKey("@index")) {
                        typeLanguageValue = "";
                        commonLanguage = map.get("@language");
                        if (commonLanguage instanceof String) {
                            langString = (String)commonLanguage;
                            typeLanguageValue = langString.toLowerCase();
                        }
                        if ((commonLanguage = map.get("@direction")) instanceof String) {
                            String dirString = (String)commonLanguage;
                            typeLanguageValue = (String)typeLanguageValue + "_".concat(dirString.toLowerCase());
                        }
                        containers.add("@language");
                        containers.add("@language".concat("@set"));
                    } else if (map.containsKey("@language") && !map.containsKey("@index")) {
                        commonLanguage = map.get("@language");
                        if (commonLanguage instanceof String) {
                            langString = (String)commonLanguage;
                            typeLanguageValue = langString.toLowerCase();
                        }
                        containers.add("@language");
                        containers.add("@language".concat("@set"));
                    } else if (map.containsKey("@type")) {
                        typeLanguage = "@type";
                        typeLanguageValue = (String)map.get("@type");
                    }
                } else {
                    typeLanguage = "@type";
                    typeLanguageValue = "@id";
                    containers.add("@id");
                    containers.add("@id".concat("@set"));
                    containers.add("@type");
                    containers.add("@set".concat("@type"));
                }
                containers.add("@set");
            }
            containers.add("@none");
            if (!(context.isV10() || node instanceof Map && (map3 = (Map)node).containsKey("@index"))) {
                containers.add("@index");
                containers.add("@index".concat("@set"));
            }
            if (!context.isV10() && node instanceof Map && (map3 = (Map)node).size() == 1 && map3.containsKey("@value")) {
                containers.add("@language");
                containers.add("@language".concat("@set"));
            }
            if (typeLanguageValue == null) {
                typeLanguageValue = "@null";
            }
            ArrayList<String> preferredValues = new ArrayList<String>();
            if ("@reverse".equals(typeLanguageValue)) {
                preferredValues.add("@reverse");
            }
            if (("@reverse".equals(typeLanguageValue) || "@id".equals(typeLanguageValue)) && node instanceof Map && (valueMap = (Map)node).containsKey("@id")) {
                Object idValue = valueMap.get("@id");
                if (options.isRdfStar() && LdAdapter.isEmbedded(idValue)) {
                    preferredValues.add("@id");
                    preferredValues.add("@vocab");
                } else if (idValue instanceof String) {
                    String idString = (String)idValue;
                    String compactedIdValue = UriCompaction.withVocab(context, idString, options);
                    Optional<TermDefinition> compactedIdValueTermDefinition = context.findTerm(compactedIdValue);
                    if (compactedIdValueTermDefinition.map(TermDefinition::getUriMapping).filter(idString::equals).isPresent()) {
                        preferredValues.add("@vocab");
                        preferredValues.add("@id");
                    } else {
                        preferredValues.add("@id");
                        preferredValues.add("@vocab");
                    }
                } else {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_ID_VALUE, "An @id entry was encountered whose value was not a string but [" + String.valueOf(idValue) + "].");
                }
                preferredValues.add("@none");
            } else {
                Collection array;
                Object v;
                preferredValues.add((String)typeLanguageValue);
                preferredValues.add("@none");
                if (node instanceof Map && LdAdapter.isList(map = (Map)node) && (v = map.get("@list")) instanceof Collection && (array = (Collection)v).isEmpty()) {
                    typeLanguage = "@any";
                }
            }
            preferredValues.add("@any");
            for (String preferredValue : new ArrayList(preferredValues)) {
                int index = preferredValue.indexOf(95);
                if (index == -1) continue;
                preferredValues.add(preferredValue.substring(index));
            }
            Optional<String> term = context.selectTerm(preferredValues, variable, containers, typeLanguage);
            if (term.isPresent()) {
                return term.get();
            }
        }
        if (vocab && context.getVocabularyMapping() != null && variable.startsWith(context.getVocabularyMapping()) && variable.length() > context.getVocabularyMapping().length() && !context.containsTerm(suffix = variable.substring(context.getVocabularyMapping().length()))) {
            return suffix;
        }
        String compactUri = null;
        for (Map.Entry<String, TermDefinition> termEntry : context.getTermsMapping().entrySet()) {
            TermDefinition termDefinition = termEntry.getValue();
            if (termDefinition.getUriMapping() == null || variable.equals(termDefinition.getUriMapping()) || !variable.startsWith(termDefinition.getUriMapping()) || termDefinition.isNotPrefix()) continue;
            String compactUriCandidate = termEntry.getKey().concat(":").concat(variable.substring(termDefinition.getUriMapping().length()));
            if ((compactUri != null && compactUriCandidate.compareTo(compactUri) >= 0 || context.containsTerm(compactUriCandidate)) && (!context.findTerm(compactUriCandidate).map(TermDefinition::getUriMapping).filter(u -> u.equals(variable)).isPresent() || node != null)) continue;
            compactUri = compactUriCandidate;
        }
        if (compactUri != null) {
            return compactUri;
        }
        try {
            URI uri = URI.create(variable);
            if (uri != null && uri.isAbsolute() && uri.getScheme() != null && uri.getAuthority() == null && context.findTerm(uri.getScheme()).filter(TermDefinition::isPrefix).isPresent()) {
                throw new JsonLdException(JsonLdException.ErrorCode.IRI_CONFUSED_WITH_PREFIX);
            }
        }
        catch (IllegalArgumentException uri) {
            // empty catch block
        }
        if (!vocab && context.getBaseUri() != null && !BlankNode.hasPrefix(variable)) {
            String relativeUri = UriRelativizer.relativize(context.getBaseUri(), variable);
            return Keywords.matchForm(relativeUri) ? "./".concat(relativeUri) : relativeUri;
        }
        return variable;
    }
}

