/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.fromrdf.QuadsToJsonLd;
import com.apicatalog.jsonld.processor.Compactor;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.jsonld.processor.Expander;
import com.apicatalog.jsonld.processor.Flattener;
import com.apicatalog.jsonld.processor.Framer;
import com.apicatalog.jsonld.processor.RdfEmitter;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class JsonLd {
    private JsonLd() {
    }

    public static final Collection<?> expand(URI document, Options options) throws JsonLdException {
        return Expander.expand(Document.load(document, options.loader(), options.isExtractAllScripts()), options, Execution.of(options).start());
    }

    public static final Collection<?> expand(Document document, Options options) throws JsonLdException {
        return Expander.expand(document, options, Execution.of(options).start());
    }

    public static final Collection<?> expand(Map<String, ?> document, Options options) throws JsonLdException {
        return JsonLd.expand(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), options);
    }

    public static final Collection<?> expand(TreeIO document, Options options) throws JsonLdException {
        return Expander.expand(document, options, Execution.of(options).start());
    }

    public static final Map<String, ?> compact(URI document, URI context, Options options) throws JsonLdException {
        return JsonLd.compact(Document.load(document, options.loader(), options.isExtractAllScripts()), Context.load(context, options.loader()), options);
    }

    public static final Map<String, ?> compact(URI document, Document context, Options options) throws JsonLdException {
        return JsonLd.compact(Document.load(document, options.loader(), options.isExtractAllScripts()), context, options);
    }

    public static final Map<String, ?> compact(Document document, URI context, Options options) throws JsonLdException {
        return JsonLd.compact(document, Context.load(context, options.loader()), options);
    }

    public static final Map<String, ?> compact(Document document, Document context, Options options) throws JsonLdException {
        return Compactor.compact(document, context, options, Execution.of(options).start());
    }

    public static final Map<String, ?> compact(TreeIO document, TreeIO context, Options options) throws JsonLdException {
        Execution runtime = Execution.of(options).start();
        return Compactor.compact(Compactor.expand(document, options, runtime), null, context, options, runtime);
    }

    public static final Map<String, ?> compact(Collection<?> document, Map<String, ?> context, Options options) throws JsonLdException {
        return JsonLd.compact(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), new TreeIO(context, (TreeAdapter)NativeAdapter.instance()), options);
    }

    public static final Object flatten(URI document, Options options) throws JsonLdException {
        return Flattener.flatten(Document.load(document, options.loader(), options.isExtractAllScripts()), null, options, Execution.of(options).start());
    }

    public static final Object flatten(URI document, URI context, Options options) throws JsonLdException {
        return Flattener.flatten(Document.load(document, options.loader(), options.isExtractAllScripts()), context != null ? Context.load(context, options.loader()).content() : null, options, Execution.of(options).start());
    }

    public static final Object flatten(Document document, Options options) throws JsonLdException {
        return Flattener.flatten(document, null, options, Execution.of(options).start());
    }

    public static final Object flatten(Document document, Document context, Options options) throws JsonLdException {
        return Flattener.flatten(document, context != null ? context.content() : null, options, Execution.of(options).start());
    }

    public static final Object flatten(Map<String, ?> document, Options options) throws JsonLdException {
        return JsonLd.flatten(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), null, options);
    }

    public static final Object flatten(Map<String, ?> document, Map<String, ?> context, Options options) throws JsonLdException {
        return JsonLd.flatten(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), context != null ? new TreeIO(context, (TreeAdapter)NativeAdapter.instance()) : null, options);
    }

    public static final Object flatten(Collection<?> document, Options options) throws JsonLdException {
        return JsonLd.flatten(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), null, options);
    }

    public static final Object flatten(Collection<?> document, Map<String, ?> context, Options options) throws JsonLdException {
        return JsonLd.flatten(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), context != null ? new TreeIO(context, (TreeAdapter)NativeAdapter.instance()) : null, options);
    }

    public static final Object flatten(TreeIO document, Options options) throws JsonLdException {
        return Flattener.flatten(document, null, options, Execution.of(options).start());
    }

    public static final Object flatten(TreeIO document, TreeIO context, Options options) throws JsonLdException {
        return Flattener.flatten(document, context, options, Execution.of(options).start());
    }

    public static final Map<String, ?> frame(URI document, URI frame, Options options) throws JsonLdException {
        return JsonLd.frame(Document.load(document, options.loader(), options.isExtractAllScripts()), frame, options);
    }

    public static final Map<String, ?> frame(Document document, URI frame, Options options) throws JsonLdException {
        return JsonLd.frame(document, Document.load(frame, options.loader(), options.isExtractAllScripts()), options);
    }

    public static final Map<String, ?> frame(URI document, Document frame, Options options) throws JsonLdException {
        return JsonLd.frame(Document.load(document, options.loader(), options.isExtractAllScripts()), frame, options);
    }

    public static final Map<String, ?> frame(Document document, Document frame, Options options) throws JsonLdException {
        return Framer.frame(document, frame, options, Execution.of(options).start());
    }

    public static final Map<String, ?> frame(Map<String, ?> document, Map<String, ?> frame, Options options) throws JsonLdException {
        return JsonLd.frame(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), new TreeIO(frame, (TreeAdapter)NativeAdapter.instance()), options);
    }

    public static final Map<String, ?> frame(TreeIO document, TreeIO frame, Options options) throws JsonLdException {
        Execution runtime = Execution.of(options).start();
        TreeIO contextNode = Context.extract(frame);
        return Context.inject(Framer.frame(Framer.expand(document, options, runtime), Frame.of(frame, options, runtime), Framer.context(null, contextNode, options.base(), options, runtime), options), contextNode);
    }

    public static final void toRdf(URI uri, RdfQuadConsumer consumer, Options options) throws JsonLdException {
        JsonLd.toRdf(Document.load(uri, options.loader(), options.isExtractAllScripts()), consumer, options);
    }

    public static final void toRdf(Document document, RdfQuadConsumer consumer, Options options) throws JsonLdException {
        RdfEmitter.toRdf(document, consumer, options, Execution.of(options).start());
    }

    public static final void toRdf(TreeIO document, RdfQuadConsumer consumer, Options options) throws JsonLdException {
        RdfEmitter.toRdf(document, consumer, options, Execution.of(options).start());
    }

    public static final void toRdf(Map<String, ?> document, RdfQuadConsumer consumer, Options options) throws JsonLdException {
        RdfEmitter.toRdf(new TreeIO(document, (TreeAdapter)NativeAdapter.instance()), consumer, options, Execution.of(options).start());
    }

    public static final QuadsToJsonLd fromRdf() {
        return new QuadsToJsonLd();
    }

    public static final QuadsToJsonLd fromRdf(Options options) {
        return new QuadsToJsonLd().options(options);
    }

    public static enum Version {
        V1_0("json-ld-1.0"),
        V1_1("json-ld-1.1");

        private final String text;

        private Version(String text) {
            this.text = text;
        }

        public static Version of(String version) {
            Objects.requireNonNull(version);
            if ("1.1".equals(version) || Version.V1_1.text.equalsIgnoreCase(version)) {
                return V1_1;
            }
            if ("1.0".equals(version) || Version.V1_0.text.equalsIgnoreCase(version)) {
                return V1_0;
            }
            return null;
        }

        public String toString() {
            return this.text;
        }
    }
}

