/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.tree.io.NodeType;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Comparison {
    private Comparison() {
    }

    public static final boolean equals(Object value1, Object value2, TreeAdapter adapter) {
        return Comparison.equals(value1, adapter, value2, adapter, null);
    }

    public static final boolean equals(Object value1, TreeAdapter adapter1, Object value2, TreeAdapter adapter2) {
        return Comparison.equals(value1, adapter1, value2, adapter2, null);
    }

    private static final boolean equals(Object value1, TreeAdapter adapter1, Object value2, TreeAdapter adapter2, String parentProperty) {
        NodeType type1 = adapter1.type(value1);
        if (type1 == NodeType.TREE_IO) {
            return Comparison.equals(((TreeIO)value1).node(), ((TreeIO)value1).adapter(), value2, adapter2, parentProperty);
        }
        NodeType type2 = adapter2.type(value2);
        if (type2 == NodeType.TREE_IO) {
            return Comparison.equals(value1, adapter1, ((TreeIO)value2).node(), ((TreeIO)value2).adapter(), parentProperty);
        }
        if (type1 != type2) {
            return false;
        }
        boolean nativeEquals = adapter1.isCompatibleWith(adapter2);
        return switch (type1) {
            case NodeType.NULL, NodeType.TRUE, NodeType.FALSE -> true;
            case NodeType.STRING -> {
                if (nativeEquals) {
                    yield Objects.equals(value1, value2);
                }
                yield Objects.equals(adapter1.stringValue(value1), adapter2.stringValue(value2));
            }
            case NodeType.NUMBER -> {
                if (nativeEquals) {
                    yield Objects.equals(value1, value2);
                }
                yield Objects.equals(adapter1.numericValue(value1), adapter2.numericValue(value2));
            }
            case NodeType.BINARY -> {
                if (nativeEquals) {
                    yield Objects.equals(value1, value2);
                }
                yield Objects.equals(adapter1.binaryValue(value1), adapter2.binaryValue(value2));
            }
            case NodeType.COLLECTION -> Comparison.arrayEquals(value1, adapter1, value2, adapter2, parentProperty);
            case NodeType.MAP -> Comparison.objectEquals(value1, adapter1, value2, adapter2);
            case NodeType.TREE_IO -> throw new IllegalStateException();
            default -> false;
        };
    }

    private static final boolean objectEquals(Object map1, TreeAdapter adapter1, Object map2, TreeAdapter adapter2) {
        List it1 = adapter1.entryStream(map1).toList();
        if ((long)it1.size() != adapter2.keyStream(map2).count()) {
            return false;
        }
        for (Map.Entry entry1 : it1) {
            Object prop2 = adapter2.property(entry1.getKey(), adapter1, map2);
            if (Comparison.equals(entry1.getValue(), adapter1, prop2, adapter2, adapter1.asString(entry1.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static final boolean arrayEquals(Object array1, TreeAdapter adapter1, Object array2, TreeAdapter adapter2, String parentProperty) {
        if ("@list".equals(parentProperty)) {
            Iterator it1 = adapter1.elements(array1).iterator();
            Iterator it2 = adapter2.elements(array2).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (Comparison.equals(it1.next(), adapter1, it2.next(), adapter2)) continue;
                return false;
            }
            return !it1.hasNext() && !it2.hasNext();
        }
        return Comparison.arraysEqualsUnordered(array1, adapter1, array2, adapter2);
    }

    private static final boolean arraysEqualsUnordered(Object array1, TreeAdapter adapter1, Object array2, TreeAdapter adapter2) {
        List list1 = adapter1.elementStream(array1).toList();
        List list2 = adapter2.elementStream(array2).toList();
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1.isEmpty()) {
            return true;
        }
        ArrayList remaining = new ArrayList(list2);
        for (Object item1 : list1) {
            boolean found = false;
            for (Object item2 : remaining) {
                found = Comparison.equals(item1, adapter1, item2, adapter2);
                if (!found) continue;
                remaining.remove(item2);
                break;
            }
            if (found) continue;
            return false;
        }
        return remaining.isEmpty();
    }
}

