/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.serialization.GraphMap;
import com.apicatalog.jsonld.serialization.RdfToObject;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraph;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class RdfToJsonld {
    private RdfDataset dataset;
    private boolean ordered;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private boolean useRdfType;
    private boolean uriValidation;
    private JsonLdVersion processingMode;
    private GraphMap graphMap;
    private Map<String, Map<String, Boolean>> compoundLiteralSubjects;
    private Map<String, Reference> referenceOnce;

    private RdfToJsonld(RdfDataset dataset) {
        this.dataset = dataset;
        this.ordered = false;
        this.rdfDirection = null;
        this.useNativeTypes = false;
        this.useRdfType = false;
        this.uriValidation = true;
    }

    public static final RdfToJsonld with(RdfDataset dataset) {
        return new RdfToJsonld(dataset);
    }

    public RdfToJsonld ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public RdfToJsonld rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfToJsonld useNativeTypes(boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
        return this;
    }

    public RdfToJsonld useRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
        return this;
    }

    public RdfToJsonld processingMode(JsonLdVersion processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    public JsonArray build() throws JsonLdError {
        this.graphMap = new GraphMap();
        this.referenceOnce = new LinkedHashMap<String, Reference>();
        this.compoundLiteralSubjects = new LinkedHashMap<String, Map<String, Boolean>>();
        this.step5("@default", this.dataset.getDefaultGraph());
        for (RdfResource rdfResource : this.dataset.getGraphNames()) {
            this.step5(rdfResource.getValue(), this.dataset.getGraph(rdfResource).orElse(null));
        }
        for (String string : this.graphMap.keys()) {
            if (this.compoundLiteralSubjects.containsKey(string)) {
                for (String cl : this.compoundLiteralSubjects.get(string).keySet()) {
                    Reference clEntry = this.referenceOnce.get(cl);
                    if (clEntry == null) continue;
                    Optional<Map<String, JsonValue>> clNodeValue = this.graphMap.get(string, cl);
                    this.graphMap.remove(string, cl);
                    if (!clNodeValue.isPresent()) continue;
                    Map<String, JsonValue> clNode = clNodeValue.get();
                    JsonArrayBuilder clArray = Json.createArrayBuilder();
                    for (JsonValue clReference : this.graphMap.get(clEntry.graphName, clEntry.subject, clEntry.property).map(JsonValue::asJsonArray).orElse(JsonValue.EMPTY_JSON_ARRAY)) {
                        JsonObject clReferenceObject;
                        if (JsonUtils.isNotObject(clReference) || !(clReferenceObject = clReference.asJsonObject()).containsKey((Object)"@id") || !cl.equals(clReference.asJsonObject().getString("@id"))) continue;
                        JsonObjectBuilder clObject = Json.createObjectBuilder((JsonObject)clReferenceObject);
                        clObject.remove("@id");
                        clObject.add("@value", JsonUtils.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#value"), "@value"));
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#language")) {
                            JsonValue lang = JsonUtils.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#language"), "@value");
                            if (JsonUtils.isNotString(lang) || !LanguageTag.isWellFormed(((JsonString)lang).getString())) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_STRING);
                            }
                            clObject.add("@language", lang);
                        }
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction")) {
                            JsonValue direction = JsonUtils.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction"), "@value");
                            if (JsonUtils.isNotString(direction) || !"ltr".equalsIgnoreCase(((JsonString)direction).getString()) && !"rtl".equalsIgnoreCase(((JsonString)direction).getString())) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                            }
                            clObject.add("@direction", direction);
                        }
                        clArray.add(clObject);
                    }
                    this.graphMap.set(clEntry.graphName, clEntry.subject, clEntry.property, (JsonValue)clArray.build());
                }
            }
            if (!this.graphMap.contains(string, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) continue;
            for (Reference usage : this.graphMap.getUsages(string, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
                Map<String, JsonValue> node = this.graphMap.get(usage.graphName, usage.subject).orElseGet(() -> Collections.emptyMap());
                JsonArrayBuilder list = Json.createArrayBuilder();
                ArrayList<String> listNodes = new ArrayList<String>();
                String nodeId = ((JsonString)node.get("@id")).getString();
                while ("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest".equals(usage.property) && BlankNode.isWellFormed(nodeId) && this.referenceOnce.get(nodeId) != null && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#first") && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest") && ((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).asJsonArray().size() == 1 && ((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")).asJsonArray().size() == 1 && (node.size() == 3 || node.size() == 4 && node.containsKey("@type") && ((JsonValue)node.get("@type")).asJsonArray().size() == 1 && ((JsonValue)node.get("@type")).asJsonArray().contains((Object)Json.createValue((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#List")))) {
                    list.add(0, (JsonValue)((JsonValue)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).asJsonArray().get(0));
                    listNodes.add(nodeId);
                    usage = this.referenceOnce.get(nodeId);
                    Optional<Map<String, JsonValue>> nextNode = this.graphMap.get(usage.graphName, usage.subject);
                    if (nextNode.isPresent() && (node = nextNode.get()).containsKey("@id") && !UriUtils.isAbsoluteUri(nodeId = ((JsonString)node.get("@id")).getString(), this.uriValidation)) continue;
                    break;
                }
                JsonObject head = usage.value;
                head.remove((Object)"@id");
                head.put((Object)"@list", (Object)list.build());
                listNodes.forEach(nid -> this.graphMap.remove(string, (String)nid));
            }
        }
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (String subject : Utils.index(this.graphMap.keys("@default"), this.ordered)) {
            Map node = this.graphMap.get("@default", subject).orElseGet(() -> new LinkedHashMap());
            if (this.graphMap.contains(subject)) {
                JsonArrayBuilder array = Json.createArrayBuilder();
                for (String key : Utils.index(this.graphMap.keys(subject), this.ordered)) {
                    Map entry = this.graphMap.get(subject, key).orElseGet(() -> Collections.emptyMap());
                    if (entry.size() <= 1 && entry.containsKey("@id")) continue;
                    array.add((JsonValue)JsonUtils.toJsonObject(entry));
                }
                node.put("@graph", array.build());
            }
            if (node.size() <= 1 && node.containsKey("@id")) continue;
            result.add((JsonValue)JsonUtils.toJsonObject(node));
        }
        return result.build();
    }

    private void step5(String graphName, RdfGraph graph) throws JsonLdError {
        if (!this.compoundLiteralSubjects.containsKey(graphName)) {
            this.compoundLiteralSubjects.put(graphName, new LinkedHashMap());
        }
        if (!"@default".equals(graphName) && !this.graphMap.contains("@default", graphName)) {
            this.graphMap.set("@default", graphName, "@id", (JsonValue)Json.createValue((String)graphName));
        }
        Map<String, Boolean> compoundMap = this.compoundLiteralSubjects.get(graphName);
        for (RdfTriple triple : graph.toList()) {
            Reference reference;
            String subject = triple.getSubject().toString();
            String predicate = triple.getPredicate().toString();
            if (!this.graphMap.contains(graphName, subject)) {
                this.graphMap.set(graphName, subject, "@id", (JsonValue)Json.createValue((String)subject));
            }
            if (JsonLdOptions.RdfDirection.COMPOUND_LITERAL == this.rdfDirection && "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction".equals(predicate)) {
                compoundMap.put(subject, Boolean.TRUE);
            }
            if ((triple.getObject().isBlankNode() || triple.getObject().isIRI()) && !this.graphMap.contains(graphName, triple.getObject().toString())) {
                this.graphMap.set(graphName, triple.getObject().toString(), "@id", (JsonValue)Json.createValue((String)triple.getObject().toString()));
            }
            if (!this.useRdfType && "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(predicate) && !triple.getObject().isLiteral()) {
                Optional<JsonValue> type = this.graphMap.get(graphName, subject, "@type");
                if (type.isPresent()) {
                    JsonArray types = type.get().asJsonArray();
                    this.graphMap.set(graphName, subject, "@type", (JsonValue)Json.createArrayBuilder((JsonArray)types).add(triple.getObject().toString()).build());
                    continue;
                }
                this.graphMap.set(graphName, subject, "@type", (JsonValue)Json.createArrayBuilder().add(triple.getObject().toString()).build());
                continue;
            }
            JsonObject value = RdfToObject.with(triple.getObject(), this.rdfDirection, this.useNativeTypes).processingMode(this.processingMode).build();
            Optional<JsonValue> predicateValue = this.graphMap.get(graphName, subject, predicate);
            if (predicateValue.isPresent()) {
                JsonArray array = predicateValue.get().asJsonArray();
                if (!array.contains((Object)value)) {
                    this.graphMap.set(graphName, subject, predicate, (JsonValue)Json.createArrayBuilder((JsonArray)array).add((JsonValue)value).build());
                }
            } else {
                this.graphMap.set(graphName, subject, predicate, (JsonValue)Json.createArrayBuilder().add((JsonValue)value).build());
            }
            if (triple.getObject().isIRI() && "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(triple.getObject().toString())) {
                reference = new Reference();
                reference.graphName = graphName;
                reference.subject = subject;
                reference.property = predicate;
                reference.value = value;
                this.graphMap.addUsage(graphName, triple.getObject().toString(), reference);
                continue;
            }
            if (this.referenceOnce.containsKey(triple.getObject().toString())) {
                this.referenceOnce.put(triple.getObject().toString(), null);
                continue;
            }
            if (!triple.getObject().isBlankNode()) continue;
            reference = new Reference();
            reference.graphName = graphName;
            reference.subject = subject;
            reference.property = predicate;
            reference.value = value;
            this.referenceOnce.put(triple.getObject().toString(), reference);
        }
    }

    public RdfToJsonld uriValidation(boolean uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    protected static class Reference {
        private String graphName;
        private String subject;
        private String property;
        private JsonObject value;

        protected Reference() {
        }
    }
}

