/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DirectionType;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class ValueExpansion {
    private final ActiveContext activeContext;
    private JsonObject result;
    private Optional<TermDefinition> definition;

    private ValueExpansion(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static final ValueExpansion with(ActiveContext activeContext) {
        return new ValueExpansion(activeContext);
    }

    public JsonObject expand(JsonValue value, String activeProperty) throws JsonLdError {
        this.definition = this.activeContext.getTerm(activeProperty);
        Optional<String> typeMapping = this.definition.map(TermDefinition::getTypeMapping);
        if (typeMapping.isPresent()) {
            if ("@id".equals(typeMapping.get()) && JsonUtils.isString(value)) {
                String expandedValue = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(((JsonString)value).getString());
                return Json.createObjectBuilder().add("@id", expandedValue).build();
            }
            if ("@vocab".equals(typeMapping.get()) && JsonUtils.isString(value)) {
                String expandedValue = this.activeContext.uriExpansion().documentRelative(true).vocab(true).expand(((JsonString)value).getString());
                return Json.createObjectBuilder().add("@id", expandedValue).build();
            }
        }
        this.result = Json.createObjectBuilder().add("@value", value).build();
        if (typeMapping.isPresent() && !"@id".equals(typeMapping.get()) && !"@vocab".equals(typeMapping.get()) && !"@none".equals(typeMapping.get())) {
            this.result = Json.createObjectBuilder((JsonObject)this.result).add("@type", (JsonValue)Json.createValue((String)typeMapping.get())).build();
        } else if (JsonUtils.isString(value)) {
            this.buildStringValue();
        }
        return this.result;
    }

    private void buildStringValue() {
        JsonString language = null;
        if (this.definition.isPresent() && this.definition.map(TermDefinition::getLanguageMapping).isPresent()) {
            language = this.definition.get().getLanguageMapping();
        } else if (this.activeContext.getDefaultLanguage() != null) {
            language = Json.createValue((String)this.activeContext.getDefaultLanguage());
        }
        DirectionType direction = this.definition.map(TermDefinition::getDirectionMapping).orElse(this.activeContext.getDefaultBaseDirection());
        if (JsonUtils.isNotNull((JsonValue)language)) {
            this.result = Json.createObjectBuilder((JsonObject)this.result).add("@language", (JsonValue)language).build();
        }
        if (direction != null && !DirectionType.NULL.equals((Object)direction)) {
            this.result = Json.createObjectBuilder((JsonObject)this.result).add("@direction", (JsonValue)Json.createValue((String)direction.name().toLowerCase())).build();
        }
    }
}

