/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.ArrayExpansion;
import com.apicatalog.jsonld.expansion.ObjectExpansion;
import com.apicatalog.jsonld.expansion.ScalarExpansion;
import com.apicatalog.jsonld.json.JsonUtils;
import java.net.URI;
import javax.json.JsonValue;

public final class Expansion {
    private ActiveContext activeContext;
    private JsonValue element;
    private String activeProperty;
    private URI baseUrl;
    private boolean frameExpansion;
    private boolean ordered;
    private boolean fromMap;

    private Expansion(ActiveContext activeContext, JsonValue element, String activeProperty, URI baseUrl) {
        this.activeContext = activeContext;
        this.element = element;
        this.activeProperty = activeProperty;
        this.baseUrl = baseUrl;
        this.frameExpansion = false;
        this.ordered = false;
        this.fromMap = false;
    }

    public static final Expansion with(ActiveContext activeContext, JsonValue element, String activeProperty, URI baseUrl) {
        return new Expansion(activeContext, element, activeProperty, baseUrl);
    }

    public Expansion frameExpansion(boolean value) {
        this.frameExpansion = value;
        return this;
    }

    public Expansion ordered(boolean value) {
        this.ordered = value;
        return this;
    }

    public Expansion fromMap(boolean value) {
        this.fromMap = value;
        return this;
    }

    public JsonValue compute() throws JsonLdError {
        if (JsonUtils.isNull(this.element)) {
            return JsonValue.NULL;
        }
        if (JsonUtils.isArray(this.element)) {
            return ArrayExpansion.with(this.activeContext, this.element.asJsonArray(), this.activeProperty, this.baseUrl).expand();
        }
        JsonValue propertyContext = this.activeContext.getTerm(this.activeProperty).map(TermDefinition::getLocalContext).orElse(null);
        if (JsonUtils.isScalar(this.element)) {
            return ScalarExpansion.with(this.activeContext, propertyContext, this.element, this.activeProperty).expand();
        }
        return ObjectExpansion.with(this.activeContext, propertyContext, this.element.asJsonObject(), this.activeProperty, this.baseUrl).frameExpansion(this.frameExpansion && !"@default".equals(this.activeProperty)).ordered(this.ordered).fromMap(this.fromMap).expand();
    }
}

