/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.impl;

import com.apicatalog.rdf.RdfGraph;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class RdfGraphImpl
implements RdfGraph {
    private final Map<RdfResource, Map<RdfResource, Set<RdfValue>>> index = new HashMap<RdfResource, Map<RdfResource, Set<RdfValue>>>();
    private final List<RdfTriple> triples = new LinkedList<RdfTriple>();

    protected RdfGraphImpl() {
    }

    public void add(RdfTriple triple) {
        if (triple == null) {
            throw new IllegalArgumentException();
        }
        this.index.computeIfAbsent(triple.getSubject(), x -> new HashMap()).computeIfAbsent(triple.getPredicate(), x -> new HashSet()).add(triple.getObject());
        this.triples.add(triple);
    }

    @Override
    public boolean contains(RdfTriple triple) {
        if (triple == null) {
            throw new IllegalArgumentException();
        }
        return this.index.containsKey(triple.getSubject()) && this.index.get(triple.getSubject()).containsKey(triple.getPredicate()) && this.index.get(triple.getSubject()).get(triple.getPredicate()).contains(triple.getObject());
    }

    @Override
    public List<RdfTriple> toList() {
        return this.triples;
    }
}

