/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.io.nquad;

import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraphName;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfObject;
import com.apicatalog.rdf.RdfPredicate;
import com.apicatalog.rdf.RdfSubject;
import com.apicatalog.rdf.io.RdfReader;
import com.apicatalog.rdf.io.nquad.NQuadsReaderException;
import com.apicatalog.rdf.io.nquad.Tokenizer;
import java.io.Reader;
import java.util.Arrays;

public final class NQuadsReader
implements RdfReader {
    private final Tokenizer tokenizer;
    private RdfDataset dataset;

    public NQuadsReader(Reader reader) {
        this.tokenizer = new Tokenizer(reader);
        this.dataset = null;
    }

    @Override
    public RdfDataset readDataset() throws NQuadsReaderException {
        if (this.dataset != null) {
            return this.dataset;
        }
        this.dataset = Rdf.createDataset();
        while (this.tokenizer.hasNext()) {
            if (this.tokenizer.accept(Tokenizer.TokenType.END_OF_LINE) || this.tokenizer.accept(Tokenizer.TokenType.WHITE_SPACE) || this.tokenizer.accept(Tokenizer.TokenType.COMMENT)) continue;
            this.dataset.add(this.reaStatement());
        }
        return this.dataset;
    }

    private RdfNQuad reaStatement() throws NQuadsReaderException {
        RdfSubject subject = this.readSubject();
        this.skipWhitespace(0);
        String predicate = this.readPredicate();
        this.skipWhitespace(0);
        RdfObject object = this.readObject();
        RdfGraphName graphName = null;
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.IRI_REF == this.tokenizer.token().getType()) {
            String graphNameIri = this.tokenizer.token().getValue();
            NQuadsReader.assertAbsoluteIri(graphNameIri, "Graph name");
            graphName = Rdf.createGraphName(RdfGraphName.Type.IRI, graphNameIri);
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == this.tokenizer.token().getType()) {
            graphName = Rdf.createGraphName(RdfGraphName.Type.BLANK_NODE, "_:".concat(this.tokenizer.token().getValue()));
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (Tokenizer.TokenType.END_OF_STATEMENT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), Tokenizer.TokenType.END_OF_STATEMENT);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.COMMENT == this.tokenizer.token().getType()) {
            this.tokenizer.next();
        } else if (Tokenizer.TokenType.END_OF_LINE != this.tokenizer.token().getType() && Tokenizer.TokenType.END_OF_INPUT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), Tokenizer.TokenType.END_OF_LINE, Tokenizer.TokenType.END_OF_INPUT);
            this.tokenizer.next();
        }
        return Rdf.createNQuad(subject, Rdf.createPredicate(RdfPredicate.Type.IRI, predicate), object, graphName);
    }

    private RdfSubject readSubject() throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            String iri = token.getValue();
            NQuadsReader.assertAbsoluteIri(iri, "Subject");
            return Rdf.createSubject(RdfSubject.Type.IRI, iri);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return Rdf.createSubject(RdfSubject.Type.BLANK_NODE, "_:".concat(token.getValue()));
        }
        return (RdfSubject)NQuadsReader.unexpected(token, new Tokenizer.TokenType[0]);
    }

    private RdfObject readObject() throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            String iri = token.getValue();
            NQuadsReader.assertAbsoluteIri(iri, "Object");
            return Rdf.createObject(RdfObject.Type.IRI, iri);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return Rdf.createObject(RdfObject.Type.BLANK_NODE, "_:".concat(token.getValue()));
        }
        return this.readLiteral();
    }

    private RdfObject readLiteral() throws NQuadsReaderException {
        Tokenizer.Token value = this.tokenizer.token();
        if (Tokenizer.TokenType.STRING_LITERAL_QUOTE != value.getType()) {
            NQuadsReader.unexpected(value, new Tokenizer.TokenType[0]);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.LANGTAG == this.tokenizer.token().getType()) {
            String langTag = this.tokenizer.token().getValue();
            this.tokenizer.next();
            return Rdf.createObject(Rdf.createLangString(value.getValue(), langTag));
        }
        if (Tokenizer.TokenType.LITERAL_DATA_TYPE == this.tokenizer.token().getType()) {
            this.tokenizer.next();
            this.skipWhitespace(0);
            Tokenizer.Token attr = this.tokenizer.token();
            if (Tokenizer.TokenType.IRI_REF == attr.getType()) {
                this.tokenizer.next();
                String iri = attr.getValue();
                NQuadsReader.assertAbsoluteIri(iri, "DataType");
                return Rdf.createObject(Rdf.createTypedString(value.getValue(), iri));
            }
            NQuadsReader.unexpected(attr, new Tokenizer.TokenType[0]);
        }
        return Rdf.createObject(RdfObject.Type.LITERAL, value.getValue());
    }

    private static final <T> T unexpected(Tokenizer.Token token, Tokenizer.TokenType ... types) throws NQuadsReaderException {
        throw new NQuadsReaderException("Unexpected token " + token.getType() + (String)(token.getValue() != null ? "[" + token.getValue() + "]" : "") + ". Expected one of " + Arrays.toString((Object[])types) + ".");
    }

    private String readPredicate() throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF != token.getType()) {
            NQuadsReader.unexpected(token, Tokenizer.TokenType.IRI_REF);
        }
        this.tokenizer.next();
        String iri = token.getValue();
        NQuadsReader.assertAbsoluteIri(iri, "Predicate");
        return iri;
    }

    private void skipWhitespace(int min) throws NQuadsReaderException {
        int count = 0;
        while (this.tokenizer.accept(Tokenizer.TokenType.WHITE_SPACE)) {
            ++count;
        }
        if (count < min) {
            NQuadsReader.unexpected(this.tokenizer.token(), new Tokenizer.TokenType[0]);
        }
    }

    private static final void assertAbsoluteIri(String iri, String what) throws NQuadsReaderException {
        if (UriUtils.isNotAbsoluteUri(iri)) {
            throw new NQuadsReaderException(what + " must be an absolute IRI [" + iri + "]. ");
        }
    }
}

