/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.impl;

import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfObject;
import com.apicatalog.rdf.impl.RdfLiteralImpl;
import java.util.Objects;

final class RdfObjectImpl
implements RdfObject {
    private final RdfLiteral literal;
    private final String value;
    private final RdfObject.Type type;

    protected RdfObjectImpl(RdfLiteral literal) {
        this.literal = literal;
        this.value = null;
        this.type = RdfObject.Type.LITERAL;
    }

    protected RdfObjectImpl(RdfObject.Type type, String value) {
        this.literal = RdfObject.Type.LITERAL.equals((Object)type) ? new RdfLiteralImpl(value) : null;
        this.value = RdfObject.Type.LITERAL.equals((Object)type) ? null : value;
        this.type = type;
    }

    @Override
    public boolean isLiteral() {
        return RdfObject.Type.LITERAL.equals((Object)this.type);
    }

    @Override
    public boolean isIRI() {
        return RdfObject.Type.IRI.equals((Object)this.type);
    }

    @Override
    public boolean isBlankNode() {
        return RdfObject.Type.BLANK_NODE.equals((Object)this.type);
    }

    @Override
    public RdfLiteral getLiteral() {
        return this.literal;
    }

    public String toString() {
        if (this.literal != null) {
            return this.literal.toString();
        }
        return this.value == null ? "null" : this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type, this.literal});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RdfObjectImpl other = (RdfObjectImpl)obj;
        return Objects.equals(this.value, other.value) && this.type == other.type && Objects.equals(this.literal, other.literal);
    }
}

