/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.impl;

import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraph;
import com.apicatalog.rdf.RdfGraphName;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.impl.RdfGraphImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class RdfDatasetImpl
implements RdfDataset {
    private final Map<RdfGraphName, RdfGraphImpl> graphs = new HashMap<RdfGraphName, RdfGraphImpl>();
    private final List<RdfNQuad> nquads = new LinkedList<RdfNQuad>();
    private final RdfGraphImpl defaultGraph = new RdfGraphImpl();

    protected RdfDatasetImpl() {
    }

    @Override
    public RdfGraph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public List<RdfNQuad> toList() {
        return this.nquads;
    }

    @Override
    public void add(RdfNQuad nquad) {
        if (nquad == null) {
            throw new IllegalArgumentException();
        }
        if (nquad.getGraphName() != null) {
            RdfGraphImpl graph = this.graphs.get(nquad.getGraphName());
            if (graph == null) {
                graph = new RdfGraphImpl();
                this.graphs.put(nquad.getGraphName(), graph);
                graph.add(nquad);
                this.nquads.add(nquad);
            } else if (!graph.contains(nquad)) {
                graph.add(nquad);
                this.nquads.add(nquad);
            }
        } else if (!this.defaultGraph.contains(nquad)) {
            this.defaultGraph.add(nquad);
            this.nquads.add(nquad);
        }
    }

    @Override
    public Set<RdfGraphName> getGraphNames() {
        return this.graphs.keySet();
    }

    @Override
    public RdfGraph getGraph(RdfGraphName graphName) {
        return this.graphs.get(graphName);
    }

    @Override
    public int size() {
        return this.nquads.size();
    }
}

