/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.http.media;

import com.apicatalog.jsonld.http.media.MediaTypeParameters;
import com.apicatalog.jsonld.http.media.MediaTypeParser;
import java.util.Objects;

public final class MediaType {
    private static final String TYPE_APPLICATION = "application";
    private static final String TYPE_TEXT = "text";
    private static final String WILDCARD = "*";
    public static final MediaType HTML = new MediaType("text", "html");
    public static final MediaType JSON_LD = new MediaType("application", "ld+json");
    public static final MediaType JSON = new MediaType("application", "json");
    public static final MediaType XHTML = new MediaType("application", "xhtml+xml");
    public static final MediaType N_QUADS = new MediaType("application", "n-quads");
    public static final MediaType ANY = new MediaType("*", "*");
    private final String type;
    private final String subtype;
    private final MediaTypeParameters parameters;

    protected MediaType(String type, String subtype, MediaTypeParameters parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    protected MediaType(String type, String subtype) {
        this(type, subtype, MediaTypeParameters.EMPTY);
    }

    public boolean match(MediaType mediaType) {
        return !(mediaType == null || !WILDCARD.equals(this.type) && !WILDCARD.equals(mediaType.type) && !Objects.equals(this.type, mediaType.type) || !WILDCARD.equals(this.subtype) && !WILDCARD.equals(mediaType.subtype) && !Objects.equals(this.subtype, mediaType.subtype));
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public MediaTypeParameters parameters() {
        return this.parameters;
    }

    public String toString() {
        return String.valueOf(this.type).concat("/").concat(this.subtype);
    }

    public static final MediaType of(String type, String subtype) {
        if (type == null || subtype == null) {
            throw new IllegalArgumentException();
        }
        return new MediaType(type, subtype);
    }

    public static final MediaType of(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.isBlank()) {
            return null;
        }
        return new MediaTypeParser(value).parse();
    }
}

