/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.impl;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.api.impl.CommonApi;
import com.apicatalog.jsonld.api.impl.LoaderApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.CompactionProcessor;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;
import javax.json.JsonObject;

public final class CompactionApi
implements CommonApi<CompactionApi>,
LoaderApi<CompactionApi> {
    private final Document document;
    private final URI documentUri;
    private final Document context;
    private final URI contextUri;
    private JsonLdOptions options;

    public CompactionApi(URI documentUri, Document context) {
        this.document = null;
        this.documentUri = documentUri;
        this.context = context;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    public CompactionApi(URI documentUri, URI contextUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.context = null;
        this.contextUri = contextUri;
        this.options = new JsonLdOptions();
    }

    public CompactionApi(Document document, Document context) {
        this.document = document;
        this.documentUri = null;
        this.context = context;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    @Override
    public CompactionApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public CompactionApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public CompactionApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    @Override
    public CompactionApi base(String baseUri) {
        return this.base(baseUri != null ? UriUtils.create(baseUri) : null);
    }

    public CompactionApi compactArrays(boolean enable) {
        this.options.setCompactArrays(enable);
        return this;
    }

    public CompactionApi compactArrays() {
        return this.compactArrays(true);
    }

    public CompactionApi compactToRelative(boolean enable) {
        this.options.setCompactToRelative(enable);
        return this;
    }

    public CompactionApi compactToRelative() {
        return this.compactToRelative(true);
    }

    @Override
    public CompactionApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public CompactionApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    @Override
    public CompactionApi ordered() {
        return this.ordered(true);
    }

    public JsonObject get() throws JsonLdError {
        if (this.documentUri != null && this.contextUri != null) {
            return CompactionProcessor.compact(this.documentUri, this.contextUri, this.options);
        }
        if (this.documentUri != null && this.context != null) {
            return CompactionProcessor.compact(this.documentUri, this.context, this.options);
        }
        if (this.document != null && this.context != null) {
            return CompactionProcessor.compact(this.document, this.context, this.options);
        }
        throw new IllegalStateException();
    }
}

