/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.io.nquad;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfGraphName;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfObject;
import com.apicatalog.rdf.RdfPredicate;
import com.apicatalog.rdf.RdfSubject;
import com.apicatalog.rdf.io.RdfReader;
import com.apicatalog.rdf.io.nquad.NQuadsReaderException;
import com.apicatalog.rdf.io.nquad.Tokenizer;
import java.io.Reader;
import java.util.Arrays;

public final class NQuadsReader
implements RdfReader {
    private final Tokenizer tokenizer;
    private RdfDataset dataset;

    public NQuadsReader(Reader reader) {
        this.tokenizer = new Tokenizer(reader);
        this.dataset = null;
    }

    @Override
    public RdfDataset readDataset() throws NQuadsReaderException {
        if (this.dataset != null) {
            return this.dataset;
        }
        this.dataset = Rdf.createDataset();
        while (this.tokenizer.hasNext()) {
            if (this.tokenizer.accept(Tokenizer.TokenType.END_OF_LINE) || this.tokenizer.accept(Tokenizer.TokenType.WHITE_SPACE)) continue;
            this.dataset.add(this.reaStatement());
        }
        return this.dataset;
    }

    public RdfNQuad reaStatement() throws NQuadsReaderException {
        RdfSubject subject = this.readSubject();
        this.skipWhitespace(1);
        String predicate = this.readIri();
        this.skipWhitespace(1);
        RdfObject object = this.readObject();
        RdfGraphName graphName = null;
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.IRI_REF == this.tokenizer.token().getType()) {
            graphName = Rdf.createGraphName(RdfGraphName.Type.IRI, this.tokenizer.token().getValue());
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == this.tokenizer.token().getType()) {
            graphName = Rdf.createGraphName(RdfGraphName.Type.BLANK_NODE, "_:".concat(this.tokenizer.token().getValue()));
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (Tokenizer.TokenType.END_OF_STATEMENT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), new Tokenizer.TokenType[0]);
        }
        this.tokenizer.next();
        return Rdf.createNQuad(subject, Rdf.createPredicate(RdfPredicate.Type.IRI, predicate), object, graphName);
    }

    private RdfSubject readSubject() throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            return Rdf.createSubject(RdfSubject.Type.IRI, token.getValue());
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return Rdf.createSubject(RdfSubject.Type.BLANK_NODE, "_:".concat(token.getValue()));
        }
        return (RdfSubject)NQuadsReader.unexpected(token, new Tokenizer.TokenType[0]);
    }

    private RdfObject readObject() throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            return Rdf.createObject(RdfObject.Type.IRI, token.getValue());
        }
        if (Tokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return Rdf.createObject(RdfObject.Type.BLANK_NODE, "_:".concat(token.getValue()));
        }
        return this.readLiteral();
    }

    public RdfObject readLiteral() throws NQuadsReaderException {
        Tokenizer.Token value = this.tokenizer.token();
        if (Tokenizer.TokenType.STRING_LITERAL_QUOTE != value.getType()) {
            NQuadsReader.unexpected(value, new Tokenizer.TokenType[0]);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (Tokenizer.TokenType.LANGTAG == this.tokenizer.token().getType()) {
            String langTag = this.tokenizer.token().getValue();
            this.tokenizer.next();
            return Rdf.createObject(Rdf.createLangString(value.getValue(), langTag));
        }
        if (Tokenizer.TokenType.LITERAL_DATA_TYPE == this.tokenizer.token().getType()) {
            this.tokenizer.next();
            this.skipWhitespace(0);
            Tokenizer.Token attr = this.tokenizer.token();
            if (Tokenizer.TokenType.IRI_REF == attr.getType()) {
                this.tokenizer.next();
                return Rdf.createObject(Rdf.createTypedString(value.getValue(), attr.getValue()));
            }
            NQuadsReader.unexpected(attr, new Tokenizer.TokenType[0]);
        }
        return Rdf.createObject(RdfObject.Type.LITERAL, value.getValue());
    }

    private static final <T> T unexpected(Tokenizer.Token token, Tokenizer.TokenType ... types) throws NQuadsReaderException {
        throw new NQuadsReaderException("Unexpected token " + token.getType() + "(" + token.getValue() + "). Expected one of " + Arrays.toString((Object[])types) + ".");
    }

    private String readIri() throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        if (Tokenizer.TokenType.IRI_REF != token.getType()) {
            NQuadsReader.unexpected(token, Tokenizer.TokenType.IRI_REF);
        }
        this.tokenizer.next();
        return token.getValue();
    }

    private void skipWhitespace(int min) throws NQuadsReaderException {
        Tokenizer.Token token = this.tokenizer.token();
        int count = 0;
        while (Tokenizer.TokenType.WHITE_SPACE == token.getType()) {
            token = this.tokenizer.next();
            ++count;
        }
        if (count < min) {
            NQuadsReader.unexpected(token, new Tokenizer.TokenType[0]);
        }
    }
}

