/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.document;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.json.JsonUtils;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;

public final class JsonDocument
implements Document {
    private JsonStructure structure;

    protected JsonDocument(JsonStructure structue) {
        this.structure = structue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Document parse(Reader reader) throws JsonLdError {
        try (JsonParser parser = Json.createParser((Reader)reader);){
            if (!parser.hasNext()) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
            }
            parser.next();
            JsonValue root = parser.getValue();
            if (JsonUtils.isArray(root)) {
                JsonDocument jsonDocument = new JsonDocument((JsonStructure)root.asJsonArray());
                return jsonDocument;
            }
            if (!JsonUtils.isObject(root)) throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
            JsonDocument jsonDocument = new JsonDocument((JsonStructure)root.asJsonObject());
            return jsonDocument;
        }
        catch (JsonException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
    }

    @Override
    public JsonStructure getJsonStructure() throws JsonLdError {
        return this.structure;
    }

    @Override
    public byte[] getRawPayload() throws JsonLdError {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isJsonStructure() {
        return true;
    }

    @Override
    public boolean isRawPayload() {
        return false;
    }
}

