/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.builder;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.processor.FromRdfProcessor;
import com.apicatalog.rdf.RdfDataset;
import java.net.URI;
import javax.json.JsonArray;

public final class FromRdfApi {
    private final RdfDataset dataset;
    private JsonLdOptions options;

    public FromRdfApi(RdfDataset dataset) {
        this.dataset = dataset;
        this.options = new JsonLdOptions();
    }

    public FromRdfApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    public FromRdfApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    public FromRdfApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public FromRdfApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    public FromRdfApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public FromRdfApi ordered() {
        return this.ordered(true);
    }

    public JsonArray get() throws JsonLdError {
        return FromRdfProcessor.fromRdf(this.dataset, this.options);
    }
}

