/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api.builder;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.LoadDocumentCallback;
import com.apicatalog.jsonld.processor.CompactionProcessor;
import java.net.URI;
import javax.json.JsonObject;
import javax.json.JsonStructure;

public final class CompactionApi {
    private final URI document;
    private final JsonStructure jsonContext;
    private final URI contextUri;
    private JsonLdOptions options;

    public CompactionApi(URI document, JsonStructure context) {
        this.document = document;
        this.jsonContext = context;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    public CompactionApi(URI document, URI contextUri) {
        this.document = document;
        this.jsonContext = null;
        this.contextUri = contextUri;
        this.options = new JsonLdOptions();
    }

    public CompactionApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    public CompactionApi mode(Version processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    public CompactionApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public CompactionApi base(String baseUri) {
        return this.base(URI.create(baseUri));
    }

    public CompactionApi compactArrays(boolean enable) {
        this.options.setCompactArrays(enable);
        return this;
    }

    public CompactionApi compactArrays() {
        return this.compactArrays(true);
    }

    public CompactionApi compactToRelative(boolean enable) {
        this.options.setCompactToRelative(enable);
        return this;
    }

    public CompactionApi compactToRelative() {
        return this.compactToRelative(true);
    }

    public CompactionApi loader(LoadDocumentCallback loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    public CompactionApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public CompactionApi ordered() {
        return this.ordered(true);
    }

    public JsonObject get() throws JsonLdError {
        if (this.jsonContext != null) {
            return CompactionProcessor.compact(this.document, this.jsonContext, this.options);
        }
        if (this.contextUri != null) {
            return CompactionProcessor.compact(this.document, this.jsonContext, this.options);
        }
        throw new IllegalStateException();
    }
}

