/*
 * Decompiled with CFR 0.152.
 */
package com.apandroid.chiptextview;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J$\u0010\u001c\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0012\u0010#\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0017J(\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015H\u0017J\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u001c\u00103\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/apandroid/chiptextview/RoundedCornersDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "drawable", "(Landroid/graphics/drawable/Drawable;)V", "chipRect", "Landroid/graphics/RectF;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "maskBitmap", "Landroid/graphics/Bitmap;", "maskCanvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "shader", "Landroid/graphics/BitmapShader;", "draw", "", "canvas", "getOpacity", "", "initShader", "bounds", "Landroid/graphics/Rect;", "invalidateDrawable", "who", "onBoundsChange", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setHotspot", "x", "", "y", "setHotspotBounds", "left", "top", "right", "bottom", "setState", "", "stateSet", "", "unscheduleDrawable", "chiptextview_release"})
public final class RoundedCornersDrawable
extends Drawable
implements Drawable.Callback {
    private final Paint paint;
    private final RectF chipRect;
    private final Canvas maskCanvas;
    private Bitmap maskBitmap;
    private BitmapShader shader;
    @NotNull
    private final Drawable drawable;

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        float cornerRadius = this.chipRect.height() / (float)2;
        this.drawable.draw(this.maskCanvas);
        canvas.drawRoundRect(this.chipRect, cornerRadius, cornerRadius, this.paint);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.chipRect.set(bounds);
        this.drawable.setBounds(bounds);
        this.initShader(bounds);
    }

    private final void initShader(Rect bounds) {
        Bitmap bitmap;
        Bitmap bitmap2 = Bitmap.createBitmap((int)bounds.width(), (int)bounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        RoundedCornersDrawable roundedCornersDrawable = this;
        Bitmap it = bitmap2;
        this.shader = new BitmapShader(it, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        this.paint.setShader((Shader)this.shader);
        this.maskCanvas.setBitmap(it);
        roundedCornersDrawable.maskBitmap = bitmap = bitmap2;
    }

    public void setAlpha(int alpha) {
        this.drawable.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.drawable.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return Drawable.resolveOpacity((int)-1, (int)this.drawable.getOpacity());
    }

    public boolean setState(@Nullable int[] stateSet) {
        return this.drawable.setState(stateSet);
    }

    @TargetApi(value=21)
    public void setHotspot(float x, float y) {
        this.drawable.setHotspot(x, y);
    }

    @TargetApi(value=21)
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.drawable.setHotspotBounds(left, top, right, bottom);
    }

    public void unscheduleDrawable(@Nullable Drawable who, @Nullable Runnable what) {
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@Nullable Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(@Nullable Drawable who, @Nullable Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    @NotNull
    public final Drawable getDrawable() {
        return this.drawable;
    }

    public RoundedCornersDrawable(@NotNull Drawable drawable) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        this.drawable = drawable;
        this.paint = new Paint(1);
        this.chipRect = new RectF();
        this.maskCanvas = new Canvas();
        this.drawable.setCallback((Drawable.Callback)this);
    }
}

