package com.apandroid.chiptextview

import android.annotation.TargetApi
import android.graphics.*
import android.graphics.drawable.Drawable
import android.os.Build

class RoundedCornersDrawable(val drawable: Drawable) : Drawable(), Drawable.Callback {

    private val paint = Paint(Paint.ANTI_ALIAS_FLAG)
    private val chipRect = RectF()
    private val maskCanvas = Canvas()
    private var maskBitmap: Bitmap? = null
    private var shader: BitmapShader? = null

    init {
        drawable.callback = this
    }

    override fun draw(canvas: Canvas) {
        val cornerRadius = chipRect.height() / 2

        drawable.draw(maskCanvas)
        canvas.drawRoundRect(chipRect, cornerRadius, cornerRadius, paint)
    }

    override fun onBoundsChange(bounds: Rect) {
        super.onBoundsChange(bounds)
        chipRect.set(bounds)
        drawable.bounds = bounds
        initShader(bounds)
    }

    private fun initShader(bounds: Rect) {
        maskBitmap = Bitmap.createBitmap(bounds.width(), bounds.height(), Bitmap.Config.ARGB_8888).also {
            shader = BitmapShader(it, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT)
            paint.shader = shader
            maskCanvas.setBitmap(it)
        }
    }

    override fun setAlpha(alpha: Int) {
        drawable.alpha = alpha
    }

    override fun setColorFilter(colorFilter: ColorFilter?) {
        drawable.colorFilter = colorFilter
    }

    override fun getOpacity() = resolveOpacity(PixelFormat.OPAQUE, drawable.opacity)

    override fun setState(stateSet: IntArray?) = drawable.setState(stateSet)

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun setHotspot(x: Float, y: Float) {
        drawable.setHotspot(x, y)
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    override fun setHotspotBounds(left: Int, top: Int, right: Int, bottom: Int) {
        drawable.setHotspotBounds(left, top, right, bottom)
    }

    override fun unscheduleDrawable(who: Drawable?, what: Runnable?) {
        unscheduleSelf(what)
    }

    override fun invalidateDrawable(who: Drawable?) {
        invalidateSelf()
    }

    override fun scheduleDrawable(who: Drawable?, what: Runnable?, `when`: Long) {
        scheduleSelf(what, `when`)
    }
}
