/*
 * Decompiled with CFR 0.152.
 */
package com.apandroid.chiptextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.apandroid.chiptextview.ChipBackgroundDrawable;
import com.apandroid.chiptextview.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0006\u0010:\u001a\u000206J\u0006\u0010;\u001a\u000206J\u0010\u0010<\u001a\u0002062\u0006\u00107\u001a\u000208H\u0014J\u0018\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tH\u0014J \u0010@\u001a\u0002062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\tH\u0002J\u0010\u0010G\u001a\u0002062\u0006\u0010B\u001a\u00020CH\u0002J\u000e\u0010H\u001a\u0002062\u0006\u0010I\u001a\u00020\tJ\u000e\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020\tJ\u000e\u0010L\u001a\u0002062\u0006\u0010K\u001a\u00020\tJ&\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010Q\u001a\u0002062\u0006\u0010K\u001a\u00020\tJ\u0006\u0010R\u001a\u000206J\u0006\u0010S\u001a\u000206R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R$\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R$\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R(\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010(\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010\u0015R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00100\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006T"}, d2={"Lcom/apandroid/chiptextview/ChipTextView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "chipBackgroundDrawable", "Lcom/apandroid/chiptextview/ChipBackgroundDrawable;", "chipDrawable", "getChipDrawable", "()Lcom/apandroid/chiptextview/ChipBackgroundDrawable;", "value", "chipPaddingBottom", "getChipPaddingBottom", "()I", "setChipPaddingBottom", "(I)V", "chipPaddingLeft", "getChipPaddingLeft", "setChipPaddingLeft", "chipPaddingRight", "getChipPaddingRight", "setChipPaddingRight", "chipPaddingTop", "getChipPaddingTop", "setChipPaddingTop", "paintFlags", "getPaintFlags", "setPaintFlags", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textColor", "getTextColor", "setTextColor", "textMeasuringRect", "Landroid/graphics/Rect;", "textPaint", "Landroid/text/TextPaint;", "", "textSize", "getTextSize", "()F", "setTextSize", "(F)V", "drawChipBackground", "", "canvas", "Landroid/graphics/Canvas;", "drawText", "hideStrikeThroughText", "hideTextUnderline", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "parseAttributes", "readAliasDimension", "array", "Landroid/content/res/TypedArray;", "originName", "alias", "defaultValue", "readChipPadding", "setChipColor", "color", "setChipHorizontalPadding", "padding", "setChipPadding", "left", "top", "right", "bottom", "setChipVerticalPadding", "strikeThroughText", "underlineText", "chiptextview_release"})
public final class ChipTextView
extends View {
    private final Rect textMeasuringRect;
    private final TextPaint textPaint;
    private ChipBackgroundDrawable chipBackgroundDrawable;
    @Nullable
    private String text;
    private int chipPaddingLeft;
    private int chipPaddingRight;
    private int chipPaddingTop;
    private int chipPaddingBottom;

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        this.text = value;
        this.requestLayout();
    }

    public final float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public final void setTextSize(float value) {
        this.textPaint.setTextSize(value);
        this.requestLayout();
    }

    public final int getTextColor() {
        return this.textPaint.getColor();
    }

    public final void setTextColor(int value) {
        this.textPaint.setColor(value);
        this.invalidate();
    }

    public final int getPaintFlags() {
        return this.textPaint.getFlags();
    }

    public final void setPaintFlags(int value) {
        this.textPaint.setFlags(value);
        this.requestLayout();
    }

    public final int getChipPaddingLeft() {
        return this.chipPaddingLeft;
    }

    public final void setChipPaddingLeft(int value) {
        this.chipPaddingLeft = value;
        this.requestLayout();
    }

    public final int getChipPaddingRight() {
        return this.chipPaddingRight;
    }

    public final void setChipPaddingRight(int value) {
        this.chipPaddingRight = value;
        this.requestLayout();
    }

    public final int getChipPaddingTop() {
        return this.chipPaddingTop;
    }

    public final void setChipPaddingTop(int value) {
        this.chipPaddingTop = value;
        this.requestLayout();
    }

    public final int getChipPaddingBottom() {
        return this.chipPaddingBottom;
    }

    public final void setChipPaddingBottom(int value) {
        this.chipPaddingBottom = value;
        this.requestLayout();
    }

    @NotNull
    public final ChipBackgroundDrawable getChipDrawable() {
        return this.chipBackgroundDrawable;
    }

    private final void parseAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ChipTextView, defStyleAttr, R.style.ChipTextViewDefaultStyle);
        this.setText(array.getString(R.styleable.ChipTextView_ctv_text));
        this.textPaint.setTextSize(array.getDimension(R.styleable.ChipTextView_ctv_textSize, 0.0f));
        this.textPaint.setColor(array.getColor(R.styleable.ChipTextView_ctv_textColor, -1));
        this.setChipColor(array.getColor(R.styleable.ChipTextView_ctv_chipColor, -16777216));
        TypedArray typedArray = array;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"array");
        this.readChipPadding(typedArray);
        array.recycle();
    }

    private final void readChipPadding(TypedArray array) {
        TypedArray typedArray;
        TypedArray $receiver = typedArray = array;
        int padding = $receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPadding, 0);
        int paddingHorizontal = $receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingHorizontal, padding);
        int paddingVertical = $receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingVertical, padding);
        this.setChipPadding(padding);
        this.setChipHorizontalPadding(paddingHorizontal);
        this.setChipVerticalPadding(paddingVertical);
        this.setChipPaddingLeft(this.readAliasDimension(array, R.styleable.ChipTextView_ctv_chipPaddingLeft, R.styleable.ChipTextView_ctv_chipPaddingStart, paddingHorizontal));
        this.setChipPaddingRight(this.readAliasDimension(array, R.styleable.ChipTextView_ctv_chipPaddingRight, R.styleable.ChipTextView_ctv_chipPaddingEnd, paddingHorizontal));
        this.setChipPaddingTop($receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingTop, paddingVertical));
        this.setChipPaddingBottom($receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingBottom, paddingVertical));
    }

    private final int readAliasDimension(TypedArray array, int originName, int alias, int defaultValue) {
        TypedArray typedArray = array;
        TypedArray $receiver = typedArray;
        return $receiver.hasValue(alias) ? $receiver.getDimensionPixelSize(alias, 0) : $receiver.getDimensionPixelSize(originName, defaultValue);
    }

    public final void setChipPadding(int padding) {
        this.setChipPaddingLeft(padding);
        this.setChipPaddingRight(padding);
        this.setChipPaddingTop(padding);
        this.setChipPaddingBottom(padding);
    }

    public final void setChipHorizontalPadding(int padding) {
        this.setChipPaddingLeft(padding);
        this.setChipPaddingRight(padding);
    }

    public final void setChipVerticalPadding(int padding) {
        this.setChipPaddingTop(padding);
        this.setChipPaddingBottom(padding);
    }

    public final void setChipPadding(int left, int top, int right, int bottom) {
        this.setChipPaddingLeft(left);
        this.setChipPaddingTop(top);
        this.setChipPaddingRight(right);
        this.setChipPaddingBottom(bottom);
    }

    public final void setChipColor(int color) {
        this.chipBackgroundDrawable = new ChipBackgroundDrawable(color);
        this.invalidate();
    }

    public final void strikeThroughText() {
        this.setPaintFlags(this.getPaintFlags() | 0x10);
    }

    public final void hideStrikeThroughText() {
        this.setPaintFlags(this.getPaintFlags() & ~16);
    }

    public final void underlineText() {
        this.setPaintFlags(this.getPaintFlags() | 8);
    }

    public final void hideTextUnderline() {
        this.setPaintFlags(this.getPaintFlags() & ~8);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int preferredWidth = 0;
        int preferredHeight = 0;
        String string = this.text;
        if (string != null) {
            String string2;
            String it = string2 = string;
            this.textPaint.getTextBounds(it, 0, it.length(), this.textMeasuringRect);
            int textWidth = MathKt.roundToInt((float)this.textPaint.measureText(it));
            int textHeight = this.textMeasuringRect.height();
            if (it.length() == 1) {
                int max;
                preferredWidth = max = Math.max(textWidth, textHeight);
                preferredHeight = max;
            } else {
                preferredWidth = textWidth;
                preferredHeight = textHeight;
            }
            preferredWidth += this.getPaddingLeft() + this.getPaddingRight() + this.chipPaddingLeft + this.chipPaddingRight;
            preferredHeight += this.getPaddingTop() + this.getPaddingBottom() + this.chipPaddingTop + this.chipPaddingBottom;
        }
        int finalWidth = View.resolveSize((int)preferredWidth, (int)widthMeasureSpec);
        int finalHeight = View.resolveSize((int)preferredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawChipBackground(canvas);
        this.drawText(canvas);
    }

    private final void drawChipBackground(Canvas canvas) {
        ChipBackgroundDrawable chipBackgroundDrawable;
        int chipLeft = this.getPaddingLeft();
        int chipTop = this.getPaddingTop();
        int chipRight = this.getWidth() - this.getPaddingRight();
        int chipBottom = this.getHeight() - this.getPaddingBottom();
        ChipBackgroundDrawable $receiver = chipBackgroundDrawable = this.chipBackgroundDrawable;
        $receiver.setBounds(chipLeft, chipTop, chipRight, chipBottom);
        $receiver.draw(canvas);
    }

    private final void drawText(Canvas canvas) {
        block0: {
            String string;
            String string2 = this.text;
            if (string2 == null) break block0;
            String it = string = string2;
            this.textPaint.getTextBounds(it, 0, it.length(), this.textMeasuringRect);
            float textWidth = this.textPaint.measureText(it);
            int textHeight = this.textMeasuringRect.height();
            int clientWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - this.chipPaddingLeft - this.chipPaddingRight;
            int clientHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.chipPaddingTop - this.chipPaddingBottom;
            float textX = (float)(this.getPaddingLeft() + this.chipPaddingLeft) + ((float)clientWidth - textWidth) / 2.0f;
            float textY = (float)(this.getPaddingTop() + this.chipPaddingTop - this.textMeasuringRect.top) + (float)(clientHeight - textHeight) / 2.0f;
            canvas.drawText(it, textX, textY, (Paint)this.textPaint);
        }
    }

    public ChipTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block0: {
            AttributeSet attributeSet;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            this.textMeasuringRect = new Rect();
            this.textPaint = new TextPaint(1);
            this.chipBackgroundDrawable = new ChipBackgroundDrawable(0, 1, null);
            AttributeSet attributeSet2 = attrs;
            if (attributeSet2 == null) break block0;
            AttributeSet it = attributeSet = attributeSet2;
            this.parseAttributes(context, it, defStyleAttr);
        }
    }

    public ChipTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, R.attr.chipTextViewStyle);
    }

    public ChipTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }
}

