package com.apandroid.chiptextview

import android.graphics.*
import android.graphics.drawable.Drawable

class ChipBackgroundDrawable(val color: Int = Color.BLACK) : Drawable() {

    private val chipRect = RectF()

    private val paint = Paint(Paint.ANTI_ALIAS_FLAG).also {
        it.color = color
    }

    override fun draw(canvas: Canvas) {
        chipRect.set(bounds)

        val cornerRadius = chipRect.height() / 2

        canvas.drawRoundRect(chipRect, cornerRadius, cornerRadius, paint)
    }

    override fun setAlpha(alpha: Int) {
        paint.alpha = alpha and 0xFF
        invalidateSelf()
    }

    override fun setColorFilter(colorFilter: ColorFilter?) {
        paint.colorFilter = colorFilter
        invalidateSelf()
    }

    override fun getOpacity() = PixelFormat.OPAQUE
}