/*
 * Decompiled with CFR 0.152.
 */
package com.anrisoftware.globalpom.fileresourcemanager;

import com.anrisoftware.globalpom.fileresourcemanager.FileResourceManagerProviderLogger;
import com.google.inject.Provider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import org.apache.commons.transaction.file.FileResourceManager;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.PrintWriterLogger;

public class FileResourceManagerProvider
implements Provider<FileResourceManager> {
    @Inject
    private FileResourceManagerProviderLogger log;
    private String storeDir;
    private boolean debug;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setStoreDir(File path) {
        this.setStoreDir(path.getAbsolutePath());
    }

    public void setStoreDir(String path) {
        this.storeDir = path;
    }

    public FileResourceManager get() {
        String workDir = this.createTmpDir();
        boolean urlEncodePath = false;
        final ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
        PrintWriter printWriter = new PrintWriter(stream){

            @Override
            public void flush() {
                super.flush();
                FileResourceManagerProvider.this.log.logFileResourceMessage(stream.toString());
            }
        };
        PrintWriterLogger logger = new PrintWriterLogger(printWriter, "", this.debug);
        return new FileResourceManager(this.storeDir, workDir, urlEncodePath, (LoggerFacade)logger);
    }

    private String createTmpDir() {
        try {
            File tmp = File.createTempFile("fileresourcemanager", null);
            tmp.delete();
            tmp.mkdir();
            String workDir = tmp.getAbsolutePath();
            return workDir;
        }
        catch (IOException e) {
            throw this.log.errorCreateWorkDir(e);
        }
    }
}

