/*
 * Decompiled with CFR 0.152.
 */
package com.androidadvance.topsnackbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SwipeDismissBehavior;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.androidadvance.topsnackbar.AnimationUtils;
import com.androidadvance.topsnackbar.R;
import com.androidadvance.topsnackbar.SnackbarManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class TSnackbar {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    private static final int ANIMATION_DURATION = 250;
    private static final int ANIMATION_FADE_DURATION = 180;
    private static final Handler sHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    ((TSnackbar)message.obj).showView();
                    return true;
                }
                case 1: {
                    ((TSnackbar)message.obj).hideView(message.arg1);
                    return true;
                }
            }
            return false;
        }
    });
    private static final int MSG_SHOW = 0;
    private static final int MSG_DISMISS = 1;
    private final ViewGroup mParent;
    private final Context mContext;
    private final SnackbarLayout mView;
    private int mDuration;
    private Callback mCallback;
    private final SnackbarManager.Callback mManagerCallback = new SnackbarManager.Callback(){

        @Override
        public void show() {
            sHandler.sendMessage(sHandler.obtainMessage(0, (Object)TSnackbar.this));
        }

        @Override
        public void dismiss(int event) {
            sHandler.sendMessage(sHandler.obtainMessage(1, event, 0, (Object)TSnackbar.this));
        }
    };

    private TSnackbar(ViewGroup parent) {
        this.mParent = parent;
        this.mContext = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mView = (SnackbarLayout)inflater.inflate(R.layout.tsnackbar_layout, this.mParent, false);
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @NonNull CharSequence text, int duration) {
        TSnackbar TSnackbar2 = new TSnackbar(TSnackbar.findSuitableParent(view));
        TSnackbar2.setText(text);
        TSnackbar2.setDuration(duration);
        return TSnackbar2;
    }

    @NonNull
    public static TSnackbar make(@NonNull View view, @StringRes int resId, int duration) {
        return TSnackbar.make(view, view.getResources().getText(resId), duration);
    }

    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            if (view instanceof CoordinatorLayout) {
                return (ViewGroup)view;
            }
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            }
            if (view == null) continue;
            ViewParent parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    @NonNull
    public TSnackbar setAction(@StringRes int resId, View.OnClickListener listener) {
        return this.setAction(this.mContext.getText(resId), listener);
    }

    @NonNull
    public TSnackbar setAction(CharSequence text, final View.OnClickListener listener) {
        Button tv = this.mView.getActionView();
        if (TextUtils.isEmpty((CharSequence)text) || listener == null) {
            tv.setVisibility(8);
            tv.setOnClickListener(null);
        } else {
            tv.setVisibility(0);
            tv.setText(text);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                    TSnackbar.this.dispatchDismiss(1);
                }
            });
        }
        return this;
    }

    @NonNull
    public TSnackbar setActionTextColor(ColorStateList colors) {
        Button tv = this.mView.getActionView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public TSnackbar setActionTextColor(@ColorInt int color) {
        Button tv = this.mView.getActionView();
        tv.setTextColor(color);
        return this;
    }

    @NonNull
    public TSnackbar setText(@NonNull CharSequence message) {
        TextView tv = this.mView.getMessageView();
        tv.setText(message);
        return this;
    }

    @NonNull
    public TSnackbar setText(@StringRes int resId) {
        return this.setText(this.mContext.getText(resId));
    }

    @NonNull
    public TSnackbar setDuration(int duration) {
        this.mDuration = duration;
        return this;
    }

    public int getDuration() {
        return this.mDuration;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    public void show() {
        SnackbarManager.getInstance().show(this.mDuration, this.mManagerCallback);
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    private void dispatchDismiss(int event) {
        SnackbarManager.getInstance().dismiss(this.mManagerCallback, event);
    }

    @NonNull
    public TSnackbar setCallback(Callback callback) {
        this.mCallback = callback;
        return this;
    }

    public boolean isShown() {
        return this.mView.isShown();
    }

    final void showView() {
        if (this.mView.getParent() == null) {
            ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams) {
                Behavior behavior = new Behavior();
                behavior.setStartAlphaSwipeDistance(0.1f);
                behavior.setEndAlphaSwipeDistance(0.6f);
                behavior.setSwipeDirection(0);
                behavior.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    public void onDismiss(View view) {
                        TSnackbar.this.dispatchDismiss(0);
                    }

                    public void onDragStateChanged(int state) {
                        switch (state) {
                            case 1: 
                            case 2: {
                                SnackbarManager.getInstance().cancelTimeout(TSnackbar.this.mManagerCallback);
                                break;
                            }
                            case 0: {
                                SnackbarManager.getInstance().restoreTimeout(TSnackbar.this.mManagerCallback);
                            }
                        }
                    }
                });
                ((CoordinatorLayout.LayoutParams)lp).setBehavior((CoordinatorLayout.Behavior)behavior);
            }
            this.mParent.addView((View)this.mView);
        }
        if (ViewCompat.isLaidOut((View)this.mView)) {
            this.animateViewIn();
        } else {
            this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    TSnackbar.this.animateViewIn();
                    TSnackbar.this.mView.setOnLayoutChangeListener(null);
                }
            });
        }
    }

    private void animateViewIn() {
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.top_in);
        anim2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setDuration(250L);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                if (TSnackbar.this.mCallback != null) {
                    TSnackbar.this.mCallback.onShown(TSnackbar.this);
                }
                SnackbarManager.getInstance().onShown(TSnackbar.this.mManagerCallback);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mView.startAnimation(anim2);
    }

    private void animateViewOut(final int event) {
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)R.anim.top_out);
        anim2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setDuration(250L);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                TSnackbar.this.onViewHidden(event);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mView.startAnimation(anim2);
    }

    final void hideView(int event) {
        if (this.mView.getVisibility() != 0 || this.isBeingDragged()) {
            this.onViewHidden(event);
        } else {
            this.animateViewOut(event);
        }
    }

    private void onViewHidden(int event) {
        this.mParent.removeView((View)this.mView);
        if (this.mCallback != null) {
            this.mCallback.onDismissed(this, event);
        }
        SnackbarManager.getInstance().onDismissed(this.mManagerCallback);
    }

    private boolean isBeingDragged() {
        CoordinatorLayout.LayoutParams cllp;
        CoordinatorLayout.Behavior behavior;
        ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
        if (lp instanceof CoordinatorLayout.LayoutParams && (behavior = (cllp = (CoordinatorLayout.LayoutParams)lp).getBehavior()) instanceof SwipeDismissBehavior) {
            return ((SwipeDismissBehavior)behavior).getDragState() != 0;
        }
        return false;
    }

    final class Behavior
    extends SwipeDismissBehavior<SnackbarLayout> {
        Behavior() {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout parent, SnackbarLayout child, MotionEvent event) {
            if (parent.isPointInChildBounds((View)child, (int)event.getX(), (int)event.getY())) {
                switch (event.getActionMasked()) {
                    case 0: {
                        SnackbarManager.getInstance().cancelTimeout(TSnackbar.this.mManagerCallback);
                        break;
                    }
                    case 1: 
                    case 3: {
                        SnackbarManager.getInstance().restoreTimeout(TSnackbar.this.mManagerCallback);
                    }
                }
            }
            return super.onInterceptTouchEvent(parent, (View)child, event);
        }
    }

    public static class SnackbarLayout
    extends LinearLayout {
        private TextView mMessageView;
        private Button mActionView;
        private int mMaxWidth;
        private int mMaxInlineActionWidth;
        private OnLayoutChangeListener mOnLayoutChangeListener;

        public SnackbarLayout(Context context) {
            this(context, null);
        }

        public SnackbarLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackbarLayout);
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
            this.mMaxInlineActionWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
            if (a.hasValue(R.styleable.SnackbarLayout_elevation)) {
                ViewCompat.setElevation((View)this, (float)a.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
            }
            a.recycle();
            this.setClickable(true);
            LayoutInflater.from((Context)context).inflate(R.layout.tsnackbar_layout_include, (ViewGroup)this);
        }

        protected void onFinishInflate() {
            super.onFinishInflate();
            this.mMessageView = (TextView)this.findViewById(R.id.snackbar_text);
            this.mActionView = (Button)this.findViewById(R.id.snackbar_action);
        }

        TextView getMessageView() {
            return this.mMessageView;
        }

        Button getActionView() {
            return this.mActionView;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mMaxWidth > 0 && this.getMeasuredWidth() > this.mMaxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            int multiLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
            int singleLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
            boolean isMultiLine = this.mMessageView.getLayout().getLineCount() > 1;
            boolean remeasure = false;
            if (isMultiLine && this.mMaxInlineActionWidth > 0 && this.mActionView.getMeasuredWidth() > this.mMaxInlineActionWidth) {
                if (this.updateViewsWithinLayout(1, multiLineVPadding, multiLineVPadding - singleLineVPadding)) {
                    remeasure = true;
                }
            } else {
                int messagePadding;
                int n = messagePadding = isMultiLine ? multiLineVPadding : singleLineVPadding;
                if (this.updateViewsWithinLayout(0, messagePadding, messagePadding)) {
                    remeasure = true;
                }
            }
            if (remeasure) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        void animateChildrenIn(int delay, int duration) {
            ViewCompat.setAlpha((View)this.mMessageView, (float)0.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, (float)0.0f);
                ViewCompat.animate((View)this.mActionView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        void animateChildrenOut(int delay, int duration) {
            ViewCompat.setAlpha((View)this.mMessageView, (float)1.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, (float)1.0f);
                ViewCompat.animate((View)this.mActionView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (changed && this.mOnLayoutChangeListener != null) {
                this.mOnLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
            }
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.mOnLayoutChangeListener = onLayoutChangeListener;
        }

        private boolean updateViewsWithinLayout(int orientation, int messagePadTop, int messagePadBottom) {
            boolean changed = false;
            if (orientation != this.getOrientation()) {
                this.setOrientation(orientation);
                changed = true;
            }
            if (this.mMessageView.getPaddingTop() != messagePadTop || this.mMessageView.getPaddingBottom() != messagePadBottom) {
                SnackbarLayout.updateTopBottomPadding((View)this.mMessageView, messagePadTop, messagePadBottom);
                changed = true;
            }
            return changed;
        }

        private static void updateTopBottomPadding(View view, int topPadding, int bottomPadding) {
            if (ViewCompat.isPaddingRelative((View)view)) {
                ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)topPadding, (int)ViewCompat.getPaddingEnd((View)view), (int)bottomPadding);
            } else {
                view.setPadding(view.getPaddingLeft(), topPadding, view.getPaddingRight(), bottomPadding);
            }
        }

        static interface OnLayoutChangeListener {
            public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }

    public static abstract class Callback {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        public void onDismissed(TSnackbar TSnackbar2, int event) {
        }

        public void onShown(TSnackbar TSnackbar2) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DismissEvent {
        }
    }
}

