/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import com.liujc.baseutils.view.AnimationUtil;

public final class ViewAnimationUtil {
    private ViewAnimationUtil() {
        throw new Error("Do not need instantiate!");
    }

    public static void invisibleViewByAlpha(final View view, long durationMillis, final boolean isBanClick, final Animation.AnimationListener animationListener) {
        if (view.getVisibility() != 4) {
            view.setVisibility(4);
            AlphaAnimation hiddenAlphaAnimation = AnimationUtil.getHiddenAlphaAnimation(durationMillis);
            hiddenAlphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(false);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationStart(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (animationListener != null) {
                        animationListener.onAnimationRepeat(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(true);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationEnd(animation);
                    }
                }
            });
            view.startAnimation((Animation)hiddenAlphaAnimation);
        }
    }

    public static void invisibleViewByAlpha(View view, long durationMillis, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.invisibleViewByAlpha(view, durationMillis, false, animationListener);
    }

    public static void invisibleViewByAlpha(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtil.invisibleViewByAlpha(view, durationMillis, isBanClick, null);
    }

    public static void invisibleViewByAlpha(View view, long durationMillis) {
        ViewAnimationUtil.invisibleViewByAlpha(view, durationMillis, false, null);
    }

    public static void invisibleViewByAlpha(View view, boolean isBanClick, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.invisibleViewByAlpha(view, 400L, isBanClick, animationListener);
    }

    public static void invisibleViewByAlpha(View view, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.invisibleViewByAlpha(view, 400L, false, animationListener);
    }

    public static void invisibleViewByAlpha(View view, boolean isBanClick) {
        ViewAnimationUtil.invisibleViewByAlpha(view, 400L, isBanClick, null);
    }

    public static void invisibleViewByAlpha(View view) {
        ViewAnimationUtil.invisibleViewByAlpha(view, 400L, false, null);
    }

    public static void goneViewByAlpha(final View view, long durationMillis, final boolean isBanClick, final Animation.AnimationListener animationListener) {
        if (view.getVisibility() != 8) {
            view.setVisibility(8);
            AlphaAnimation hiddenAlphaAnimation = AnimationUtil.getHiddenAlphaAnimation(durationMillis);
            hiddenAlphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(false);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationStart(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (animationListener != null) {
                        animationListener.onAnimationRepeat(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(true);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationEnd(animation);
                    }
                }
            });
            view.startAnimation((Animation)hiddenAlphaAnimation);
        }
    }

    public static void goneViewByAlpha(View view, long durationMillis, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.goneViewByAlpha(view, durationMillis, false, animationListener);
    }

    public static void goneViewByAlpha(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtil.goneViewByAlpha(view, durationMillis, isBanClick, null);
    }

    public static void goneViewByAlpha(View view, long durationMillis) {
        ViewAnimationUtil.goneViewByAlpha(view, durationMillis, false, null);
    }

    public static void goneViewByAlpha(View view, boolean isBanClick, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.goneViewByAlpha(view, 400L, isBanClick, animationListener);
    }

    public static void goneViewByAlpha(View view, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.goneViewByAlpha(view, 400L, false, animationListener);
    }

    public static void goneViewByAlpha(View view, boolean isBanClick) {
        ViewAnimationUtil.goneViewByAlpha(view, 400L, isBanClick, null);
    }

    public static void goneViewByAlpha(View view) {
        ViewAnimationUtil.goneViewByAlpha(view, 400L, false, null);
    }

    public static void visibleViewByAlpha(final View view, long durationMillis, final boolean isBanClick, final Animation.AnimationListener animationListener) {
        if (view.getVisibility() != 0) {
            view.setVisibility(0);
            AlphaAnimation showAlphaAnimation = AnimationUtil.getShowAlphaAnimation(durationMillis);
            showAlphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(false);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationStart(animation);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                    if (animationListener != null) {
                        animationListener.onAnimationRepeat(animation);
                    }
                }

                public void onAnimationEnd(Animation animation) {
                    if (isBanClick) {
                        view.setClickable(true);
                    }
                    if (animationListener != null) {
                        animationListener.onAnimationEnd(animation);
                    }
                }
            });
            view.startAnimation((Animation)showAlphaAnimation);
        }
    }

    public static void visibleViewByAlpha(View view, long durationMillis, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.visibleViewByAlpha(view, durationMillis, false, animationListener);
    }

    public static void visibleViewByAlpha(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtil.visibleViewByAlpha(view, durationMillis, isBanClick, null);
    }

    public static void visibleViewByAlpha(View view, long durationMillis) {
        ViewAnimationUtil.visibleViewByAlpha(view, durationMillis, false, null);
    }

    public static void visibleViewByAlpha(View view, boolean isBanClick, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.visibleViewByAlpha(view, 400L, isBanClick, animationListener);
    }

    public static void visibleViewByAlpha(View view, Animation.AnimationListener animationListener) {
        ViewAnimationUtil.visibleViewByAlpha(view, 400L, false, animationListener);
    }

    public static void visibleViewByAlpha(View view, boolean isBanClick) {
        ViewAnimationUtil.visibleViewByAlpha(view, 400L, isBanClick, null);
    }

    public static void visibleViewByAlpha(View view) {
        ViewAnimationUtil.visibleViewByAlpha(view, 400L, false, null);
    }

    public static void translate(final View view, float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, float cycles, long durationMillis, final boolean isBanClick) {
        TranslateAnimation translateAnimation = new TranslateAnimation(fromXDelta, toXDelta, fromYDelta, toYDelta);
        translateAnimation.setDuration(durationMillis);
        if ((double)cycles > 0.0) {
            translateAnimation.setInterpolator((Interpolator)new CycleInterpolator(cycles));
        }
        translateAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                if (isBanClick) {
                    view.setClickable(false);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (isBanClick) {
                    view.setClickable(true);
                }
            }
        });
        view.startAnimation((Animation)translateAnimation);
    }

    public static void translate(View view, float fromXDelta, float toXDelta, float fromYDelta, float toYDelta, float cycles, long durationMillis) {
        ViewAnimationUtil.translate(view, fromXDelta, toXDelta, fromYDelta, toYDelta, cycles, durationMillis, false);
    }

    public static void shake(View view, float fromXDelta, float toXDelta, float cycles, long durationMillis, boolean isBanClick) {
        ViewAnimationUtil.translate(view, fromXDelta, toXDelta, 0.0f, 0.0f, cycles, durationMillis, isBanClick);
    }

    public static void shake(View view, float fromXDelta, float toXDelta, float cycles, long durationMillis) {
        ViewAnimationUtil.translate(view, fromXDelta, toXDelta, 0.0f, 0.0f, cycles, durationMillis, false);
    }

    public static void shake(View view, float cycles, long durationMillis, boolean isBanClick) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, durationMillis, isBanClick);
    }

    public static void shake(View view, float cycles, boolean isBanClick) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, 700L, isBanClick);
    }

    public static void shake(View view, float cycles, long durationMillis) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, durationMillis, false);
    }

    public static void shake(View view, long durationMillis, boolean isBanClick) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, durationMillis, isBanClick);
    }

    public static void shake(View view, float cycles) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, cycles, 700L, false);
    }

    public static void shake(View view, long durationMillis) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, durationMillis, false);
    }

    public static void shake(View view, boolean isBanClick) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, 700L, isBanClick);
    }

    public static void shake(View view) {
        ViewAnimationUtil.translate(view, 0.0f, 10.0f, 0.0f, 0.0f, 7.0f, 700L, false);
    }
}

