/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.os.CountDownTimer;
import android.widget.TextView;

public class CountTimeUtil {
    private static CountTimeUtil ourInstance = new CountTimeUtil();
    private boolean mRunning = false;
    private String cache = "60";
    private TextView mBindView = null;
    private CountDownTimer countDownTimer = new CountDownTimer(60000L, 1000L){

        public void onTick(long l) {
            CountTimeUtil.this.cache = "" + l / 1000L;
            if (CountTimeUtil.this.mBindView != null) {
                CountTimeUtil.this.mBindView.setText((CharSequence)(CountTimeUtil.this.cache + "s"));
            }
        }

        public void onFinish() {
            CountTimeUtil.this.mRunning = false;
            if (CountTimeUtil.this.mBindView != null) {
                CountTimeUtil.this.mBindView.setEnabled(true);
                CountTimeUtil.this.mBindView.setText((CharSequence)"\u91cd\u65b0\u53d1\u9001");
            }
        }
    };

    public static CountTimeUtil getInstance() {
        return ourInstance;
    }

    private CountTimeUtil() {
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void bindView(TextView textView) {
        this.reset();
        if (this.isRunning()) {
            textView.setEnabled(false);
            textView.setText((CharSequence)(this.cache + "s"));
        }
        this.mBindView = textView;
    }

    public void unBindView() {
        this.mBindView = null;
    }

    public void start() {
        if (this.mBindView != null) {
            this.mBindView.setEnabled(false);
        }
        this.mRunning = true;
        this.countDownTimer.start();
    }

    public void reset() {
        this.countDownTimer.cancel();
        this.mRunning = false;
        this.cache = "60";
        if (this.mBindView != null) {
            this.mBindView.setEnabled(true);
            this.mBindView.setText((CharSequence)"\u91cd\u65b0\u53d1\u9001");
        }
    }
}

