/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.view;

import android.content.Context;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.liujc.baseutils.R;
import com.liujc.baseutils.view.ImageLoaderUtil;

public class AdViewpagerUtil {
    private Context context;
    private ViewPager viewPager;
    private AdPagerAdapter mimageViewPagerAdapter;
    private ImageView[] mImageViews;
    private String[] urls;
    private LinearLayout dotlayout;
    private ImageView[] dotViews;
    private boolean isRight = true;
    private int lastPosition = 1;
    private int autoIndex = 1;
    private int currentIndex = 0;
    private int delayTime = 5000;
    private int imgsize = 0;
    private boolean isLoop = false;
    private OnAdPageChangeListener onAdPageChangeListener;
    private OnAdItemClickListener onAdItemClickListener;
    private int dotsize = 8;
    private int dotoffset = 4;
    Handler handler = new Handler();
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (AdViewpagerUtil.this.viewPager.getChildCount() > 0) {
                AdViewpagerUtil.this.handler.postDelayed((Runnable)this, (long)AdViewpagerUtil.this.delayTime);
                AdViewpagerUtil.this.autoIndex++;
                AdViewpagerUtil.this.viewPager.setCurrentItem(AdViewpagerUtil.this.autoIndex % AdViewpagerUtil.this.imgsize, true);
            }
        }
    };

    public AdViewpagerUtil(Context context, ViewPager viewPager, String[] urls) {
        this.context = context;
        this.viewPager = viewPager;
        this.urls = urls;
        this.initVps();
    }

    public AdViewpagerUtil(Context context, ViewPager viewPager, LinearLayout dotlayout, int dotsize, int dotoffset, String[] urls) {
        this.context = context;
        this.viewPager = viewPager;
        this.dotlayout = dotlayout;
        this.dotsize = dotsize;
        this.urls = urls;
        this.initVps();
    }

    public AdViewpagerUtil(Context context, ViewPager viewPager, LinearLayout dotlayout, String[] urls) {
        this.context = context;
        this.viewPager = viewPager;
        this.dotlayout = dotlayout;
        this.urls = urls;
        this.initVps();
    }

    public void setOnAdPageChangeListener(OnAdPageChangeListener onAdPageChangeListener) {
        this.onAdPageChangeListener = onAdPageChangeListener;
    }

    public void setOnAdItemClickListener(OnAdItemClickListener onAdItemClickListener) {
        this.onAdItemClickListener = onAdItemClickListener;
    }

    private void initAdimgs(String[] urls) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        int length = urls.length + 2;
        this.mImageViews = new ImageView[length];
        for (int i = 0; i < length; ++i) {
            ImageView imageView = new ImageView(this.context);
            imageView.setLayoutParams((ViewGroup.LayoutParams)params);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.mImageViews[i] = imageView;
        }
        this.setImg(length, urls);
    }

    private void setImg(int length, String[] urls) {
        if (urls.length > 0) {
            this.imgsize = length;
            for (int i = 0; i < length; ++i) {
                if (i >= length - 2) continue;
                final int index = i;
                final String url = urls[i];
                ImageLoaderUtil.display(this.context, this.mImageViews[i + 1], url);
                this.mImageViews[i + 1].setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (AdViewpagerUtil.this.onAdItemClickListener != null) {
                            AdViewpagerUtil.this.onAdItemClickListener.onItemClick((View)AdViewpagerUtil.this.mImageViews[index + 1], index, url);
                        }
                    }
                });
            }
            ImageLoaderUtil.display(this.context, this.mImageViews[0], urls[urls.length - 1]);
            ImageLoaderUtil.display(this.context, this.mImageViews[length - 1], urls[0]);
        }
    }

    public void initVps() {
        this.initAdimgs(this.urls);
        this.initDots(this.urls.length);
        this.mimageViewPagerAdapter = new AdPagerAdapter(this.context, this.mImageViews);
        this.viewPager.setAdapter((PagerAdapter)this.mimageViewPagerAdapter);
        this.viewPager.setOffscreenPageLimit(this.mImageViews.length);
        this.startLoopViewPager();
        this.viewPager.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int action = event.getAction();
                switch (action) {
                    case 0: 
                    case 2: {
                        AdViewpagerUtil.this.isLoop = true;
                        AdViewpagerUtil.this.stopLoopViewPager();
                        break;
                    }
                    case 1: 
                    case 3: {
                        AdViewpagerUtil.this.isLoop = false;
                        AdViewpagerUtil.this.startLoopViewPager();
                    }
                }
                return false;
            }
        });
        this.viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrollStateChanged(int arg0) {
                if (AdViewpagerUtil.this.isRight && arg0 != 1) {
                    if (AdViewpagerUtil.this.lastPosition == 0) {
                        AdViewpagerUtil.this.viewPager.setCurrentItem(AdViewpagerUtil.this.imgsize - 2, false);
                    } else if (AdViewpagerUtil.this.lastPosition == AdViewpagerUtil.this.imgsize - 1) {
                        AdViewpagerUtil.this.viewPager.setCurrentItem(1, false);
                    }
                }
                if (AdViewpagerUtil.this.onAdPageChangeListener != null) {
                    AdViewpagerUtil.this.onAdPageChangeListener.onPageScrollStateChanged(arg0);
                }
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
                if (!AdViewpagerUtil.this.isRight && (double)arg1 < 0.01) {
                    if (arg0 == 0) {
                        AdViewpagerUtil.this.viewPager.setCurrentItem(AdViewpagerUtil.this.imgsize - 2, false);
                    } else if (arg0 == AdViewpagerUtil.this.imgsize - 1) {
                        AdViewpagerUtil.this.viewPager.setCurrentItem(1, false);
                    }
                }
                if (AdViewpagerUtil.this.onAdPageChangeListener != null) {
                    AdViewpagerUtil.this.onAdPageChangeListener.onPageScrolled(arg0, arg1, arg2);
                }
            }

            public void onPageSelected(int arg0) {
                AdViewpagerUtil.this.autoIndex = arg0;
                if (AdViewpagerUtil.this.lastPosition < arg0 && AdViewpagerUtil.this.lastPosition != 0) {
                    AdViewpagerUtil.this.isRight = true;
                } else if (AdViewpagerUtil.this.lastPosition == AdViewpagerUtil.this.imgsize - 1) {
                    AdViewpagerUtil.this.isRight = true;
                }
                if (AdViewpagerUtil.this.lastPosition > arg0 && AdViewpagerUtil.this.lastPosition != AdViewpagerUtil.this.imgsize - 1) {
                    AdViewpagerUtil.this.isRight = false;
                } else if (AdViewpagerUtil.this.lastPosition == 0) {
                    AdViewpagerUtil.this.isRight = false;
                }
                AdViewpagerUtil.this.lastPosition = arg0;
                if (arg0 == 0) {
                    AdViewpagerUtil.this.currentIndex = AdViewpagerUtil.this.imgsize - 2;
                } else if (arg0 == AdViewpagerUtil.this.imgsize - 1) {
                    AdViewpagerUtil.this.currentIndex = 1;
                } else {
                    AdViewpagerUtil.this.currentIndex = arg0;
                }
                for (int i = 0; i < AdViewpagerUtil.this.dotViews.length; ++i) {
                    if (i == AdViewpagerUtil.this.currentIndex - 1) {
                        AdViewpagerUtil.this.dotViews[i].setSelected(true);
                        continue;
                    }
                    AdViewpagerUtil.this.dotViews[i].setSelected(false);
                }
                if (AdViewpagerUtil.this.onAdPageChangeListener != null) {
                    AdViewpagerUtil.this.onAdPageChangeListener.onPageSelected(arg0);
                }
            }
        });
        this.viewPager.setCurrentItem(1);
    }

    public void initDots(int length) {
        if (this.dotlayout == null) {
            return;
        }
        this.dotlayout.removeAllViews();
        LinearLayout.LayoutParams mParams = new LinearLayout.LayoutParams(this.dip2px(this.context, this.dotsize), this.dip2px(this.context, this.dotsize));
        mParams.setMargins(this.dip2px(this.context, this.dotoffset), 0, this.dip2px(this.context, this.dotoffset), 0);
        this.dotViews = new ImageView[length];
        for (int i = 0; i < length; ++i) {
            ImageView imageView = new ImageView(this.context);
            imageView.setLayoutParams((ViewGroup.LayoutParams)mParams);
            imageView.setImageResource(R.drawable.dot_selector);
            if (i == 0) {
                imageView.setSelected(true);
            } else {
                imageView.setSelected(false);
            }
            this.dotViews[i] = imageView;
            this.dotlayout.addView((View)imageView);
        }
    }

    private void startLoopViewPager() {
        if (!this.isLoop && this.viewPager != null && this.handler != null) {
            this.handler.postDelayed(this.runnable, (long)this.delayTime);
            this.isLoop = true;
        }
    }

    private void stopLoopViewPager() {
        if (this.isLoop && this.viewPager != null && this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.isLoop = false;
        }
    }

    public int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private static class AdPagerAdapter
    extends PagerAdapter {
        private ImageView[] imageViews;
        private int size;
        private Context context;

        public AdPagerAdapter(Context context, ImageView[] imageViews) {
            this.context = context;
            this.imageViews = imageViews;
            this.size = imageViews.length;
        }

        public int getCount() {
            return this.imageViews.length;
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)this.imageViews[position]);
        }

        public Object instantiateItem(ViewGroup container, int position) {
            container.addView((View)this.imageViews[position], 0);
            return this.imageViews[position];
        }
    }

    public static interface OnAdPageChangeListener {
        public void onPageScrollStateChanged(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    public static interface OnAdItemClickListener {
        public void onItemClick(View var1, int var2, String var3);
    }
}

