/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import com.liujc.baseutils.common.LogUtil;

public class WakeLock {
    PowerManager powerManager;
    PowerManager.WakeLock wakeLock;

    public WakeLock(Context context, String tag) {
        this.powerManager = (PowerManager)context.getSystemService("power");
        this.wakeLock = this.powerManager.newWakeLock(0x1000001A, tag);
    }

    public boolean isScreenOn() {
        if (Build.VERSION.SDK_INT < 7) {
            LogUtil.d("can not call isScreenOn if SDK_INT < 7 ");
            return false;
        }
        return this.powerManager.isScreenOn();
    }

    public void turnScreenOn() {
        LogUtil.d("PowerManager.WakeLock : wakeLock.isHeld: " + this.wakeLock.isHeld());
        if (!this.wakeLock.isHeld()) {
            LogUtil.d("PowerManager.WakeLock : \u70b9\u4eae\u5c4f\u5e55");
            this.wakeLock.acquire();
        }
    }

    public void turnScreenOff() {
        LogUtil.d("PowerManager.WakeLock : wakeLock.isHeld: " + this.wakeLock.isHeld());
        if (this.wakeLock.isHeld()) {
            LogUtil.d("PowerManager.WakeLock : \u706d\u6389\u5c4f\u5e55");
            try {
                this.wakeLock.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.e("Exception", e);
            }
        }
    }

    public void release() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            try {
                this.wakeLock.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.e("Exception", e);
            }
        }
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.wakeLock;
    }

    public void setWakeLock(PowerManager.WakeLock wakeLock) {
        this.wakeLock = wakeLock;
    }

    public PowerManager getPowerManager() {
        return this.powerManager;
    }

    public void setPowerManager(PowerManager powerManager) {
        this.powerManager = powerManager;
    }
}

