/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import com.liujc.baseutils.common.ShellUtil;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class DeviceUtil {
    private DeviceUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getDeviceSDK() {
        return Build.VERSION.SDK_INT;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDeviceModel() {
        String model = Build.MODEL;
        model = model != null ? model.trim().replaceAll("\\s*", "") : "";
        return model;
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getIMSI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String IMSI = telephonyManager.getSubscriberId();
        return IMSI;
    }

    public static String getIMEI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String IMEI = telephonyManager.getDeviceId();
        return IMEI;
    }

    public static boolean isDeviceRoot() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=3)
    public static String getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return Formatter.formatFileSize((Context)context, (long)mi.availMem);
    }

    public static String getMacAddress(Context context) {
        String macAddress = DeviceUtil.getMacAddressByWifiInfo(context);
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtil.getMacAddressByNetworkInterface();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        macAddress = DeviceUtil.getMacAddressByFile();
        if (!"02:00:00:00:00:00".equals(macAddress)) {
            return macAddress;
        }
        return "please open wifi";
    }

    @SuppressLint(value={"HardwareIds"})
    private static String getMacAddressByWifiInfo(Context context) {
        try {
            WifiInfo info;
            WifiManager wifi = (WifiManager)context.getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                return info.getMacAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByNetworkInterface() {
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface ni : nis) {
                byte[] macBytes;
                if (!ni.getName().equalsIgnoreCase("wlan0") || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02x:", b));
                }
                return res1.deleteCharAt(res1.length() - 1).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private static String getMacAddressByFile() {
        String name;
        ShellUtil.CommandResult result = ShellUtil.execCmd("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            result = ShellUtil.execCmd("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0 && result.successMsg != null) {
                return result.successMsg;
            }
        }
        return "02:00:00:00:00:00";
    }

    public static String getBootTimeString() {
        long ut = SystemClock.elapsedRealtime() / 1000L;
        int h = (int)(ut / 3600L);
        int m = (int)(ut / 60L % 60L);
        return h + ":" + m;
    }

    public static void shutdown() {
        ShellUtil.execCmd("reboot -p", true);
    }

    public static void shutdown(Context context) {
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void reboot() {
        ShellUtil.execCmd("reboot", true);
    }

    public static void reboot(Context context) {
        Intent intent = new Intent("android.intent.action.REBOOT");
        intent.putExtra("nowait", 1);
        intent.putExtra("interval", 1);
        intent.putExtra("window", 0);
        context.sendBroadcast(intent);
    }

    public static void reboot(Context context, String reason) {
        PowerManager mPowerManager = (PowerManager)context.getSystemService("power");
        try {
            mPowerManager.reboot(reason);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reboot2Recovery() {
        ShellUtil.execCmd("reboot recovery", true);
    }

    public static void reboot2Bootloader() {
        ShellUtil.execCmd("reboot bootloader", true);
    }
}

