/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.system;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import com.liujc.baseutils.common.LogUtil;
import com.liujc.baseutils.common.ShellUtil;
import com.liujc.baseutils.common.StringUtil;
import com.liujc.baseutils.file.CleanUtil;
import com.liujc.baseutils.file.FileUtil;
import com.liujc.baseutils.sucurity.EncryptUtil;
import com.liujc.baseutils.system.IntentUtil;
import com.liujc.baseutils.system.ProcessUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AppUtil {
    private static long lastClickTime;

    private AppUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        long timeD = time - lastClickTime;
        if (0L < timeD && timeD < 1000L) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static void shareToOtherApp(Context context, String title, String content, String dialogTitle) {
        Intent intentItem = new Intent("android.intent.action.SEND");
        intentItem.setType("text/plain");
        intentItem.putExtra("android.intent.extra.SUBJECT", title);
        intentItem.putExtra("android.intent.extra.TEXT", content);
        intentItem.setFlags(0x10000000);
        context.startActivity(Intent.createChooser((Intent)intentItem, (CharSequence)dialogTitle));
    }

    public static boolean isInstallApp(Context context, String packageName) {
        return !StringUtil.isSpace(packageName) && IntentUtil.getLaunchAppIntent(context, packageName) != null;
    }

    public static void installApp(Context context, String filePath) {
        AppUtil.installApp(context, FileUtil.getFileByPath(filePath));
    }

    public static void installApp(Context context, File file) {
        if (!FileUtil.isFileExists(file)) {
            return;
        }
        context.startActivity(IntentUtil.getInstallAppIntent(file));
    }

    public static void installApp(Activity activity, String filePath, int requestCode) {
        AppUtil.installApp(activity, FileUtil.getFileByPath(filePath), requestCode);
    }

    public static void installApp(Activity activity, File file, int requestCode) {
        if (!FileUtil.isFileExists(file)) {
            return;
        }
        activity.startActivityForResult(IntentUtil.getInstallAppIntent(file), requestCode);
    }

    public static boolean installAppSilent(Context context, String filePath) {
        File file = FileUtil.getFileByPath(filePath);
        if (!FileUtil.isFileExists(file)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm install " + filePath;
        ShellUtil.CommandResult commandResult = ShellUtil.execCmd(command, !AppUtil.isSystemApp(context), true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static void uninstallApp(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return;
        }
        context.startActivity(IntentUtil.getUninstallAppIntent(packageName));
    }

    public static void uninstallApp(Activity activity, String packageName, int requestCode) {
        if (StringUtil.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(IntentUtil.getUninstallAppIntent(packageName), requestCode);
    }

    public static boolean uninstallAppSilent(Context context, String packageName, boolean isKeepData) {
        if (StringUtil.isSpace(packageName)) {
            return false;
        }
        String command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib pm uninstall " + (isKeepData ? "-k " : "") + packageName;
        ShellUtil.CommandResult commandResult = ShellUtil.execCmd(command, !AppUtil.isSystemApp(context), true);
        return commandResult.successMsg != null && commandResult.successMsg.toLowerCase().contains("success");
    }

    public static boolean isAppRoot() {
        ShellUtil.CommandResult result = ShellUtil.execCmd("echo root", true);
        if (result.result == 0) {
            return true;
        }
        if (result.errorMsg != null) {
            LogUtil.d(result.errorMsg);
        }
        return false;
    }

    public static void launchApp(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return;
        }
        context.startActivity(IntentUtil.getLaunchAppIntent(context, packageName));
    }

    public static void launchApp(Activity activity, String packageName, int requestCode) {
        if (StringUtil.isSpace(packageName)) {
            return;
        }
        activity.startActivityForResult(IntentUtil.getLaunchAppIntent((Context)activity, packageName), requestCode);
    }

    public static String getAppPackageName(Context context) {
        return context.getPackageName();
    }

    public static void getAppDetailsSettings(Context context) {
        AppUtil.getAppDetailsSettings(context, context.getPackageName());
    }

    public static void getAppDetailsSettings(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return;
        }
        context.startActivity(IntentUtil.getAppDetailsSettingsIntent(packageName));
    }

    public static String getAppName(Context context) {
        return AppUtil.getAppName(context, context.getPackageName());
    }

    public static String getAppName(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Drawable getAppIcon(Context context) {
        return AppUtil.getAppIcon(context, context.getPackageName());
    }

    public static Drawable getAppIcon(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppPath(Context context) {
        return AppUtil.getAppPath(context, context.getPackageName());
    }

    public static String getAppPath(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppVersionName(Context context) {
        return AppUtil.getAppVersionName(context, context.getPackageName());
    }

    public static String getAppVersionName(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppVersionCode(Context context) {
        return AppUtil.getAppVersionCode(context, context.getPackageName());
    }

    public static int getAppVersionCode(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return -1;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? -1 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isSystemApp(Context context) {
        return AppUtil.isSystemApp(context, context.getPackageName());
    }

    public static boolean isSystemApp(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppDebug(Context context) {
        return AppUtil.isAppDebug(context, context.getPackageName());
    }

    public static boolean isAppDebug(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Signature[] getAppSignature(Context context) {
        return AppUtil.getAppSignature(context, context.getPackageName());
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static Signature[] getAppSignature(Context context, String packageName) {
        if (StringUtil.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppSignatureSHA1(Context context) {
        return AppUtil.getAppSignatureSHA1(context, context.getPackageName());
    }

    public static String getAppSignatureSHA1(Context context, String packageName) {
        Signature[] signature = AppUtil.getAppSignature(context, packageName);
        if (signature == null) {
            return null;
        }
        return EncryptUtil.encryptSHA1ToString(signature[0].toByteArray()).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static boolean isAppForeground(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List infos = manager.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.importance != 100) continue;
            return info.processName.equals(context.getPackageName());
        }
        return false;
    }

    public static boolean isAppForeground(Context context, String packageName) {
        return !StringUtil.isSpace(packageName) && packageName.equals(ProcessUtil.getForegroundProcessName(context));
    }

    public static AppInfo getAppInfo(Context context) {
        return AppUtil.getAppInfo(context, context.getPackageName());
    }

    public static AppInfo getAppInfo(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return AppUtil.getBean(pm, pi);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static AppInfo getBean(PackageManager pm, PackageInfo pi) {
        if (pm == null || pi == null) {
            return null;
        }
        ApplicationInfo ai = pi.applicationInfo;
        String packageName = pi.packageName;
        String name = ai.loadLabel(pm).toString();
        Drawable icon = ai.loadIcon(pm);
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSystem = (1 & ai.flags) != 0;
        return new AppInfo(packageName, name, icon, packagePath, versionName, versionCode, isSystem);
    }

    public static List<AppInfo> getAppsInfo(Context context) {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>();
        PackageManager pm = context.getPackageManager();
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            AppInfo ai = AppUtil.getBean(pm, pi);
            if (ai == null) continue;
            list.add(ai);
        }
        return list;
    }

    public static boolean cleanAppData(Context context, String ... dirPaths) {
        File[] dirs = new File[dirPaths.length];
        int i = 0;
        for (String dirPath : dirPaths) {
            dirs[i++] = new File(dirPath);
        }
        return AppUtil.cleanAppData(context, dirs);
    }

    public static boolean cleanAppData(Context context, File ... dirs) {
        boolean isSuccess = CleanUtil.cleanInternalCache(context);
        isSuccess &= CleanUtil.cleanInternalDbs(context);
        isSuccess &= CleanUtil.cleanInternalSP(context);
        isSuccess &= CleanUtil.cleanInternalFiles(context);
        isSuccess &= CleanUtil.cleanExternalCache(context);
        for (File dir : dirs) {
            isSuccess &= CleanUtil.cleanCustomCache(dir);
        }
        return isSuccess;
    }

    public static class AppInfo {
        private String name;
        private Drawable icon;
        private String packageName;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSystem;

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public void setSystem(boolean isSystem) {
            this.isSystem = isSystem;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packagName) {
            this.packageName = packagName;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public AppInfo(String packageName, String name, Drawable icon, String packagePath, String versionName, int versionCode, boolean isSystem) {
            this.setName(name);
            this.setIcon(icon);
            this.setPackageName(packageName);
            this.setPackagePath(packagePath);
            this.setVersionName(versionName);
            this.setVersionCode(versionCode);
            this.setSystem(isSystem);
        }

        public String toString() {
            return "App\u5305\u540d\uff1a" + this.getPackageName() + "\nApp\u540d\u79f0\uff1a" + this.getName() + "\nApp\u56fe\u6807\uff1a" + this.getIcon() + "\nApp\u8def\u5f84\uff1a" + this.getPackagePath() + "\nApp\u7248\u672c\u53f7\uff1a" + this.getVersionName() + "\nApp\u7248\u672c\u7801\uff1a" + this.getVersionCode() + "\n\u662f\u5426\u7cfb\u7edfApp\uff1a" + this.isSystem();
        }
    }
}

