/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.receiver;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import com.liujc.baseutils.common.LogUtil;
import java.util.ArrayList;

public class SmsReceiver
extends BroadcastReceiver {
    private SmsListener smsListener;

    public void onReceive(Context context, Intent intent) {
        try {
            LogUtil.d("\u6536\u5230\u5e7f\u64ad\uff1a" + intent.getAction());
            Bundle bundle = intent.getExtras();
            for (String key : bundle.keySet()) {
                LogUtil.d(key + " : " + bundle.get(key));
            }
            Object[] pdus = (Object[])intent.getExtras().get("pdus");
            String fromAddress = null;
            String serviceCenterAddress = null;
            if (pdus != null) {
                String msgBody = "";
                if (Build.VERSION.SDK_INT >= 4) {
                    for (Object obj : pdus) {
                        SmsMessage sms = SmsMessage.createFromPdu((byte[])((byte[])obj));
                        msgBody = msgBody + sms.getMessageBody();
                        fromAddress = sms.getOriginatingAddress();
                        serviceCenterAddress = sms.getServiceCenterAddress();
                        if (this.smsListener != null) {
                            this.smsListener.onMessage(sms);
                        }
                        LogUtil.d("getDisplayMessageBody\uff1a" + sms.getDisplayMessageBody());
                        LogUtil.d("getDisplayOriginatingAddress\uff1a" + sms.getDisplayOriginatingAddress());
                        LogUtil.d("getEmailBody\uff1a" + sms.getEmailBody());
                        LogUtil.d("getEmailFrom\uff1a" + sms.getEmailFrom());
                        LogUtil.d("getMessageBody\uff1a" + sms.getMessageBody());
                        LogUtil.d("getOriginatingAddress\uff1a" + sms.getOriginatingAddress());
                        LogUtil.d("getPseudoSubject\uff1a" + sms.getPseudoSubject());
                        LogUtil.d("getServiceCenterAddress\uff1a" + sms.getServiceCenterAddress());
                        LogUtil.d("getIndexOnIcc\uff1a" + sms.getIndexOnIcc());
                        LogUtil.d("getMessageClass\uff1a" + sms.getMessageClass());
                        LogUtil.d("getUserData\uff1a" + new String(sms.getUserData()));
                    }
                }
                if (this.smsListener != null) {
                    this.smsListener.onMessage(msgBody, fromAddress, serviceCenterAddress);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerSmsReceiver(Context context, SmsListener smsListener) {
        try {
            this.smsListener = smsListener;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.provider.Telephony.SMS_RECEIVED");
            filter.setPriority(Integer.MAX_VALUE);
            context.registerReceiver((BroadcastReceiver)this, filter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unRegisterSmsReceiver(Context context) {
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendMsgToPhone(String phone, String msg) {
        LogUtil.d("\u53d1\u9001\u624b\u673a\uff1a" + phone + " ,\u5185\u5bb9\uff1a " + msg);
        if (Build.VERSION.SDK_INT >= 4) {
            SmsManager manager = SmsManager.getDefault();
            ArrayList texts = manager.divideMessage(msg);
            for (String txt : texts) {
                manager.sendTextMessage(phone, null, txt, null, null);
            }
        } else {
            LogUtil.d("\u53d1\u9001\u5931\u8d25\uff0c\u7cfb\u7edf\u7248\u672c\u4f4e\u4e8eDONUT\uff0c" + phone + " ,\u5185\u5bb9\uff1a " + msg);
        }
    }

    public static void saveMsgToSystem(Context context, String phone, String msg) {
        ContentValues values = new ContentValues();
        values.put("date", Long.valueOf(System.currentTimeMillis()));
        values.put("read", Integer.valueOf(0));
        values.put("type", Integer.valueOf(2));
        values.put("address", phone);
        values.put("body", msg);
        context.getContentResolver().insert(Uri.parse((String)"content://sms/inbox"), values);
    }

    public static abstract class SmsListener {
        public abstract void onMessage(String var1, String var2, String var3);

        public void onMessage(SmsMessage msg) {
        }
    }
}

