/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Map;
import java.util.Set;

public class SharedPreferencesUtil {
    private static SharedPreferencesUtil prefsUtil;
    public Context context;
    public SharedPreferences prefs;
    public SharedPreferences.Editor editor;

    public static synchronized SharedPreferencesUtil getInstance() {
        return prefsUtil;
    }

    public static void init(Context context, String prefsname) {
        SharedPreferencesUtil.init(context, prefsname, 0);
    }

    public static void init(Context context, String prefsname, int mode) {
        prefsUtil = new SharedPreferencesUtil();
        SharedPreferencesUtil.prefsUtil.context = context;
        SharedPreferencesUtil.prefsUtil.prefs = SharedPreferencesUtil.prefsUtil.context.getSharedPreferences(prefsname, mode);
        SharedPreferencesUtil.prefsUtil.editor = SharedPreferencesUtil.prefsUtil.prefs.edit();
    }

    private SharedPreferencesUtil() {
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        return this.prefs.getBoolean(key, defaultVal);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, false);
    }

    public String getString(String key, String defaultVal) {
        return this.prefs.getString(key, defaultVal);
    }

    public String getString(String key) {
        return this.prefs.getString(key, null);
    }

    public int getInt(String key, int defaultVal) {
        return this.prefs.getInt(key, defaultVal);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, 0);
    }

    public float getFloat(String key, float defaultVal) {
        return this.prefs.getFloat(key, defaultVal);
    }

    public float getFloat(String key) {
        return this.prefs.getFloat(key, 0.0f);
    }

    public long getLong(String key, long defaultVal) {
        return this.prefs.getLong(key, defaultVal);
    }

    public long getLong(String key) {
        return this.prefs.getLong(key, 0L);
    }

    @TargetApi(value=11)
    public Set<String> getStringSet(String key, Set<String> defaultVal) {
        return this.prefs.getStringSet(key, defaultVal);
    }

    @TargetApi(value=11)
    public Set<String> getStringSet(String key) {
        return this.prefs.getStringSet(key, null);
    }

    public Map<String, ?> getAll() {
        return this.prefs.getAll();
    }

    public boolean exists(String key) {
        return this.prefs.contains(key);
    }

    public SharedPreferencesUtil putString(String key, String value) {
        this.editor.putString(key, value);
        this.editor.commit();
        return this;
    }

    public SharedPreferencesUtil putInt(String key, int value) {
        this.editor.putInt(key, value);
        this.editor.commit();
        return this;
    }

    public SharedPreferencesUtil putFloat(String key, float value) {
        this.editor.putFloat(key, value);
        this.editor.commit();
        return this;
    }

    public SharedPreferencesUtil putLong(String key, long value) {
        this.editor.putLong(key, value);
        this.editor.commit();
        return this;
    }

    public SharedPreferencesUtil putBoolean(String key, boolean value) {
        this.editor.putBoolean(key, value);
        this.editor.commit();
        return this;
    }

    public void commit() {
        this.editor.commit();
    }

    @TargetApi(value=11)
    public SharedPreferencesUtil putStringSet(String key, Set<String> value) {
        this.editor.putStringSet(key, value);
        this.editor.commit();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(String key, Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(baos);
            out.writeObject(object);
            String objectVal = new String(Base64.encode((byte[])baos.toByteArray(), (int)0));
            this.editor.putString(key, objectVal);
            this.editor.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getObject(String key, Class<T> clazz) {
        if (this.prefs.contains(key)) {
            String objectVal = this.prefs.getString(key, null);
            byte[] buffer = Base64.decode((String)objectVal, (int)0);
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            ObjectInputStream ois = null;
            try {
                Object t;
                ois = new ObjectInputStream(bais);
                Object object = t = ois.readObject();
                return (T)object;
            }
            catch (StreamCorruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public boolean contains(String key) {
        return this.prefs.contains(key);
    }

    public SharedPreferencesUtil remove(String key) {
        this.editor.remove(key);
        this.editor.commit();
        return this;
    }

    public SharedPreferencesUtil removeAll() {
        this.editor.clear();
        this.editor.apply();
        return this;
    }
}

