/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.annotation.TargetApi;
import android.os.Environment;
import android.os.StatFs;
import com.liujc.baseutils.convert.ConvertUtil;
import com.liujc.baseutils.file.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;

public class SDCardUtil {
    private SDCardUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isSDCardEnable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSDCardPath() {
        if (!SDCardUtil.isSDCardEnable()) {
            return "sdcard unable!";
        }
        cmd = "cat /proc/mounts";
        run = Runtime.getRuntime();
        bufferedReader = null;
        try {
            p = run.exec(cmd);
            bufferedReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(p.getInputStream())));
lbl9:
            // 2 sources

            while ((lineStr = bufferedReader.readLine()) != null) {
                if (!lineStr.contains("sdcard") || !lineStr.contains(".android_secure") || (strArray = lineStr.split(" ")).length < 5) ** GOTO lbl-1000
                var6_7 = strArray[1].replace("/.android_secure", "") + File.separator;
                ** GOTO lbl21
            }
            ** GOTO lbl27
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable var7_8) {
                CloseUtil.closeIO(new Closeable[]{bufferedReader});
                throw var7_8;
            }
lbl21:
            // 1 sources

            CloseUtil.closeIO(new Closeable[]{bufferedReader});
            return var6_7;
lbl-1000:
            // 1 sources

            {
                if (p.waitFor() == 0 || p.exitValue() != 1) ** GOTO lbl9
                var5_6 = " \u547d\u4ee4\u6267\u884c\u5931\u8d25";
            }
            CloseUtil.closeIO(new Closeable[]{bufferedReader});
            return var5_6;
lbl27:
            // 1 sources

            CloseUtil.closeIO(new Closeable[]{bufferedReader});
            return Environment.getExternalStorageDirectory().getPath() + File.separator;
            CloseUtil.closeIO(new Closeable[]{bufferedReader});
            return Environment.getExternalStorageDirectory().getPath() + File.separator;
        }
    }

    public static String getDataPath() {
        if (!SDCardUtil.isSDCardEnable()) {
            return "sdcard unable!";
        }
        return Environment.getExternalStorageDirectory().getPath() + File.separator + "data" + File.separator;
    }

    @TargetApi(value=18)
    public static String getFreeSpace() {
        if (!SDCardUtil.isSDCardEnable()) {
            return "sdcard unable!";
        }
        StatFs stat = new StatFs(SDCardUtil.getSDCardPath());
        long availableBlocks = stat.getAvailableBlocksLong();
        long blockSize = stat.getBlockSizeLong();
        return ConvertUtil.byte2FitSize(availableBlocks * blockSize);
    }

    @TargetApi(value=18)
    public static String getSDCardInfo() {
        SDCardInfo sd = new SDCardInfo();
        if (!SDCardUtil.isSDCardEnable()) {
            return "sdcard unable!";
        }
        sd.isExist = true;
        StatFs sf = new StatFs(Environment.getExternalStorageDirectory().getPath());
        sd.totalBlocks = sf.getBlockCountLong();
        sd.blockByteSize = sf.getBlockSizeLong();
        sd.availableBlocks = sf.getAvailableBlocksLong();
        sd.availableBytes = sf.getAvailableBytes();
        sd.freeBlocks = sf.getFreeBlocksLong();
        sd.freeBytes = sf.getFreeBytes();
        sd.totalBytes = sf.getTotalBytes();
        return sd.toString();
    }

    public static class SDCardInfo {
        boolean isExist;
        long totalBlocks;
        long freeBlocks;
        long availableBlocks;
        long blockByteSize;
        long totalBytes;
        long freeBytes;
        long availableBytes;

        public String toString() {
            return "isExist=" + this.isExist + "\ntotalBlocks=" + this.totalBlocks + "\nfreeBlocks=" + this.freeBlocks + "\navailableBlocks=" + this.availableBlocks + "\nblockByteSize=" + this.blockByteSize + "\ntotalBytes=" + this.totalBytes + "\nfreeBytes=" + this.freeBytes + "\navailableBytes=" + this.availableBytes;
        }
    }
}

