/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.content.Context;
import java.lang.reflect.Field;

public class ResourceUtil {
    public static final String POINT = "";
    public static final String R = "R";
    public static final String JOIN = "$";
    public static final String ANIM = "anim";
    public static final String ATTR = "attr";
    public static final String COLOR = "color";
    public static final String DIMEN = "dimen";
    public static final String DRAWABLE = "drawable";
    public static final String ID = "id";
    public static final String LAYOUT = "layout";
    public static final String MENU = "menu";
    public static final String RAW = "raw";
    public static final String STRING = "string";
    public static final String STYLE = "style";
    public static final String STYLEABLE = "styleable";

    private ResourceUtil() {
        throw new Error("Do not need instantiate!");
    }

    public static int getAnim(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + ANIM).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getAttr(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + ATTR).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getColor(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + COLOR).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getDimen(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + DIMEN).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getDrawable(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + DRAWABLE).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getId(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + ID).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getLayout(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + LAYOUT).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getMenu(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + MENU).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getRaw(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + RAW).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getString(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + STRING).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getStyle(Context context, String name) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + STYLE).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int[] getStyleable(Context context, String name) {
        try {
            return (int[])Class.forName(context.getPackageName() + POINT + R + JOIN + STYLEABLE).getDeclaredField(name).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getStyleableAttribute(Context context, String styleableName, String attributeName) {
        try {
            return (Integer)Class.forName(context.getPackageName() + POINT + R + JOIN + STYLEABLE).getDeclaredField(styleableName + "_" + attributeName).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int getLayoutIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, LAYOUT, name);
    }

    public static int getAnimIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, ANIM, name);
    }

    public static int getDrawableIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, DRAWABLE, name);
    }

    public static int getStringIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, STRING, name);
    }

    public static int getViewIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, ID, name);
    }

    public static int getColorIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, COLOR, name);
    }

    public static int getStyleIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, STYLE, name);
    }

    public static int getAttrIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, ATTR, name);
    }

    public static int[] getAttrsIdByName(Context context, String name) {
        return ResourceUtil.getIdsByName(context, ATTR, name);
    }

    public static int getDimenIdByName(Context context, String name) {
        return ResourceUtil.getIdByName(context, DIMEN, name);
    }

    private static int getIdByName(Context context, String className, String name) {
        String packageName = context.getPackageName();
        Class<?> r = null;
        int id = 0;
        try {
            r = Class.forName(packageName + ".R");
            Class<?>[] classes = r.getClasses();
            Class<?> desireClass = null;
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].getName().split("\\$")[1].equals(className)) continue;
                desireClass = classes[i];
                break;
            }
            if (desireClass != null) {
                id = desireClass.getField(name).getInt(desireClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return id;
    }

    private static int[] getIdsByName(Context context, String className, String name) {
        String packageName = context.getPackageName();
        Class<?> r = null;
        int[] id = new int[32];
        try {
            r = Class.forName(packageName + ".R");
            Class<?>[] classes = r.getClasses();
            Class<?> desireClass = null;
            for (int i = 0; i < classes.length; ++i) {
                if (!classes[i].getName().split("\\$")[1].equals(className)) continue;
                desireClass = classes[i];
                break;
            }
            if (desireClass != null) {
                Field field = desireClass.getDeclaredField(name);
                field.setAccessible(true);
                id = (int[])field.get(desireClass);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return id;
    }
}

