/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.file;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.liujc.baseutils.common.StringUtil;
import com.liujc.baseutils.convert.ConvertUtil;
import com.liujc.baseutils.file.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileUtil {
    private static final String[][] MIME_MAP_TABLE = new String[][]{{".3gp", "video/3gpp"}, {".apk", "application/vnd.android.package-archive"}, {".asf", "video/x-ms-asf"}, {".avi", "video/x-msvideo"}, {".bin", "application/octet-stream"}, {".bmp", "image/bmp"}, {".c", "text/plain"}, {".class", "application/octet-stream"}, {".conf", "text/plain"}, {".cpp", "text/plain"}, {".doc", "application/msword"}, {".exe", "application/octet-stream"}, {".gif", "image/gif"}, {".gtar", "application/x-gtar"}, {".gz", "application/x-gzip"}, {".h", "text/plain"}, {".htm", "text/html"}, {".html", "text/html"}, {".jar", "application/java-archive"}, {".java", "text/plain"}, {".jpeg", "image/jpeg"}, {".jpg", "image/jpeg"}, {".js", "application/x-javascript"}, {".log", "text/plain"}, {".m3u", "audio/x-mpegurl"}, {".m4a", "audio/mp4a-latm"}, {".m4b", "audio/mp4a-latm"}, {".m4p", "audio/mp4a-latm"}, {".m4u", "video/vnd.mpegurl"}, {".m4v", "video/x-m4v"}, {".mov", "video/quicktime"}, {".mp2", "audio/x-mpeg"}, {".mp3", "audio/x-mpeg"}, {".mp4", "video/mp4"}, {".mpc", "application/vnd.mpohun.certificate"}, {".mpe", "video/mpeg"}, {".mpeg", "video/mpeg"}, {".mpg", "video/mpeg"}, {".mpg4", "video/mp4"}, {".mpga", "audio/mpeg"}, {".msg", "application/vnd.ms-outlook"}, {".ogg", "audio/ogg"}, {".pdf", "application/pdf"}, {".png", "image/png"}, {".pps", "application/vnd.ms-powerpoint"}, {".ppt", "application/vnd.ms-powerpoint"}, {".prop", "text/plain"}, {".rar", "application/x-rar-compressed"}, {".rc", "text/plain"}, {".rmvb", "audio/x-pn-realaudio"}, {".rtf", "application/rtf"}, {".sh", "text/plain"}, {".tar", "application/x-tar"}, {".tgz", "application/x-compressed"}, {".txt", "text/plain"}, {".wav", "audio/x-wav"}, {".wma", "audio/x-ms-wma"}, {".wmv", "audio/x-ms-wmv"}, {".wps", "application/vnd.ms-works"}, {".xml", "text/plain"}, {".z", "application/x-compress"}, {".zip", "application/zip"}, {"", "*/*"}};

    private FileUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static File getFileByPath(String filePath) {
        return StringUtil.isSpace(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return FileUtil.isFileExists(FileUtil.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtil.rename(FileUtil.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (StringUtil.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean isDir(String dirPath) {
        return FileUtil.isDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return FileUtil.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtil.isFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return FileUtil.isFileExists(file) && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtil.createOrExistsDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtil.createOrExistsFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtil.createFileByDeleteOldFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isFile() && !file.delete()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean copyOrMoveDir(String srcDirPath, String destDirPath, boolean isMove) {
        return FileUtil.copyOrMoveDir(FileUtil.getFileByPath(srcDirPath), FileUtil.getFileByPath(destDirPath), isMove);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !FileUtil.copyOrMoveFile(file, oneDestFile, isMove) : file.isDirectory() && !FileUtil.copyOrMoveDir(file, oneDestFile, isMove))) continue;
            return false;
        }
        return !isMove || FileUtil.deleteDir(srcDir);
    }

    private static boolean copyOrMoveFile(String srcFilePath, String destFilePath, boolean isMove) {
        return FileUtil.copyOrMoveFile(FileUtil.getFileByPath(srcFilePath), FileUtil.getFileByPath(destFilePath), isMove);
    }

    private static boolean copyOrMoveFile(File srcFile, File destFile, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists() && destFile.isFile()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileUtil.writeFileFromIS(destFile, (InputStream)new FileInputStream(srcFile), false) && (!isMove || FileUtil.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath) {
        return FileUtil.copyDir(FileUtil.getFileByPath(srcDirPath), FileUtil.getFileByPath(destDirPath));
    }

    public static boolean copyDir(File srcDir, File destDir) {
        return FileUtil.copyOrMoveDir(srcDir, destDir, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath) {
        return FileUtil.copyFile(FileUtil.getFileByPath(srcFilePath), FileUtil.getFileByPath(destFilePath));
    }

    public static boolean copyFile(File srcFile, File destFile) {
        return FileUtil.copyOrMoveFile(srcFile, destFile, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath) {
        return FileUtil.moveDir(FileUtil.getFileByPath(srcDirPath), FileUtil.getFileByPath(destDirPath));
    }

    public static boolean moveDir(File srcDir, File destDir) {
        return FileUtil.copyOrMoveDir(srcDir, destDir, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath) {
        return FileUtil.moveFile(FileUtil.getFileByPath(srcFilePath), FileUtil.getFileByPath(destFilePath));
    }

    public static boolean moveFile(File srcFile, File destFile) {
        return FileUtil.copyOrMoveFile(srcFile, destFile, true);
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtil.deleteDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !FileUtil.deleteFile(file) : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtil.deleteFile(FileUtil.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static void delete(String dir, FilenameFilter filter) {
        if (TextUtils.isEmpty((CharSequence)dir)) {
            return;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] lists = null;
        lists = filter != null ? file.listFiles(filter) : file.listFiles();
        if (lists == null) {
            return;
        }
        for (File f : lists) {
            if (!f.isFile()) continue;
            f.delete();
        }
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return FileUtil.deleteFilesInDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !FileUtil.deleteFile(file) : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtil.listFilesInDir(FileUtil.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        if (isRecursive) {
            return FileUtil.listFilesInDir(dir);
        }
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        Collections.addAll(list, dir.listFiles());
        return list;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtil.listFilesInDir(FileUtil.getFileByPath(dirPath));
    }

    public static List<File> listFilesInDir(File dir) {
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                list.add(file);
                if (!file.isDirectory()) continue;
                list.addAll(FileUtil.listFilesInDir(file));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix, boolean isRecursive) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), suffix, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix, boolean isRecursive) {
        if (isRecursive) {
            return FileUtil.listFilesInDirWithFilter(dir, suffix);
        }
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!file.getName().toUpperCase().endsWith(suffix.toUpperCase())) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), suffix);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix) {
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtil.listFilesInDirWithFilter(file, suffix));
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter, boolean isRecursive) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter, boolean isRecursive) {
        if (isRecursive) {
            return FileUtil.listFilesInDirWithFilter(dir, filter);
        }
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!filter.accept(file.getParentFile(), file.getName())) continue;
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter) {
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (filter.accept(file.getParentFile(), file.getName())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtil.listFilesInDirWithFilter(file, filter));
            }
        }
        return list;
    }

    public static List<File> searchFileInDir(String dirPath, String fileName) {
        return FileUtil.searchFileInDir(FileUtil.getFileByPath(dirPath), fileName);
    }

    public static List<File> searchFileInDir(File dir, String fileName) {
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (file.getName().toUpperCase().equals(fileName.toUpperCase())) {
                    list.add(file);
                }
                if (!file.isDirectory()) continue;
                list.addAll(FileUtil.searchFileInDir(file, fileName));
            }
        }
        return list;
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return FileUtil.writeFileFromIS(FileUtil.getFileByPath(filePath), is, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        boolean bl;
        if (file == null || is == null) {
            return false;
        }
        if (!FileUtil.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[1024];
            while ((len = is.read(data, 0, 1024)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(is, os);
                throw throwable;
            }
            CloseUtil.closeIO(is, os);
            return bl2;
        }
        CloseUtil.closeIO(is, os);
        return bl;
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileUtil.writeFileFromString(FileUtil.getFileByPath(filePath), content, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        boolean bl;
        if (file == null || content == null) {
            return false;
        }
        if (!FileUtil.createOrExistsFile(file)) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, append));
            bw.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(bw);
                throw throwable;
            }
            CloseUtil.closeIO(bw);
            return bl2;
        }
        CloseUtil.closeIO(bw);
        return bl;
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return FileUtil.readFile2List(FileUtil.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return FileUtil.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return FileUtil.readFile2List(FileUtil.getFileByPath(filePath), st, end, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        ArrayList<String> arrayList;
        if (file == null) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = StringUtil.isSpace(charsetName) ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            List<String> list;
            try {
                e.printStackTrace();
                list = null;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(reader);
                throw throwable;
            }
            CloseUtil.closeIO(reader);
            return list;
        }
        CloseUtil.closeIO(reader);
        return arrayList;
    }

    public static String readFile2String(String filePath, String charsetName) {
        return FileUtil.readFile2String(FileUtil.getFileByPath(filePath), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile2String(File file, String charsetName) {
        String string;
        if (file == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            reader = StringUtil.isSpace(charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            string = sb.delete(sb.length() - 2, sb.length()).toString();
        }
        catch (IOException e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(reader);
                throw throwable;
            }
            CloseUtil.closeIO(reader);
            return string2;
        }
        CloseUtil.closeIO(reader);
        return string;
    }

    public static byte[] readFile2Bytes(String filePath) {
        return FileUtil.readFile2Bytes(FileUtil.getFileByPath(filePath));
    }

    public static byte[] readFile2Bytes(File file) {
        if (file == null) {
            return null;
        }
        try {
            return ConvertUtil.inputStream2Bytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtil.getFileCharsetSimple(FileUtil.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(is);
                throw throwable;
            }
            CloseUtil.closeIO(is);
        }
        CloseUtil.closeIO(is);
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return FileUtil.getFileLines(FileUtil.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        BufferedInputStream is = null;
        try {
            int readChars;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(is);
                throw throwable;
            }
            CloseUtil.closeIO(is);
        }
        CloseUtil.closeIO(is);
        return count;
    }

    public static String getFileSize(String filePath) {
        return FileUtil.getFileSize(FileUtil.getFileByPath(filePath));
    }

    public static String getFileSize(File file) {
        if (!FileUtil.isFileExists(file)) {
            return "";
        }
        return ConvertUtil.byte2FitSize(file.length());
    }

    public static String getFileMD5ToString(String filePath) {
        File file = StringUtil.isSpace(filePath) ? null : new File(filePath);
        return FileUtil.getFileMD5ToString(file);
    }

    public static byte[] getFileMD5(String filePath) {
        File file = StringUtil.isSpace(filePath) ? null : new File(filePath);
        return FileUtil.getFileMD5(file);
    }

    public static String getFileMD5ToString(File file) {
        return ConvertUtil.bytes2HexString(FileUtil.getFileMD5(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getFileMD5(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = dis.getMessageDigest();
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.closeIO(dis);
                throw throwable;
            }
            CloseUtil.closeIO(dis);
            return null;
        }
        CloseUtil.closeIO(dis);
        return byArray;
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (StringUtil.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (StringUtil.isSpace(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (StringUtil.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (StringUtil.isSpace(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi + 1);
    }

    public static void openFile(Context context, String filepath) {
        File file = new File(filepath);
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        String type = FileUtil.getMIMEType(file);
        intent.setDataAndType(Uri.fromFile((File)file), type);
        context.startActivity(intent);
    }

    public static String getMIMEType(File file) {
        String type = "*/*";
        String fName = file.getName();
        int dotIndex = fName.lastIndexOf(".");
        if (dotIndex < 0) {
            return type;
        }
        String end = fName.substring(dotIndex, fName.length()).toLowerCase();
        if (end == "") {
            return type;
        }
        for (int i = 0; i < MIME_MAP_TABLE.length; ++i) {
            if (!end.equals(MIME_MAP_TABLE[i][0])) continue;
            type = MIME_MAP_TABLE[i][1];
        }
        return type;
    }
}

