/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import android.content.Context;
import android.os.Build;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StringUtil {
    public static Pattern numericPattern = Pattern.compile("^[0-9\\-]+$");
    public static final String PHONE_FORMAT = "^((17[0-9])|(13[0-9])|(15[0-3,5-9])|(18[0-9])|(145)|(147))\\d{8}$";
    public static final String EMAIL_FORMAT = "^[0-9a-zA-Z][_.0-9a-zA-Z-]{0,43}@([0-9a-zA-Z][0-9a-zA-Z-]{0,30}[0-9a-zA-Z].){1,4}[a-zA-Z]{2,4}$";
    public static final String VERIFY_CODE_FORMAT = "^\\d{4}$";
    public static final String PASSWORD_LEGAL_CHARACTERS = "[a-zA-Z0-9]{6,20}";
    private static int[] pyValue = new int[]{-20319, -20317, -20304, -20295, -20292, -20283, -20265, -20257, -20242, -20230, -20051, -20036, -20032, -20026, -20002, -19990, -19986, -19982, -19976, -19805, -19784, -19775, -19774, -19763, -19756, -19751, -19746, -19741, -19739, -19728, -19725, -19715, -19540, -19531, -19525, -19515, -19500, -19484, -19479, -19467, -19289, -19288, -19281, -19275, -19270, -19263, -19261, -19249, -19243, -19242, -19238, -19235, -19227, -19224, -19218, -19212, -19038, -19023, -19018, -19006, -19003, -18996, -18977, -18961, -18952, -18783, -18774, -18773, -18763, -18756, -18741, -18735, -18731, -18722, -18710, -18697, -18696, -18526, -18518, -18501, -18490, -18478, -18463, -18448, -18447, -18446, -18239, -18237, -18231, -18220, -18211, -18201, -18184, -18183, -18181, -18012, -17997, -17988, -17970, -17964, -17961, -17950, -17947, -17931, -17928, -17922, -17759, -17752, -17733, -17730, -17721, -17703, -17701, -17697, -17692, -17683, -17676, -17496, -17487, -17482, -17468, -17454, -17433, -17427, -17417, -17202, -17185, -16983, -16970, -16942, -16915, -16733, -16708, -16706, -16689, -16664, -16657, -16647, -16474, -16470, -16465, -16459, -16452, -16448, -16433, -16429, -16427, -16423, -16419, -16412, -16407, -16403, -16401, -16393, -16220, -16216, -16212, -16205, -16202, -16187, -16180, -16171, -16169, -16158, -16155, -15959, -15958, -15944, -15933, -15920, -15915, -15903, -15889, -15878, -15707, -15701, -15681, -15667, -15661, -15659, -15652, -15640, -15631, -15625, -15454, -15448, -15436, -15435, -15419, -15416, -15408, -15394, -15385, -15377, -15375, -15369, -15363, -15362, -15183, -15180, -15165, -15158, -15153, -15150, -15149, -15144, -15143, -15141, -15140, -15139, -15128, -15121, -15119, -15117, -15110, -15109, -14941, -14937, -14933, -14930, -14929, -14928, -14926, -14922, -14921, -14914, -14908, -14902, -14894, -14889, -14882, -14873, -14871, -14857, -14678, -14674, -14670, -14668, -14663, -14654, -14645, -14630, -14594, -14429, -14407, -14399, -14384, -14379, -14368, -14355, -14353, -14345, -14170, -14159, -14151, -14149, -14145, -14140, -14137, -14135, -14125, -14123, -14122, -14112, -14109, -14099, -14097, -14094, -14092, -14090, -14087, -14083, -13917, -13914, -13910, -13907, -13906, -13905, -13896, -13894, -13878, -13870, -13859, -13847, -13831, -13658, -13611, -13601, -13406, -13404, -13400, -13398, -13395, -13391, -13387, -13383, -13367, -13359, -13356, -13343, -13340, -13329, -13326, -13318, -13147, -13138, -13120, -13107, -13096, -13095, -13091, -13076, -13068, -13063, -13060, -12888, -12875, -12871, -12860, -12858, -12852, -12849, -12838, -12831, -12829, -12812, -12802, -12607, -12597, -12594, -12585, -12556, -12359, -12346, -12320, -12300, -12120, -12099, -12089, -12074, -12067, -12058, -12039, -11867, -11861, -11847, -11831, -11798, -11781, -11604, -11589, -11536, -11358, -11340, -11339, -11324, -11303, -11097, -11077, -11067, -11055, -11052, -11045, -11041, -11038, -11024, -11020, -11019, -11018, -11014, -10838, -10832, -10815, -10800, -10790, -10780, -10764, -10587, -10544, -10533, -10519, -10331, -10329, -10328, -10322, -10315, -10309, -10307, -10296, -10281, -10274, -10270, -10262, -10260, -10256, -10254};
    private static String[] pyStr = new String[]{"a", "ai", "an", "ang", "ao", "ba", "bai", "ban", "bang", "bao", "bei", "ben", "beng", "bi", "bian", "biao", "bie", "bin", "bing", "bo", "bu", "ca", "cai", "can", "cang", "cao", "ce", "ceng", "cha", "chai", "chan", "chang", "chao", "che", "chen", "cheng", "chi", "chong", "chou", "chu", "chuai", "chuan", "chuang", "chui", "chun", "chuo", "ci", "cong", "cou", "cu", "cuan", "cui", "cun", "cuo", "da", "dai", "dan", "dang", "dao", "de", "deng", "di", "dian", "diao", "die", "ding", "diu", "dong", "dou", "du", "duan", "dui", "dun", "duo", "e", "en", "er", "fa", "fan", "fang", "fei", "fen", "feng", "fo", "fou", "fu", "ga", "gai", "gan", "gang", "gao", "ge", "gei", "gen", "geng", "gong", "gou", "gu", "gua", "guai", "guan", "guang", "gui", "gun", "guo", "ha", "hai", "han", "hang", "hao", "he", "hei", "hen", "heng", "hong", "hou", "hu", "hua", "huai", "huan", "huang", "hui", "hun", "huo", "ji", "jia", "jian", "jiang", "jiao", "jie", "jin", "jing", "jiong", "jiu", "ju", "juan", "jue", "jun", "ka", "kai", "kan", "kang", "kao", "ke", "ken", "keng", "kong", "kou", "ku", "kua", "kuai", "kuan", "kuang", "kui", "kun", "kuo", "la", "lai", "lan", "lang", "lao", "le", "lei", "leng", "li", "lia", "lian", "liang", "liao", "lie", "lin", "ling", "liu", "long", "lou", "lu", "lv", "luan", "lue", "lun", "luo", "ma", "mai", "man", "mang", "mao", "me", "mei", "men", "meng", "mi", "mian", "miao", "mie", "min", "ming", "miu", "mo", "mou", "mu", "na", "nai", "nan", "nang", "nao", "ne", "nei", "nen", "neng", "ni", "nian", "niang", "niao", "nie", "nin", "ning", "niu", "nong", "nu", "nv", "nuan", "nue", "nuo", "o", "ou", "pa", "pai", "pan", "pang", "pao", "pei", "pen", "peng", "pi", "pian", "piao", "pie", "pin", "ping", "po", "pu", "qi", "qia", "qian", "qiang", "qiao", "qie", "qin", "qing", "qiong", "qiu", "qu", "quan", "que", "qun", "ran", "rang", "rao", "re", "ren", "reng", "ri", "rong", "rou", "ru", "ruan", "rui", "run", "ruo", "sa", "sai", "san", "sang", "sao", "se", "sen", "seng", "sha", "shai", "shan", "shang", "shao", "she", "shen", "sheng", "shi", "shou", "shu", "shua", "shuai", "shuan", "shuang", "shui", "shun", "shuo", "si", "song", "sou", "su", "suan", "sui", "sun", "suo", "ta", "tai", "tan", "tang", "tao", "te", "teng", "ti", "tian", "tiao", "tie", "ting", "tong", "tou", "tu", "tuan", "tui", "tun", "tuo", "wa", "wai", "wan", "wang", "wei", "wen", "weng", "wo", "wu", "xi", "xia", "xian", "xiang", "xiao", "xie", "xin", "xing", "xiong", "xiu", "xu", "xuan", "xue", "xun", "ya", "yan", "yang", "yao", "ye", "yi", "yin", "ying", "yo", "yong", "you", "yu", "yuan", "yue", "yun", "za", "zai", "zan", "zang", "zao", "ze", "zei", "zen", "zeng", "zha", "zhai", "zhan", "zhang", "zhao", "zhe", "zhen", "zheng", "zhi", "zhong", "zhou", "zhu", "zhua", "zhuai", "zhuan", "zhuang", "zhui", "zhun", "zhuo", "zi", "zong", "zou", "zu", "zuan", "zui", "zun", "zuo"};

    private StringUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isNullString(String str) {
        return null == str || StringUtil.isBlank(str.trim()) || "null".equals(str.trim().toLowerCase());
    }

    public static boolean isSpace(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(String strSource) {
        return strSource == null || "".equals(strSource.trim());
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String trim(String str) {
        return str == null ? str : str.trim();
    }

    public static boolean isNum(String strNum) {
        return strNum.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public static boolean isPhoneNum(String strPhoneNum) {
        return Pattern.matches(PHONE_FORMAT, strPhoneNum);
    }

    public static boolean isEmail(String email) {
        String str = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isIp(String IP) {
        String[] s;
        boolean b = false;
        if ((IP = StringUtil.trimSpaces(IP)).matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && Integer.parseInt((s = IP.split("\\."))[0]) < 255 && Integer.parseInt(s[1]) < 255 && Integer.parseInt(s[2]) < 255 && Integer.parseInt(s[3]) < 255) {
            b = true;
        }
        return b;
    }

    public static ArrayList<String> checkPhone(String content) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isEmpty(content)) {
            return list;
        }
        Pattern p = Pattern.compile("1([\\d]{10})|((\\+[0-9]{2,4})?\\(?[0-9]+\\)?-?)?[0-9]{7,8}");
        Matcher m = p.matcher(content);
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public static boolean checkFace(String checkString) {
        String reg = "^([a-z]|[A-Z]|[0-9]|[\u0000-\u00ff]|[\u2000-\uffff]){1,}$";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(checkString.replaceAll(" ", ""));
        return matcher.matches();
    }

    public static String formatString(String str) {
        if (StringUtil.isNullString(str)) {
            return "";
        }
        return str;
    }

    public static String getFileName(String path) {
        if (StringUtil.isNullString(path)) {
            return null;
        }
        int bingindex = path.lastIndexOf("/");
        int endindex = path.lastIndexOf(".");
        return path.substring(bingindex + 1, endindex);
    }

    public static boolean isNumeric(String src) {
        Matcher m;
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = numericPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static String getIPTimeRandName(String ip, String fileName) {
        StringBuffer buf = new StringBuffer();
        if (ip != null) {
            String[] str = ip.split("\\.");
            for (int i = 0; i < str.length; ++i) {
                buf.append(StringUtil.addZero(str[i], 3));
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        buf.append(sdf.format(new Date()));
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            buf.append(random.nextInt(10));
        }
        buf.append("." + StringUtil.getFileExt(fileName));
        return buf.toString();
    }

    public static String getTmeRandName(String fileName) {
        return StringUtil.getIPTimeRandName(null, fileName);
    }

    public static String addZero(String str, int len) {
        StringBuffer s = new StringBuffer();
        s.append(str);
        while (s.length() < len) {
            s.insert(0, "0");
        }
        return s.toString();
    }

    public static String getFileExt(String filename) {
        int i = filename.lastIndexOf(".");
        String extension = filename.substring(i + 1);
        return extension;
    }

    public static final String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String join(ArrayList<String> array, String separator) {
        StringBuffer result = new StringBuffer();
        if (array != null && array.size() > 0) {
            for (String str : array) {
                result.append(str);
                result.append(separator);
            }
            result.delete(result.length() - 1, result.length());
        }
        return result.toString();
    }

    public static String compress(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toString("ISO-8859-1");
    }

    public static String uncompress(String str) throws IOException {
        int n;
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
        GZIPInputStream gunzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = gunzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toString("UTF-8");
    }

    public static String stringFilter(String input) {
        if (input == null) {
            return null;
        }
        input = input.replaceAll("\u3010", "[").replaceAll("\u3011", "]").replaceAll("\uff01", "!").replaceAll("\uff1a", ":");
        String regEx = "[\u300e\u300f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(input);
        return m.replaceAll("").trim();
    }

    public static String getAfterPrefix(String name) throws Exception {
        return name.substring(name.lastIndexOf(".") + 1, name.length());
    }

    public static String[] splitMoreSelect(String values, String limit) {
        if (StringUtil.isNullOrEmpty(values)) {
            return null;
        }
        return values.trim().split(limit);
    }

    public static String arr2Str(String[] needvalue) {
        String str = "";
        if (needvalue != null) {
            int len = needvalue.length;
            for (int i = 0; i < len; ++i) {
                str = i == len - 1 ? str + needvalue[i] : str + needvalue[i] + ",";
            }
            return str;
        }
        return null;
    }

    public static String getValueById(Context context, int id) {
        return context.getResources().getString(id);
    }

    public static String replaceStr(String oldstr) {
        oldstr = oldstr.replaceAll("\n", "<br>");
        oldstr = oldstr.replaceAll("\r\n", "<br>");
        oldstr = oldstr.replaceAll(" ", "&nbsp; ");
        return oldstr;
    }

    public static boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }

    public static int getThemeNum(String content) {
        int tnum = -1;
        if (StringUtil.isNullOrEmpty(content)) {
            return tnum;
        }
        int a = content.indexOf(".");
        if (a > 0) {
            String num = content.substring(0, a);
            try {
                tnum = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return tnum;
            }
        }
        return tnum;
    }

    public static String dealDigitalFlags(String str) {
        String result = "";
        if (str == null || str.length() < 0) {
            return null;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            String tmp = str.substring(i, i + 1);
            if (tmp.equals("+") || tmp.equals("*") || tmp.equals("=")) {
                tmp = " " + tmp + " ";
            }
            result = result + tmp;
        }
        return result;
    }

    public static String detailNum(String oldnum) {
        if (StringUtil.isNullOrEmpty(oldnum)) {
            return oldnum;
        }
        int newnum = Integer.parseInt(oldnum);
        return newnum + ".";
    }

    public static String[] getStoreArr(String[] arr) throws Exception {
        for (int i = 0; i < arr.length; ++i) {
            for (int j = arr.length - 1; j > i; --j) {
                int b;
                int a = Integer.parseInt(arr[i]);
                if (a <= (b = Integer.parseInt(arr[j]))) continue;
                String temp = arr[i];
                arr[i] = arr[j];
                arr[j] = temp;
            }
        }
        return arr;
    }

    public static String resetStoreNum(String str) {
        String value = "";
        try {
            if (str == null || str.length() < 1) {
                return value;
            }
            String[] results = str.split(",");
            String[] newarr = StringUtil.getStoreArr(results);
            for (int i = 0; i < newarr.length; ++i) {
                value = value + newarr[i] + ",";
            }
            value = value.substring(0, value.length() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static boolean arrIsValue(String srcValue, String[] values) {
        if (values == null) {
            return false;
        }
        for (String value : values) {
            if (!value.equals(srcValue)) continue;
            return true;
        }
        return false;
    }

    public static String DeleteOriNumber(String content) {
        if (content.trim().length() > 1) {
            int index = content.indexOf(".");
            String AfterStr = content.substring(index + 1, content.length());
            return AfterStr;
        }
        return content;
    }

    public static String convertToGBK(String content) {
        if (!StringUtil.isEmpty(content)) {
            try {
                content = new String(content.getBytes(), "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private static String trimSpaces(String IP) {
        while (IP.startsWith(" ")) {
            IP = IP.substring(1, IP.length()).trim();
        }
        while (IP.endsWith(" ")) {
            IP = IP.substring(0, IP.length() - 1).trim();
        }
        return IP;
    }

    public static String distanceSize(double distance) {
        if (distance < 1.0) {
            return (int)(distance * 1000.0) + "m";
        }
        String dd = "0";
        try {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            dd = fnum.format(distance);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dd + "km";
    }

    public static String replaceResult(String content) {
        if (!StringUtil.isEmpty(content)) {
            content = content.replace("\\", "").replace("\"{", "{").replace("}\"", "}");
            return content;
        }
        return content;
    }

    public static String parseStr(String value) {
        if (StringUtil.isNullString(value)) {
            return "0.0";
        }
        DecimalFormat df = new DecimalFormat("######0.0");
        double mvalue = Double.parseDouble(value);
        return df.format(mvalue);
    }

    public static String parseStr(double value) {
        if (value == 0.0) {
            return "0.0";
        }
        DecimalFormat df = new DecimalFormat("######0.0");
        return df.format(Double.parseDouble(String.valueOf(value)));
    }

    public static String toWrap(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String byteToMac(byte[] resBytes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < resBytes.length; ++i) {
            String hex = Integer.toHexString(resBytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            buffer.append(hex.toUpperCase());
        }
        return buffer.toString();
    }

    public static String toHexString(byte[] b) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String s = Integer.toHexString(b[i] & 0xFF);
            if (s.length() == 1) {
                s = "0" + s;
            }
            buffer.append(s + " ");
        }
        return buffer.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        Formatter fmt = new Formatter(new StringBuilder(bytes.length * 2));
        for (byte b : bytes) {
            fmt.format("%02x", b);
        }
        return fmt.toString();
    }

    public static int toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        return StringUtil.toInt(obj.toString(), 0);
    }

    public static int toInt(String str, int defValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static boolean isLetter(char c) {
        int k = 255;
        return c / k == 0;
    }

    public static int getCharLength(char c) {
        if (StringUtil.isLetter(c)) {
            return 1;
        }
        return 2;
    }

    public static int getStringLength(String strSource) {
        char[] arrChars;
        int iSrcLen = 0;
        for (char arrChar : arrChars = strSource.toCharArray()) {
            iSrcLen += StringUtil.getCharLength(arrChar);
        }
        return iSrcLen;
    }

    public static String sub(String strSource, int iSubLen, String strSuffix) {
        if (StringUtil.isNull(strSource)) {
            return strSource;
        }
        String strFilter = strSource.trim();
        int iLength = StringUtil.getStringLength(strFilter);
        if (iLength <= iSubLen) {
            return strFilter;
        }
        int iNum = iSubLen;
        int iSubIndex = 0;
        char[] arrChars = strFilter.toCharArray();
        int iArrLength = arrChars.length;
        char c = arrChars[iSubIndex];
        StringBuffer sbContent = new StringBuffer();
        iNum -= StringUtil.getCharLength(c);
        while (iNum > -1 && iSubIndex < iArrLength) {
            sbContent.append(c);
            if (++iSubIndex >= iArrLength) continue;
            c = arrChars[iSubIndex];
            iNum -= StringUtil.getCharLength(c);
        }
        strFilter = sbContent.toString();
        if (!StringUtil.isNull(strSuffix)) {
            strFilter = strFilter + strSuffix;
        }
        return strFilter;
    }

    public static String subWithDots(String strSource, int iSubLen) {
        return StringUtil.sub(strSource, iSubLen, "...");
    }

    public static String object2Str(Object obj) {
        String result = null;
        if (obj != null) {
            result = (String)obj;
        }
        return result;
    }

    public static byte[] getBytes(String src, Charset charSet) {
        if (Build.VERSION.SDK_INT < 9) {
            try {
                return src.getBytes(charSet.name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        return src.getBytes(charSet);
    }

    public static String durationShow(int duration, boolean isShowZero) {
        String showStr = "";
        showStr = isShowZero ? (duration < 10 ? "0" + String.valueOf(duration) : String.valueOf(duration)) : String.valueOf(duration);
        return showStr;
    }

    public static long fromTimeString(String s) {
        String[] split;
        if (s.lastIndexOf(".") != -1) {
            s = s.substring(0, s.lastIndexOf("."));
        }
        if ((split = s.split(":")).length == 3) {
            return Long.parseLong(split[0]) * 3600L + Long.parseLong(split[1]) * 60L + Long.parseLong(split[2]);
        }
        if (split.length == 2) {
            return Long.parseLong(split[0]) * 60L + Long.parseLong(split[0]);
        }
        throw new IllegalArgumentException("Can't parse time string: " + s);
    }

    public static String toTimeString(long seconds) {
        long hours = (seconds /= 1000L) / 3600L;
        long remainder = seconds % 3600L;
        long minutes = remainder / 60L;
        long secs = remainder % 60L;
        if (hours == 0L) {
            return (minutes < 10L ? "0" : "") + minutes + ":" + (secs < 10L ? "0" : "") + secs;
        }
        return (hours < 10L ? "0" : "") + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (secs < 10L ? "0" : "") + secs;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String null2Length0(String s) {
        return s == null ? "" : s;
    }

    public static int length(CharSequence s) {
        return s == null ? 0 : s.length();
    }

    public static String upperFirstLetter(String s) {
        if (StringUtil.isEmpty(s) || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) - 32)) + s.substring(1);
    }

    public static String lowerFirstLetter(String s) {
        if (StringUtil.isEmpty(s) || !Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) + 32)) + s.substring(1);
    }

    public static String reverse(String s) {
        int len = StringUtil.length(s);
        if (len <= 1) {
            return s;
        }
        int mid = len >> 1;
        char[] chars = s.toCharArray();
        for (int i = 0; i < mid; ++i) {
            char c = chars[i];
            chars[i] = chars[len - i - 1];
            chars[len - i - 1] = c;
        }
        return new String(chars);
    }

    public static String toDBC(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == '\u3000' ? 32 : ('\uff01' <= chars[i] && chars[i] <= '\uff5e' ? (char)(chars[i] - 65248) : chars[i]);
        }
        return new String(chars);
    }

    public static String toSBC(String s) {
        if (StringUtil.isEmpty(s)) {
            return s;
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            chars[i] = chars[i] == ' ' ? 12288 : ('!' <= chars[i] && chars[i] <= '~' ? (char)(chars[i] + 65248) : chars[i]);
        }
        return new String(chars);
    }

    private static int oneCn2ASCII(String s) {
        int ascii;
        block5: {
            if (s.length() != 1) {
                return -1;
            }
            ascii = 0;
            try {
                byte[] bytes = s.getBytes("GB2312");
                if (bytes.length == 1) {
                    ascii = bytes[0];
                    break block5;
                }
                if (bytes.length == 2) {
                    int highByte = 256 + bytes[0];
                    int lowByte = 256 + bytes[1];
                    ascii = 256 * highByte + lowByte - 65536;
                    break block5;
                }
                throw new IllegalArgumentException("Illegal resource string");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return ascii;
    }

    private static String oneCn2PY(String s) {
        int ascii = StringUtil.oneCn2ASCII(s);
        if (ascii == -1) {
            return null;
        }
        String ret = null;
        if (0 <= ascii && ascii <= 127) {
            ret = String.valueOf((char)ascii);
        } else {
            for (int i = pyValue.length - 1; i >= 0; --i) {
                if (pyValue[i] > ascii) continue;
                ret = pyStr[i];
                break;
            }
        }
        return ret;
    }

    public static String getPYFirstLetter(String s) {
        if (StringUtil.isSpace(s)) {
            return "";
        }
        String first = s.substring(0, 1);
        String py = StringUtil.oneCn2PY(first);
        if (py == null) {
            return null;
        }
        return py.substring(0, 1);
    }

    public static String cn2PY(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String hz = s.substring(i, i + 1);
            String py = StringUtil.oneCn2PY(hz);
            if (py == null) {
                py = "?";
            }
            sb.append(py);
        }
        return sb.toString();
    }

    public static double getLength(String s) {
        double valueLength = 0.0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < s.length(); ++i) {
            String temp = s.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 1.0;
                continue;
            }
            valueLength += 0.5;
        }
        return Math.ceil(valueLength);
    }

    public static int getWordCount(String s) {
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }

    public static int getWordCounts(String s) {
        s = s.replaceAll("[^\\x00-\\xff]", "*");
        int length = s.length();
        return length;
    }

    public static String getFormatString(String str) {
        return StringUtil.getFormatString(str, 2).replace("...", "");
    }

    public static String getFormatString(String str, int n) {
        String temp = "";
        if (StringUtil.getWordCount(str) <= n) {
            return str;
        }
        int t = 0;
        int i = 0;
        char[] q = str.toCharArray();
        for (i = 0; i < q.length && t < n; ++i) {
            t = q[i] >= '\u4e00' && q[i] <= '\u9fa5' ? (t += 2) : ++t;
            if (t > n) continue;
            temp = temp + q[i];
        }
        if (t == StringUtil.getWordCount(str)) {
            return temp;
        }
        return temp + "...";
    }
}

