/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.location.LocationManager;
import android.media.AudioRecord;
import android.support.v4.content.ContextCompat;
import java.util.ArrayList;
import java.util.List;

public class PermissionsUtils {
    private static int mRequestCode = -1;
    private static OnPermissionListener mOnPermissionListener;

    @TargetApi(value=23)
    public static void requestPermissions(Context context, int requestCode, String[] permissions, OnPermissionListener listener) {
        if (context instanceof Activity) {
            mOnPermissionListener = listener;
            List<String> deniedPermissions = PermissionsUtils.getDeniedPermissions(context, permissions);
            if (deniedPermissions.size() > 0) {
                mRequestCode = requestCode;
                ((Activity)context).requestPermissions(deniedPermissions.toArray(new String[deniedPermissions.size()]), requestCode);
            } else if (mOnPermissionListener != null) {
                mOnPermissionListener.onPermissionGranted();
            }
        } else {
            throw new RuntimeException("Context must be an Activity");
        }
    }

    private static List<String> getDeniedPermissions(Context context, String ... permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) != -1) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions;
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (mRequestCode != -1 && requestCode == mRequestCode && mOnPermissionListener != null) {
            if (PermissionsUtils.verifyPermissions(grantResults)) {
                mOnPermissionListener.onPermissionGranted();
            } else {
                mOnPermissionListener.onPermissionDenied();
            }
        }
    }

    private static boolean verifyPermissions(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAudioEnable() {
        boolean isValid = true;
        int bufferSize = AudioRecord.getMinBufferSize((int)8000, (int)16, (int)2);
        short[] mBuffer = new short[bufferSize];
        AudioRecord mRecorder = new AudioRecord(1, 8000, 16, 2, bufferSize);
        try {
            mRecorder.startRecording();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            boolean bl = isValid = false;
            return bl;
        }
        int readSize = mRecorder.read(mBuffer, 0, mBuffer.length);
        if (-3 == readSize) {
            isValid = false;
        }
        try {
            if (mRecorder != null) {
                mRecorder.stop();
                mRecorder.release();
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        return isValid;
    }

    public static boolean isCameraEnable() {
        boolean isCanUse = true;
        Camera mCamera = null;
        try {
            mCamera = Camera.open();
            Camera.Parameters mParameters = mCamera.getParameters();
            mCamera.setParameters(mParameters);
        }
        catch (Exception e) {
            isCanUse = false;
        }
        if (mCamera != null) {
            try {
                mCamera.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                return isCanUse;
            }
        }
        return isCanUse;
    }

    public static boolean isLocServiceEnable(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        boolean gps = locationManager.isProviderEnabled("gps");
        boolean network = locationManager.isProviderEnabled("network");
        return gps || network;
    }

    public static interface OnPermissionListener {
        public void onPermissionGranted();

        public void onPermissionDenied();
    }
}

