/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;

public class FieldUtil {
    public static boolean isSerializable(Field f) {
        Class<?>[] cls;
        for (Class<?> c : cls = f.getType().getInterfaces()) {
            if (Serializable.class != c) continue;
            return true;
        }
        return false;
    }

    public static Object set(Field f, Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        f.set(obj, value);
        return f.get(obj);
    }

    public static Object get(Field f, Object obj) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        return f.get(obj);
    }

    public static boolean isLong(Field field) {
        return field.getType() == Long.TYPE || field.getType() == Long.class;
    }

    public static boolean isInteger(Field field) {
        return field.getType() == Integer.TYPE || field.getType() != Integer.class;
    }

    public static Class<?> getGenericType(Field f) {
        Type type = f.getGenericType();
        if (type instanceof ParameterizedType ? (type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class : type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static Class<?> getComponentType(Field f) {
        return f.getType().getComponentType();
    }

    public static List<Field> getAllDeclaredFields(Class<?> claxx) {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        while (claxx != null && claxx != Object.class) {
            Field[] fs = claxx.getDeclaredFields();
            for (int i = 0; i < fs.length; ++i) {
                Field f = fs[i];
                if (FieldUtil.isInvalid(f)) continue;
                fieldList.addLast(f);
            }
            claxx = claxx.getSuperclass();
        }
        return fieldList;
    }

    public static boolean isInvalid(Field f) {
        return Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) || f.isSynthetic();
    }
}

