/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtil {
    public static final String FORMAT_HH_MM_SS = "HH:mm:ss";
    public static final String FORMAT_HH_MM = "HH:mm";
    public static final String FORMAT_A_HH_MM = "aHH:mm";
    public static final String FORMAT_HMofChinese = "HH\u65f6mm\u5206";
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String FORMAT_YMDE = "yyyy/MM/dd E";
    public static final String FORMAT_YMD2 = "yyyy/MM/dd";
    public static final String FORMAT_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_YYYYMMDD_HH_MM_SS_SSS = "yyyyMMdd HH:mm:ss.SSS";
    public static final String FORMAT_YYYYMMDD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_MDHMofChinese = "MM\u6708dd\u65e5HH\u65f6mm\u5206";
    public static final String FORMAT_YMDHMofChinese = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static final String FORMAT_YMDofChinese = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String FORMAT_MDofChinese = "MM\u6708dd\u65e5";
    public static final String FORMAT_MofChinese = "MM\u6708";
    public static final String FORMAT_YM = "yyyy-MM";
    public static final String FORMAT_MD = "MM/dd";
    public static final String FORMAT_M_D = "MM-dd";
    public static final String FORMAT_M = "MM\u6708";
    public static final String FORMAT_D = "dd";
    public static final String FORMAT_M2 = "MM";
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    public static final long ONE_HOUR_MILLISECONDS = 3600000L;
    public static final long ONE_MIN_MILLISECONDS = 60000L;
    private static final ThreadLocal<SimpleDateFormat> dateFormater = new ThreadLocal<SimpleDateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.FORMAT_YYYYMMDD_HH_MM_SS);
        }
    };
    @SuppressLint(value={"SimpleDateFormat"})
    private static final ThreadLocal<SimpleDateFormat> dateFormater2 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateUtil.FORMAT_YYYY_MM_DD);
        }
    };
    public static final int WEEKDAYS = 7;
    public static String[] WEEK = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};

    public static String formatDate(long timeStamp, String dateFormat) {
        if (timeStamp == 0L) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        return format.format(new Date(timeStamp *= 1000L));
    }

    public static Date getDateByFormat(String strDate, String format) {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = mSimpleDateFormat.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getStringByFormat(Date date, String format) {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
        String strDate = null;
        try {
            strDate = mSimpleDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getStringByFormat(long milliseconds, String format) {
        String thisDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            thisDateTime = mSimpleDateFormat.format(milliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thisDateTime;
    }

    public static String getStringByFormat(String strDate, String beforFormat, String afterFormat) {
        String mDateTime = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(beforFormat);
            c.setTime(mSimpleDateFormat.parse(strDate));
            SimpleDateFormat mSimpleDateFormat2 = new SimpleDateFormat(afterFormat);
            mDateTime = mSimpleDateFormat2.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getCurrentDate(String format) {
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getNextDay(int offset) {
        return DateUtil.getNextDay(offset, null);
    }

    public static String getNextDay(int offset, String format) {
        if (TextUtils.isEmpty((CharSequence)format)) {
            format = FORMAT_YYYY_MM_DD_HH_MM;
        }
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(5, offset);
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getNextHour(int offset) {
        return DateUtil.getNextHour(offset, null);
    }

    public static String getNextHour(int offset, String format) {
        if (TextUtils.isEmpty((CharSequence)format)) {
            format = FORMAT_YYYY_MM_DD_HH_MM;
        }
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(11, offset);
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public Date getDateByOffset(Date date, int calendarField, int offset) {
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTime(date);
            ((Calendar)c).add(calendarField, offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c.getTime();
    }

    public static String getStringByOffset(String strDate, String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(mSimpleDateFormat.parse(strDate));
            ((Calendar)c).add(calendarField, offset);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getStringByOffset(Date date, String format, int calendarField, int offset) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(date);
            ((Calendar)c).add(calendarField, offset);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getCurrentDateByOffset(String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(calendarField, offset);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static int getOffectDay(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int y1 = calendar1.get(1);
        int y2 = calendar2.get(1);
        int d1 = calendar1.get(6);
        int d2 = calendar2.get(6);
        int maxDays = 0;
        int day = 0;
        if (y1 - y2 > 0) {
            maxDays = calendar2.getActualMaximum(6);
            day = d1 - d2 + maxDays;
        } else if (y1 - y2 < 0) {
            maxDays = calendar1.getActualMaximum(6);
            day = d1 - d2 - maxDays;
        } else {
            day = d1 - d2;
        }
        return day;
    }

    public static int getOffectHour(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int h1 = calendar1.get(11);
        int h2 = calendar2.get(11);
        int h = 0;
        int day = DateUtil.getOffectDay(date1, date2);
        h = h1 - h2 + day * 24;
        return h;
    }

    public static int getOffectMinutes(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int m1 = calendar1.get(12);
        int m2 = calendar2.get(12);
        int h = DateUtil.getOffectHour(date1, date2);
        int m = 0;
        m = m1 - m2 + h * 60;
        return m;
    }

    public static String getFirstDayOfWeek(String format) {
        return DateUtil.getDayOfWeek(format, 2);
    }

    public static String getLastDayOfWeek(String format) {
        return DateUtil.getDayOfWeek(format, 1);
    }

    private static String getDayOfWeek(String format, int calendarField) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            int week = c.get(7);
            if (week == calendarField) {
                strDate = mSimpleDateFormat.format(c.getTime());
            } else {
                int offectDay = calendarField - week;
                if (calendarField == 1) {
                    offectDay = 7 - Math.abs(offectDay);
                }
                ((Calendar)c).add(5, offectDay);
                strDate = mSimpleDateFormat.format(c.getTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getFirstDayOfMonth(String format) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.set(5, 1);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getLastDayOfMonth(String format) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.set(5, 1);
            ((Calendar)c).roll(5, -1);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static long getFirstTimeOfDay() {
        Date date = null;
        try {
            String currentDate = DateUtil.getCurrentDate(FORMAT_YYYY_MM_DD);
            date = DateUtil.getDateByFormat(currentDate + " 00:00:00", FORMAT_YYYYMMDD_HH_MM_SS);
            return date.getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getLastTimeOfDay() {
        Date date = null;
        try {
            String currentDate = DateUtil.getCurrentDate(FORMAT_YYYY_MM_DD);
            date = DateUtil.getDateByFormat(currentDate + " 24:00:00", FORMAT_YYYYMMDD_HH_MM_SS);
            return date.getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 400 != 0 || year % 400 == 0;
    }

    public static String formatDateStr2Desc(String strDate, String inFormat, String outFormat) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM);
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            String out;
            c2.setTime(df.parse(strDate));
            c1.setTime(new Date());
            int d = DateUtil.getOffectDay(c1.getTimeInMillis(), c2.getTimeInMillis());
            if (d == 0) {
                int h = DateUtil.getOffectHour(c1.getTimeInMillis(), c2.getTimeInMillis());
                if (h > 0) {
                    return h + "\u5c0f\u65f6\u524d";
                }
                if (h < 0) {
                    return Math.abs(h) + "\u5c0f\u65f6\u540e";
                }
                if (h == 0) {
                    int m = DateUtil.getOffectMinutes(c1.getTimeInMillis(), c2.getTimeInMillis());
                    if (m > 0) {
                        return m + "\u5206\u949f\u524d";
                    }
                    if (m < 0) {
                        return Math.abs(m) + "\u5206\u949f\u540e";
                    }
                    return "\u521a\u521a";
                }
            } else if (d > 0) {
                if (d == 1) {
                    return "\u6628\u5929";
                }
                if (d == 2) {
                    return "\u524d\u5929";
                }
            } else if (d < 0) {
                if (d == -1) {
                    return "\u660e\u5929";
                }
                if (d == -2) {
                    return "\u540e\u5929";
                }
                return Math.abs(d) + "\u5929\u540e";
            }
            if (!TextUtils.isEmpty((CharSequence)(out = DateUtil.getStringByFormat(strDate, inFormat, outFormat)))) {
                return out;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strDate;
    }

    public static String getWeekNumber(String strDate, String inFormat) {
        String week = "\u661f\u671f\u65e5";
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat(inFormat);
        try {
            calendar.setTime(df.parse(strDate));
        }
        catch (Exception e) {
            return "\u9519\u8bef";
        }
        int intTemp = calendar.get(7) - 1;
        switch (intTemp) {
            case 0: {
                week = "\u661f\u671f\u65e5";
                break;
            }
            case 1: {
                week = "\u661f\u671f\u4e00";
                break;
            }
            case 2: {
                week = "\u661f\u671f\u4e8c";
                break;
            }
            case 3: {
                week = "\u661f\u671f\u4e09";
                break;
            }
            case 4: {
                week = "\u661f\u671f\u56db";
                break;
            }
            case 5: {
                week = "\u661f\u671f\u4e94";
                break;
            }
            case 6: {
                week = "\u661f\u671f\u516d";
            }
        }
        return week;
    }

    private static Date toDate(String sdate) {
        try {
            return dateFormater.get().parse(sdate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getfriendlyTime(Long ms) {
        String paramDate;
        if (ms == null) {
            return "";
        }
        Date time = new Date();
        time.setTime(ms);
        if (time == null) {
            return "Unknown";
        }
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        String curDate = dateFormater2.get().format(cal.getTime());
        if (curDate.equals(paramDate = dateFormater2.get().format(time))) {
            int hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour == 0 ? ((cal.getTimeInMillis() - time.getTime()) / 60000L < 1L ? "\u521a\u521a" : Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d") : hour + "\u5c0f\u65f6\u524d";
            return ftime;
        }
        long lt = time.getTime() / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        if (days == 0) {
            int hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d";
        } else if (days == 1) {
            ftime = "\u6628\u5929";
        } else if (days == 2) {
            ftime = "\u524d\u5929";
        } else if (days > 2 && days <= 10) {
            ftime = days + "\u5929\u524d";
        } else if (days > 10) {
            ftime = dateFormater2.get().format(time);
        }
        return ftime;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static int getExpiredHour(String dateStr) {
        int ret = -1;
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HH_MM_SS);
        try {
            Date date = sdf.parse(dateStr);
            Date dateNow = new Date();
            long times = date.getTime() - dateNow.getTime();
            ret = times > 0L ? (int)(times / 3600000L) : -1;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static int getExpiredHour2(String dateStr) {
        int ret = -1;
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HH_MM_SS);
        try {
            Date sendDate = sdf.parse(dateStr);
            Date dateNow = new Date(System.currentTimeMillis());
            Log.e((String)"JPush", (String)("date=" + sendDate));
            long times = dateNow.getTime() - sendDate.getTime();
            Log.e((String)"JPush", (String)("date.getTime()=" + sendDate.getTime()));
            if (times > 0L) {
                ret = (int)(times / 3600000L);
                int n = (int)Math.floor(times / 3600000L);
            } else {
                ret = -1;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Log.e((String)"JPush", (String)("ret=" + ret));
        return ret;
    }

    public static boolean isToday(String sdate) {
        String timeDate;
        String nowDate;
        boolean b = false;
        Date time = DateUtil.toDate(sdate);
        Date today = new Date();
        if (time != null && (nowDate = dateFormater2.get().format(today)).equals(timeDate = dateFormater2.get().format(time))) {
            b = true;
        }
        return b;
    }

    public static boolean isToday(long sdate) {
        String timeDate;
        String nowDate;
        boolean b = false;
        Date time = new Date(sdate);
        Date today = new Date();
        if (time != null && (nowDate = dateFormater2.get().format(today)).equals(timeDate = dateFormater2.get().format(time))) {
            b = true;
        }
        return b;
    }

    public static int getAgeByBirthday(Date birthday) {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthday)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2) + 1;
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthday);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2) + 1;
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static String getFriendTimeOffer(long diff) {
        int day = (int)(diff / 86400000L);
        if (day > 0) {
            return day + "\u5929";
        }
        int time = (int)(diff / 3600000L);
        if (time > 0) {
            return time + "\u5c0f\u65f6";
        }
        int min = (int)(diff / 60000L);
        if (min > 0) {
            return min + "\u5206\u949f";
        }
        int sec = (int)diff / 1000;
        if (sec > 0) {
            return sec + "\u79d2";
        }
        return "1\u79d2";
    }

    public static String getFriendlyDuration(long duration) {
        String str = "";
        long tmpDuration = duration;
        str = str + (tmpDuration / 60L > 10L ? Long.valueOf(tmpDuration / 60L) : "0" + tmpDuration / 60L) + ":";
        str = str + ((tmpDuration %= 60L) / 1L >= 10L ? Long.valueOf(tmpDuration / 1L) : "0" + tmpDuration / 1L);
        tmpDuration %= 1L;
        return str;
    }

    public static String getFriendlyDuration2(long duration) {
        String str = "";
        long tmpDuration = duration;
        str = str + (tmpDuration / 60L > 0L ? tmpDuration / 60L + "'" : "");
        str = str + ((tmpDuration %= 60L) / 1L >= 10L ? tmpDuration / 1L + "''" : "0" + tmpDuration / 1L + "''");
        tmpDuration %= 1L;
        return str;
    }

    public static String getFriendlyMusicDuration(long duration) {
        String str = "-";
        int tmpDuration = (int)(duration / 1000L);
        str = str + (tmpDuration / 3600 > 10 ? Integer.valueOf(tmpDuration / 3600) : "0" + tmpDuration / 3600) + ":";
        str = str + ((tmpDuration %= 3600) / 60 > 10 ? Integer.valueOf(tmpDuration / 60) : "0" + tmpDuration / 60) + ":";
        str = str + ((tmpDuration %= 60) / 1 >= 10 ? Integer.valueOf(tmpDuration / 1) : "0" + tmpDuration / 1);
        tmpDuration %= 1;
        return str;
    }

    public static String getStarSeat(int mouth, int day) {
        String starSeat = null;
        starSeat = mouth == 3 && day >= 21 || mouth == 4 && day <= 19 ? "\u767d\u7f8a\u5ea7" : (mouth == 4 && day >= 20 || mouth == 5 && day <= 20 ? "\u91d1\u725b\u5ea7" : (mouth == 5 && day >= 21 || mouth == 6 && day <= 21 ? "\u53cc\u5b50\u5ea7" : (mouth == 6 && day >= 22 || mouth == 7 && day <= 22 ? "\u5de8\u87f9\u5ea7" : (mouth == 7 && day >= 23 || mouth == 8 && day <= 22 ? "\u72ee\u5b50\u5ea7" : (mouth == 8 && day >= 23 || mouth == 9 && day <= 22 ? "\u5904\u5973\u5ea7" : (mouth == 9 && day >= 23 || mouth == 10 && day <= 23 ? "\u5929\u79e4\u5ea7" : (mouth == 10 && day >= 24 || mouth == 11 && day <= 22 ? "\u5929\u874e\u5ea7" : (mouth == 11 && day >= 23 || mouth == 12 && day <= 21 ? "\u5c04\u624b\u5ea7" : (mouth == 12 && day >= 22 || mouth == 1 && day <= 19 ? "\u6469\u7faf\u5ea7" : (mouth == 1 && day >= 20 || mouth == 2 && day <= 18 ? "\u6c34\u74f6\u5ea7" : "\u53cc\u9c7c\u5ea7"))))))))));
        return starSeat;
    }

    public static String getChatTimeForShow(long time) {
        if (DateUtil.isToday(time)) {
            return DateUtil.getStringByFormat(time, FORMAT_YMDHMofChinese);
        }
        return DateUtil.getStringByFormat(time, FORMAT_YMDHMofChinese);
    }

    public static long getDatelongMills(String fomat, String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(fomat);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long longDate = date.getTime();
        return longDate;
    }

    public static int compare_date(String DATE1, String DATE2) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM, Locale.CHINA);
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() - dt2.getTime() > 0L) {
                return 1;
            }
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static String getCurrentTime() {
        String time = null;
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HH_MM_SS);
        long round = System.currentTimeMillis() / 1000L;
        String date = sdf.format(round * 1000L);
        String[] split = date.split("\\s");
        if (split.length > 1) {
            time = split[1];
        }
        return time;
    }

    public static String getYestoryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        String yestoday = sdf.format(calendar.getTime());
        return yestoday;
    }

    public static String getTomorrowDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        String tomorrow = sdf.format(calendar.getTime());
        return tomorrow;
    }

    public static String getTodayDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD);
        String date = sdf.format(new Date());
        return date;
    }

    public static String timeStampToStr1(long timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM);
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static long getStringToDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM);
        Date date = new Date();
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime() / 1000L;
    }

    public static boolean judgeCurrTime(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM);
        Date date = new Date();
        try {
            date = sdf.parse(time);
            long t = date.getTime();
            long round = System.currentTimeMillis();
            return t - round > 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean judgeCurrTime(long time) {
        long round = System.currentTimeMillis();
        return time - round > 0L;
    }

    public static boolean judgeTime2Time(String time1, String time2) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYY_MM_DD_HH_MM);
        try {
            Date date1 = sdf.parse(time1);
            Date date2 = sdf.parse(time2);
            long l1 = date1.getTime() / 1000L;
            long l2 = date2.getTime() / 1000L;
            return l2 - l1 > 0L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int judge_space_of_time(String time1, String time2) {
        long l1 = Long.parseLong(time1) / 1000L;
        long l2 = Long.parseLong(time2) / 1000L;
        return (int)((l2 - l1) / 60L);
    }

    public static String convertTimeToFormat(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = curTime - timeStamp;
        if (time < 60L && time >= 0L) {
            return "\u521a\u521a";
        }
        if (time >= 60L && time < 3600L) {
            return time / 60L + "\u5206\u949f\u524d";
        }
        if (time >= 3600L && time < 86400L) {
            return time / 3600L + "\u5c0f\u65f6\u524d";
        }
        if (time >= 86400L && time < 2592000L) {
            return time / 3600L / 24L + "\u5929\u524d";
        }
        if (time >= 2592000L && time < 31104000L) {
            return time / 3600L / 24L / 30L + "\u4e2a\u6708\u524d";
        }
        if (time >= 31104000L) {
            return time / 3600L / 24L / 30L / 12L + "\u5e74\u524d";
        }
        return "\u521a\u521a";
    }

    public static String convertTimeToDay(long timeStamp) {
        String today = DateUtil.getTodayDate();
        String yesDay = DateUtil.getYestoryDate();
        String nowDate = DateUtil.formatMs2String(timeStamp, FORMAT_YYYY_MM_DD_HH_MM);
        String showStr = "";
        showStr = nowDate.startsWith(today) ? nowDate.substring(today.length() + 1) : (nowDate.startsWith(yesDay) ? "\u6628\u5929  " + nowDate.substring(yesDay.length() + 1) : nowDate);
        return showStr;
    }

    public static String timeStampToFormat(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = curTime - timeStamp;
        return time / 60L + "";
    }

    public static int nowCurrentTime(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = curTime - timeStamp;
        return (int)(time / 60L);
    }

    public static String nowCurrentPoint(boolean flag) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_HH_MM);
        String date = sdf.format(System.currentTimeMillis());
        String[] split = date.split(":");
        String hour = null;
        String minute = null;
        if (flag) {
            if (split.length > 1) {
                hour = split[0];
                return hour;
            }
        } else if (split.length > 1) {
            minute = split[1];
            return minute;
        }
        return null;
    }

    public static String StandardFormatStr(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_YYYYMMDD_HH_MM_SS);
        try {
            Date d = sdf.parse(str);
            long timeStamp = d.getTime();
            long curTime = System.currentTimeMillis() / 1000L;
            long time = curTime - timeStamp / 1000L;
            return time / 60L + "";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String DateToWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(7);
        if (dayIndex < 1 || dayIndex > 7) {
            return null;
        }
        return WEEK[dayIndex - 1];
    }

    public static String DateToWeek(long timeStamp) {
        Date date = new Date(timeStamp);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(7);
        if (dayIndex < 1 || dayIndex > 7) {
            return null;
        }
        return WEEK[dayIndex - 1];
    }

    public static String convertGMTToLoacale(String gmt) {
        String s1 = gmt.substring(0, 10);
        String s2 = gmt.substring(11, 19);
        return s1 + " " + s2;
    }

    public static String getCurrentTimeSpecifyFormat(String formatType) {
        Date date = new Date();
        return DateUtil.formatDate2String(date, formatType);
    }

    public static String formatDate2String(Date date, String format) {
        if (date == null) {
            return "";
        }
        try {
            SimpleDateFormat e = new SimpleDateFormat(format);
            return e.format(date);
        }
        catch (Exception var3) {
            return "";
        }
    }

    public static String formatMs2String(long milliseconds, String format) {
        try {
            Date e = new Date(milliseconds);
            SimpleDateFormat formatPattern = new SimpleDateFormat(format);
            return formatPattern.format(e);
        }
        catch (Exception var5) {
            return "";
        }
    }
}

