/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.widget.Toast;
import com.liujc.baseutils.common.DateUtil;
import com.liujc.baseutils.common.LogUtil;
import com.liujc.baseutils.file.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CrashUtil
implements Thread.UncaughtExceptionHandler {
    private static CrashUtil mInstance = new CrashUtil();
    private Thread.UncaughtExceptionHandler mHandler;
    private boolean mInitialized;
    private static String crashDir;
    private String versionName;
    private int versionCode;
    private Context mContext;
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    private CrashUtil() {
    }

    public static CrashUtil getInstance() {
        return mInstance;
    }

    public boolean init(Context context) {
        if (this.mInitialized) {
            return true;
        }
        this.mContext = context;
        crashDir = "mounted".equals(Environment.getExternalStorageState()) ? context.getExternalCacheDir().getPath() + File.separator + "crash" + File.separator : context.getCacheDir().getPath() + File.separator + "crash" + File.separator;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            this.versionName = pi.versionName;
            this.versionCode = pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        this.mHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.autoClear(5);
        this.mInitialized = true;
        return true;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mHandler != null) {
            this.mHandler.uncaughtException(thread, ex);
        } else {
            SystemClock.sleep((long)3000L);
            Process.killProcess((int)Process.myPid());
            System.exit(1);
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        try {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    Toast.makeText((Context)CrashUtil.this.mContext, (CharSequence)"\u5f88\u62b1\u6b49,\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38,\u5373\u5c06\u91cd\u542f.", (int)1).show();
                    Looper.loop();
                }
            }.start();
            this.collectDeviceInfo(this.mContext);
            this.saveCrashInfoFile(ex);
            SystemClock.sleep((long)3000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void collectDeviceInfo(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            this.versionName = pi.versionName;
            this.versionCode = pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String saveCrashInfoFile(Throwable ex) throws Exception {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.getCrashHead());
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                cause.printStackTrace(printWriter);
            }
            printWriter.flush();
            printWriter.close();
            String result = ((Object)writer).toString();
            sb.append(result);
            String fileName = this.writeFile(sb.toString());
            return fileName;
        }
        catch (Exception e) {
            sb.append("an error occured while writing file...\r\n");
            this.writeFile(sb.toString());
            return null;
        }
    }

    private String writeFile(String sb) throws Exception {
        File crashLog;
        LogUtil.d(sb);
        String time = this.formatter.format(new Date());
        String fileName = "crash-" + time + ".log";
        File dir = new File(crashDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(crashLog = new File(crashDir, fileName)).exists()) {
            crashLog.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(crashLog, true);
        fos.write(sb.getBytes());
        fos.flush();
        fos.close();
        return fileName;
    }

    public void autoClear(final int autoClearDay) {
        FileUtil.delete(crashDir, new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                String s = FileUtil.getFileNameNoExtension(filename);
                int day = autoClearDay < 0 ? autoClearDay : -1 * autoClearDay;
                String date = "crash-" + DateUtil.getCurrentDateByOffset("yyyy-MM-dd", 5, day);
                return date.compareTo(s) >= 0;
            }
        });
    }

    private String getCrashHead() {
        return "\n*********************************************\n   Crash \u65f6\u95f4\uff1a" + DateUtil.getCurrentTime() + "\n************* Crash Log Head ****************" + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + this.versionName + "\nApp VersionCode    : " + this.versionCode + "\n************* Crash Log Head ****************\n\n";
    }
}

