/*
 * Decompiled with CFR 0.152.
 */
package com.liujc.baseutils.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Date;

public class ClassUtil {
    public static boolean isBaseDataType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Boolean.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(Date.class) || clazz.equals(byte[].class) || clazz.equals(Byte[].class);
    }

    public static <T> T newInstance(Class<T> claxx) throws Exception {
        int n = 0;
        Constructor<?>[] cons = claxx.getDeclaredConstructors();
        Constructor<?>[] constructorArray = cons;
        int n2 = constructorArray.length;
        if (n < n2) {
            Constructor<?> c = constructorArray[n];
            Class<?>[] cls = c.getParameterTypes();
            if (cls.length == 0) {
                c.setAccessible(true);
                return (T)c.newInstance(new Object[0]);
            }
            Object[] objs = new Object[cls.length];
            for (int i = 0; i < cls.length; ++i) {
                objs[i] = ClassUtil.getDefaultPrimiticeValue(cls[i]);
            }
            c.setAccessible(true);
            return (T)c.newInstance(objs);
        }
        return null;
    }

    public static Object getDefaultPrimiticeValue(Class clazz) {
        if (clazz.isPrimitive()) {
            return clazz == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        return null;
    }

    public static boolean isCollection(Class claxx) {
        return Collection.class.isAssignableFrom(claxx);
    }

    public static boolean isArray(Class claxx) {
        return claxx.isArray();
    }

    public static <T> Class getTClass(T t) {
        Type finalNeedType;
        Type genType = t.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        Type type = params[0];
        if (params.length > 1) {
            if (!(type instanceof ParameterizedType)) {
                throw new IllegalStateException("\u6ca1\u6709\u586b\u5199\u6cdb\u578b\u53c2\u6570");
            }
            finalNeedType = ((ParameterizedType)type).getActualTypeArguments()[0];
        } else {
            finalNeedType = type;
        }
        Class clazz = ClassUtil.getClass(finalNeedType, 0);
        return clazz;
    }

    public static Class getClass(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return ClassUtil.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    public static Class getGenericClass(ParameterizedType parameterizedType, int i) {
        Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return ClassUtil.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }
}

