package com.liujc.baseutils.system.AuthCode;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;

import com.liujc.baseutils.common.LogUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 类名称：VerificationCodeAutoFill
 * 创建者：Create by liujc
 * 创建时间：Create on 2017/1/18 15:12
 * 描述：验证码自动填充
 */
public class VerificationCodeAutoFill implements LoaderManager.LoaderCallbacks<Cursor> {

    private Context context;
    private OnNewMessageListener listener;
    private String msgRegular;

    public VerificationCodeAutoFill(Context context){
        this(context,null,null);
    }

    public VerificationCodeAutoFill(Context context, OnNewMessageListener listener){
        this(context,listener,null);
    }

    /**
     * @param context
     * @param listener 新短信监听
     * @param msgRegular 对新短信处理的正则表达式，如果为空，则不进行处理
     */
    public VerificationCodeAutoFill(Context context, OnNewMessageListener listener, String msgRegular){
        this.context=context;
        this.listener=listener;
        this.msgRegular=msgRegular;
    }

    public VerificationCodeAutoFill registerTo(int id,LoaderManager manager){
        manager.initLoader(id,null,this);
        return this;
    }

    @Override
    public Loader<Cursor> onCreateLoader(int id, Bundle args) {
        return new CursorLoader(context, Uri.parse("content://sms/inbox"),
                new String[] { "_id", "address", "read", "body" },
                " read=?",
                new String[] {"0" }, "_id desc");
    }

    @Override
    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        // 按id排序，如果按date排序的话，修改手机时间后，读取的短信就不准了
        if (data != null && data.getCount() > 0) {
            ContentValues values = new ContentValues();
            values.put("read", "1"); // 修改短信为已读模式
            data.moveToNext();
            int smsbodyColumn = data.getColumnIndex("body");
            String smsBody = data.getString(smsbodyColumn);
            LogUtil.d("smsBody:"+smsBody);
            if(listener!=null){
                listener.onNewMessage(getDynamicPassword(smsBody,msgRegular));
            }
        }
    }

    @Override
    public void onLoaderReset(Loader<Cursor> loader) {

    }

    public interface OnNewMessageListener {
        void onNewMessage(String msg);
    }

    private String getDynamicPassword(String str,String regular) {
        if(regular==null)return str;
        Pattern continuousNumberPattern = Pattern.compile(msgRegular);
        Matcher m = continuousNumberPattern.matcher(str);
        String dynamicPassword = "";
        while (m.find()) {
            System.out.print(m.group());
            dynamicPassword = m.group();
        }
        return dynamicPassword;
    }

}
/*用法
* //匹配四位数字的短信验证码
new VerificationCodeAutoFill(this, new VerificationCodeAutoFill.OnNewMessageListener() {
            @Override
            public void onNewMessage(String msg) {
                //etMsg.setText(msg);  //验证码填充
            }
        }, "\\d{4}").registerTo(1,getSupportLoaderManager());
* */