/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.ExternalSdCard;
import com.android.sdklib.internal.avd.InternalSdCard;
import com.android.sdklib.internal.avd.SdCard;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SDCARD_MAX_BYTE_SIZE", "", "SDCARD_MIN_BYTE_SIZE", "SDCARD_SIZE_PATTERN", "Lkotlin/text/Regex;", "createSdCard", "", "logger", "Lcom/android/utils/ILogger;", "toolLocation", "", "sizeSpec", "location", "parseSdCard", "Lcom/android/sdklib/internal/avd/SdCard;", "sdcard", "sdCardFromConfig", "config", "", "sdklib"})
@JvmName(name="SdCards")
public final class SdCards {
    @NotNull
    private static final Regex SDCARD_SIZE_PATTERN = new Regex("(\\d+)([KMG])");
    public static final long SDCARD_MIN_BYTE_SIZE = 0x900000L;
    public static final long SDCARD_MAX_BYTE_SIZE = 0xFFC0000000L;

    @Nullable
    public static final SdCard sdCardFromConfig(@NotNull Map<String, String> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        String path = config.get("sdcard.path");
        if (path != null) {
            return new ExternalSdCard(path);
        }
        Storage size = Storage.getStorageFromString(config.get("sdcard.size"));
        if (size != null) {
            return new InternalSdCard(size.getSize());
        }
        return null;
    }

    @NotNull
    public static final SdCard parseSdCard(@NotNull String sdcard) {
        Intrinsics.checkNotNullParameter((Object)sdcard, (String)"sdcard");
        MatchResult matchResult = SDCARD_SIZE_PATTERN.matchEntire((CharSequence)sdcard);
        if (matchResult == null) {
            return new ExternalSdCard(sdcard);
        }
        MatchResult match = matchResult;
        try {
            long l;
            long it = Long.parseLong((String)match.getGroupValues().get(1));
            boolean bl = false;
            switch ((String)match.getGroupValues().get(2)) {
                case "K": {
                    l = it << 10;
                    break;
                }
                case "M": {
                    l = it << 20;
                    break;
                }
                case "G": {
                    l = it << 30;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            long sdcardSize = l;
            boolean bl2 = 0x900000L <= sdcardSize ? sdcardSize < 1098437885953L : false;
            if (bl2) {
                return new InternalSdCard(sdcardSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("SD card size must be in the range 9M..1047552M");
    }

    public static final boolean createSdCard(@NotNull ILogger logger, @NotNull String toolLocation, @NotNull String sizeSpec, @NotNull String location) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)toolLocation, (String)"toolLocation");
        Intrinsics.checkNotNullParameter((Object)sizeSpec, (String)"sizeSpec");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            object = new String[]{toolLocation, sizeSpec, location};
            object = Runtime.getRuntime().exec((String[])object);
        }
        catch (IOException e) {
            logger.error((Throwable)e, "Failed to invoke mksdcard at " + toolLocation, new Object[0]);
            return false;
        }
        Object process = object;
        ArrayList<String> errorOutput = new ArrayList<String>();
        ArrayList<String> stdOutput = new ArrayList<String>();
        try {
            int status2 = GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(stdOutput, errorOutput){
                final /* synthetic */ ArrayList<String> $stdOutput;
                final /* synthetic */ ArrayList<String> $errorOutput;
                {
                    this.$stdOutput = $stdOutput;
                    this.$errorOutput = $errorOutput;
                }

                public void out(String line) {
                    if (line != null) {
                        this.$stdOutput.add(line);
                    }
                }

                public void err(String line) {
                    if (line != null) {
                        this.$errorOutput.add(line);
                    }
                }
            });
            if (status2 == 0) {
                return true;
            }
        }
        catch (InterruptedException e) {
            logger.warning("Interrupted", new Object[0]);
        }
        for (String error : errorOutput) {
            Object[] objectArray = new Object[]{error};
            logger.warning("%1$s", objectArray);
        }
        logger.warning("Failed to create the SD card.", new Object[0]);
        return false;
    }
}

