/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0006\u001a\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0003\u001a\"\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\r"}, d2={"produceRelativeSourceSetPath", "", "resourceFile", "Ljava/io/File;", "packageName", "moduleSourceSets", "", "readFromSourceSetPathsFile", "", "artifactFile", "relativeResourcePathToAbsolutePath", "relativePath", "sourceSetPathMap", "sdk-common"})
@JvmName(name="RelativeResourceUtils")
public final class RelativeResourceUtils {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String produceRelativeSourceSetPath(@NotNull File resourceFile, @NotNull String packageName, @NotNull Collection<? extends Collection<? extends File>> moduleSourceSets) {
        String variant;
        Intrinsics.checkParameterIsNotNull((Object)resourceFile, (String)"resourceFile");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull(moduleSourceSets, (String)"moduleSourceSets");
        String invariantFilePath = FilesKt.getInvariantSeparatorsPath((File)resourceFile);
        for (Collection<? extends File> collection : moduleSourceSets) {
            boolean bl = false;
            for (File sourceSetFile : (Iterable)collection) {
                void index;
                if (StringsKt.startsWith$default((String)invariantFilePath, (String)FilesKt.getInvariantSeparatorsPath((File)sourceSetFile), (boolean)false, (int)2, null)) {
                    int resIndex = FilesKt.getInvariantSeparatorsPath((File)sourceSetFile).length();
                    String string = invariantFilePath;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(resIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    String relativePathToSourceSet = string3;
                    return packageName + '-' + (int)index + ':' + relativePathToSourceSet;
                }
                ++index;
            }
        }
        List list = StringsKt.split$default((CharSequence)invariantFilePath, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
        if (list.contains("generated") && list.contains("pngs")) {
            variant = (String)list.get(list.indexOf("pngs") + 1);
            String relativePathToSourceSet = StringsKt.substringAfterLast$default((String)invariantFilePath, (String)variant, null, (int)2, null);
            return packageName + "-generated-pngs-" + variant + ':' + relativePathToSourceSet;
        }
        if (list.contains("incremental") && list.contains("merged.dir")) {
            variant = (String)list.get(list.indexOf("incremental") + 1);
            String relativePathToSourceSet = StringsKt.substringAfterLast$default((String)invariantFilePath, (String)"merged.dir", null, (int)2, null);
            return packageName + "-incremental-" + variant + "-merged.dir:" + relativePathToSourceSet;
        }
        throw (Throwable)new IllegalArgumentException("Unable to locate resourceFile (" + resourceFile.getAbsolutePath() + ") in source-sets.");
    }

    @NotNull
    public static final String relativeResourcePathToAbsolutePath(@NotNull String relativePath, @NotNull Map<String, String> sourceSetPathMap) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull(sourceSetPathMap, (String)"sourceSetPathMap");
        if (MapsKt.none(sourceSetPathMap)) {
            throw (Throwable)new IllegalStateException("Unable to get absolute path from " + relativePath + "\n                   because no relative root paths are present.");
        }
        int separatorIndex = StringsKt.indexOf$default((CharSequence)relativePath, (char)':', (int)0, (boolean)false, (int)6, null);
        if (separatorIndex == -1) {
            throw (Throwable)new IllegalArgumentException("Source set identifier and relative path must be separated by a ':'character.\n                   Relative path: " + relativePath);
        }
        String string = relativePath;
        int n = 0;
        int n2 = 0;
        String string2 = string.substring(n, separatorIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sourceSetPrefix = string2;
        String string3 = relativePath;
        n2 = separatorIndex + 1;
        int n3 = relativePath.length();
        boolean bl = false;
        String string4 = string3.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String resourcePathFromSourceSet = string4;
        String string5 = sourceSetPathMap.get(sourceSetPrefix);
        if (string5 == null) {
            throw (Throwable)new NoSuchElementException("Unable to get absolute path from " + relativePath + "\n                       because " + sourceSetPrefix + " is not key in sourceSetPathMap.");
        }
        String absolutePath = string5;
        return absolutePath + resourcePathFromSourceSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> readFromSourceSetPathsFile(@NotNull File artifactFile) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        if (!artifactFile.exists() || !artifactFile.isFile()) {
            throw (Throwable)new IOException(artifactFile + " does not exist or is not a file.");
        }
        File file = artifactFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object = file;
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        object2 = new FileInputStream((File)object2);
        bl3 = false;
        object = new InputStreamReader((InputStream)object2, charset);
        bl2 = false;
        Sequence $this$associate$iv = TextStreamsKt.lineSequence((BufferedReader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)));
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            Pair pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (String)" ", null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (String)" ", null, (int)2, null));
            boolean bl5 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }
}

