/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifactImpl;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeProductFlavor;
import com.android.ide.common.gradle.model.IdeTestedTargetVariant;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class IdeVariantImpl
extends IdeModel
implements IdeVariant {
    private static final long serialVersionUID = 1L;
    private final String myName;
    private final String myDisplayName;
    private final IdeAndroidArtifact myMainArtifact;
    private final Collection<AndroidArtifact> myExtraAndroidArtifacts;
    private final Collection<JavaArtifact> myExtraJavaArtifacts;
    private final String myBuildType;
    private final List<String> myProductFlavors;
    private final ProductFlavor myMergedFlavor;
    private final Collection<TestedTargetVariant> myTestedTargetVariants;
    private final int myHashCode;
    private final boolean myInstantAppCompatible;

    public IdeVariantImpl(Variant variant, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory, GradleVersion modelVersion) {
        super(variant, modelCache);
        this.myName = variant.getName();
        this.myDisplayName = variant.getDisplayName();
        this.myMainArtifact = modelCache.computeIfAbsent(variant.getMainArtifact(), artifact -> new IdeAndroidArtifactImpl((AndroidArtifact)artifact, modelCache, dependenciesFactory, modelVersion));
        this.myExtraAndroidArtifacts = IdeVariantImpl.copy(variant.getExtraAndroidArtifacts(), modelCache, (K artifact) -> new IdeAndroidArtifactImpl((AndroidArtifact)artifact, modelCache, dependenciesFactory, modelVersion));
        this.myExtraJavaArtifacts = IdeVariantImpl.copy(variant.getExtraJavaArtifacts(), modelCache, (K artifact) -> new IdeJavaArtifact((JavaArtifact)artifact, modelCache, dependenciesFactory, modelVersion));
        this.myBuildType = variant.getBuildType();
        this.myProductFlavors = ImmutableList.copyOf((Collection)variant.getProductFlavors());
        this.myMergedFlavor = modelCache.computeIfAbsent(variant.getMergedFlavor(), flavor -> new IdeProductFlavor((ProductFlavor)flavor, modelCache));
        this.myTestedTargetVariants = IdeVariantImpl.getTestedTargetVariants(variant, modelCache);
        this.myInstantAppCompatible = modelVersion != null && modelVersion.isAtLeast(3, 3, 0, "alpha", 10, true) && variant.isInstantAppCompatible();
        this.myHashCode = this.calculateHashCode();
    }

    private static Collection<TestedTargetVariant> getTestedTargetVariants(Variant variant, ModelCache modelCache) {
        try {
            return IdeVariantImpl.copy(variant.getTestedTargetVariants(), modelCache, (K targetVariant) -> new IdeTestedTargetVariant((TestedTargetVariant)targetVariant, modelCache));
        }
        catch (UnsupportedOperationException e) {
            return Collections.emptyList();
        }
    }

    public String getName() {
        return this.myName;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public IdeAndroidArtifact getMainArtifact() {
        return this.myMainArtifact;
    }

    public Collection<AndroidArtifact> getExtraAndroidArtifacts() {
        return this.myExtraAndroidArtifacts;
    }

    public Collection<JavaArtifact> getExtraJavaArtifacts() {
        return this.myExtraJavaArtifacts;
    }

    public String getBuildType() {
        return this.myBuildType;
    }

    public List<String> getProductFlavors() {
        return this.myProductFlavors;
    }

    public ProductFlavor getMergedFlavor() {
        return this.myMergedFlavor;
    }

    public Collection<TestedTargetVariant> getTestedTargetVariants() {
        return this.myTestedTargetVariants;
    }

    @Override
    public Collection<IdeBaseArtifact> getTestArtifacts() {
        ImmutableSet.Builder testArtifacts = ImmutableSet.builder();
        Consumer<IdeBaseArtifact> action = artifact -> {
            if (artifact.isTestArtifact()) {
                testArtifacts.add(artifact);
            }
        };
        IdeVariantImpl.forEachArtifact(this.myExtraAndroidArtifacts, action);
        IdeVariantImpl.forEachArtifact(this.myExtraJavaArtifacts, action);
        return testArtifacts.build();
    }

    private static void forEachArtifact(Collection<? extends BaseArtifact> artifacts2, Consumer<IdeBaseArtifact> action) {
        for (BaseArtifact baseArtifact : artifacts2) {
            action.accept((IdeBaseArtifact)baseArtifact);
        }
    }

    @Override
    public IdeAndroidArtifact getAndroidTestArtifact() {
        for (AndroidArtifact artifact : this.myExtraAndroidArtifacts) {
            IdeAndroidArtifactImpl ideArtifact = (IdeAndroidArtifactImpl)artifact;
            if (!ideArtifact.isTestArtifact()) continue;
            return ideArtifact;
        }
        return null;
    }

    @Override
    public IdeJavaArtifact getUnitTestArtifact() {
        for (JavaArtifact artifact : this.myExtraJavaArtifacts) {
            IdeJavaArtifact ideArtifact = (IdeJavaArtifact)artifact;
            if (!ideArtifact.isTestArtifact()) continue;
            return ideArtifact;
        }
        return null;
    }

    public boolean isInstantAppCompatible() {
        return this.myInstantAppCompatible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeVariantImpl)) {
            return false;
        }
        IdeVariantImpl variant = (IdeVariantImpl)o;
        return Objects.equals(this.myName, variant.myName) && Objects.equals(this.myDisplayName, variant.myDisplayName) && Objects.equals(this.myMainArtifact, variant.myMainArtifact) && Objects.equals(this.myExtraAndroidArtifacts, variant.myExtraAndroidArtifacts) && Objects.equals(this.myExtraJavaArtifacts, variant.myExtraJavaArtifacts) && Objects.equals(this.myBuildType, variant.myBuildType) && Objects.equals(this.myProductFlavors, variant.myProductFlavors) && Objects.equals(this.myMergedFlavor, variant.myMergedFlavor) && Objects.equals(this.myTestedTargetVariants, variant.myTestedTargetVariants) && Objects.equals(this.myInstantAppCompatible, variant.myInstantAppCompatible);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myDisplayName, this.myMainArtifact, this.myExtraAndroidArtifacts, this.myExtraJavaArtifacts, this.myBuildType, this.myProductFlavors, this.myMergedFlavor, this.myTestedTargetVariants, this.myInstantAppCompatible);
    }

    public String toString() {
        return "IdeVariant{myName='" + this.myName + '\'' + ", myDisplayName='" + this.myDisplayName + '\'' + ", myMainArtifact=" + this.myMainArtifact + ", myExtraAndroidArtifacts=" + this.myExtraAndroidArtifacts + ", myExtraJavaArtifacts=" + this.myExtraJavaArtifacts + ", myBuildType='" + this.myBuildType + '\'' + ", myProductFlavors=" + this.myProductFlavors + ", myMergedFlavor=" + this.myMergedFlavor + ", myTestedTargetVariants=" + this.myTestedTargetVariants + ", myInstantAppCompatible=" + this.myInstantAppCompatible + "}";
    }
}

