/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.SigningConfig;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import java.io.File;
import java.util.Objects;

public final class IdeSigningConfig
extends IdeModel
implements SigningConfig {
    private static final long serialVersionUID = 2L;
    private final String myName;
    private final File myStoreFile;
    private final String myStorePassword;
    private final String myKeyAlias;
    private final Boolean myV1SigningEnabled;
    private final int myHashCode;

    public IdeSigningConfig(SigningConfig config, ModelCache modelCache) {
        super(config, modelCache);
        this.myName = config.getName();
        this.myStoreFile = config.getStoreFile();
        this.myStorePassword = config.getStorePassword();
        this.myKeyAlias = config.getKeyAlias();
        this.myV1SigningEnabled = IdeSigningConfig.copyNewProperty(() -> ((SigningConfig)config).isV1SigningEnabled(), null);
        this.myHashCode = this.calculateHashCode();
    }

    public String getName() {
        return this.myName;
    }

    public File getStoreFile() {
        return this.myStoreFile;
    }

    public String getStorePassword() {
        return this.myStorePassword;
    }

    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    public String getKeyPassword() {
        throw new UnusedModelMethodException("getKeyPassword");
    }

    public String getStoreType() {
        throw new UnusedModelMethodException("getStoreType");
    }

    public boolean isV1SigningEnabled() {
        if (this.myV1SigningEnabled != null) {
            return this.myV1SigningEnabled;
        }
        throw new UnsupportedOperationException("Unsupported method: SigningConfig.isV1SigningEnabled()");
    }

    public boolean isV2SigningEnabled() {
        throw new UnusedModelMethodException("isV2SigningEnabled");
    }

    public boolean isSigningReady() {
        throw new UnusedModelMethodException("isSigningReady");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSigningConfig)) {
            return false;
        }
        IdeSigningConfig config = (IdeSigningConfig)o;
        return Objects.equals(this.myV1SigningEnabled, config.myV1SigningEnabled) && Objects.equals(this.myName, config.myName) && Objects.equals(this.myStoreFile, config.myStoreFile) && Objects.equals(this.myStorePassword, config.myStorePassword) && Objects.equals(this.myKeyAlias, config.myKeyAlias);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myStoreFile, this.myStorePassword, this.myKeyAlias, this.myV1SigningEnabled);
    }

    public String toString() {
        return "IdeSigningConfig{myName='" + this.myName + '\'' + ", myStoreFile=" + this.myStoreFile + ", myStorePassword='" + this.myStorePassword + '\'' + ", myKeyAlias='" + this.myKeyAlias + '\'' + ", myV1SigningEnabled=" + this.myV1SigningEnabled + '}';
    }
}

