/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFileJsonTypeAdapter;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourceFilePositionJsonSerializer;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.SourcePositionJsonTypeAdapter;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.lang.reflect.Type;

public class MessageJsonSerializer
implements JsonSerializer<Message>,
JsonDeserializer<Message> {
    private static final String KIND = "kind";
    private static final String TEXT = "text";
    private static final String SOURCE_FILE_POSITIONS = "sources";
    private static final String RAW_MESSAGE = "original";
    private static final String LEGACY_SOURCE_PATH = "sourcePath";
    private static final String LEGACY_POSITION = "position";
    private static final BiMap<Message.Kind, String> KIND_STRING_ENUM_MAP;

    public JsonElement serialize(Message message, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject result = new JsonObject();
        result.addProperty(KIND, (String)KIND_STRING_ENUM_MAP.get((Object)message.getKind()));
        result.addProperty(TEXT, message.getText());
        result.add(SOURCE_FILE_POSITIONS, jsonSerializationContext.serialize((Object)message.getSourceFilePositions()));
        if (!message.getRawMessage().equals(message.getText())) {
            result.addProperty(RAW_MESSAGE, message.getRawMessage());
        }
        return result;
    }

    public Message deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        ImmutableList sourceFilePositions;
        String rawMessage;
        Message.Kind theKind;
        JsonObject object = jsonElement.getAsJsonObject();
        Message.Kind kind = object.has(KIND) ? ((theKind = (Message.Kind)KIND_STRING_ENUM_MAP.inverse().get((Object)object.get(KIND).getAsString().toLowerCase())) != null ? theKind : Message.Kind.UNKNOWN) : Message.Kind.UNKNOWN;
        String text = object.has(TEXT) ? object.get(TEXT).getAsString() : "";
        String string = rawMessage = object.has(RAW_MESSAGE) ? object.get(RAW_MESSAGE).getAsString() : text;
        if (object.has(SOURCE_FILE_POSITIONS)) {
            JsonElement e = object.get(SOURCE_FILE_POSITIONS);
            if (e.isJsonArray()) {
                Object[] positions = (SourceFilePosition[])context.deserialize(e, SourceFilePosition[].class);
                sourceFilePositions = ImmutableList.copyOf((Object[])positions);
            } else {
                sourceFilePositions = e.isJsonObject() ? ImmutableList.of((Object)context.deserialize(e, SourceFilePosition.class)) : ImmutableList.of((Object)SourceFilePosition.UNKNOWN);
            }
        } else if (object.has(LEGACY_SOURCE_PATH) || object.has(LEGACY_POSITION)) {
            SourceFile sourceFile = SourceFile.UNKNOWN;
            if (object.has(LEGACY_SOURCE_PATH)) {
                sourceFile = new SourceFile(new File(object.get(LEGACY_SOURCE_PATH).getAsString()));
            }
            SourcePosition sourcePosition = SourcePosition.UNKNOWN;
            if (object.has(LEGACY_POSITION)) {
                sourcePosition = (SourcePosition)context.deserialize(object.get(LEGACY_POSITION), SourcePosition.class);
            }
            sourceFilePositions = ImmutableList.of((Object)new SourceFilePosition(sourceFile, sourcePosition));
        } else {
            sourceFilePositions = ImmutableList.of((Object)SourceFilePosition.UNKNOWN);
        }
        return new Message(kind, text, rawMessage, sourceFilePositions);
    }

    public static void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(SourceFile.class, (Object)new SourceFileJsonTypeAdapter());
        builder.registerTypeAdapter(SourcePosition.class, (Object)new SourcePositionJsonTypeAdapter());
        builder.registerTypeAdapter(SourceFilePosition.class, (Object)new SourceFilePositionJsonSerializer());
        builder.registerTypeAdapter(Message.class, (Object)new MessageJsonSerializer());
    }

    static {
        EnumHashBiMap map = EnumHashBiMap.create(Message.Kind.class);
        map.put((Enum)Message.Kind.ERROR, (Object)"error");
        map.put((Enum)Message.Kind.WARNING, (Object)"warning");
        map.put((Enum)Message.Kind.INFO, (Object)"info");
        map.put((Enum)Message.Kind.STATISTICS, (Object)"statistics");
        map.put((Enum)Message.Kind.UNKNOWN, (Object)"unknown");
        map.put((Enum)Message.Kind.SIMPLE, (Object)"simple");
        KIND_STRING_ENUM_MAP = Maps.unmodifiableBiMap((BiMap)map);
    }
}

