/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.infrastructure.DuplicateProjectFinder;
import com.android.tools.lint.checks.infrastructure.GradleModelMocker;
import com.android.tools.lint.checks.infrastructure.LintTestUtils;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.ProjectDescriptionList;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestIssueRegistry;
import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.checks.infrastructure.TestLintResult;
import com.android.tools.lint.checks.infrastructure.TestLintRunner;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.FileOption;
import com.android.tools.lint.detector.api.FloatOption;
import com.android.tools.lint.detector.api.IntOption;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.uast.kotlin.KotlinConverter;
import org.junit.Assert;

public class TestLintTask {
    final Map<File, GradleModelMocker> projectMocks = Maps.newHashMap();
    final Map<File, ProjectDescription> dirToProjectDescription = Maps.newHashMap();
    final TestLintRunner runner = new TestLintRunner(this);
    static DuplicateProjectFinder duplicateFinder = null;
    private List<Issue> checkedIssues;
    protected ProjectDescriptionList projects = new ProjectDescriptionList();
    boolean requestedResourceRepository;
    boolean forceAgpResourceRepository;
    boolean allowCompilationErrors;
    boolean allowObsoleteLintChecks = true;
    boolean allowSystemErrors = true;
    String incrementalFileName;
    Issue[] issues;
    String[] issueIds;
    boolean allowDelayedIssueRegistration;
    public File sdkHome;
    List<LintListener> listeners = new ArrayList<LintListener>();
    LintDriverConfigurator driverConfigurator;
    OptionSetter optionSetter;
    ErrorMessageChecker messageChecker;
    ProjectInspector projectInspector;
    String variantName;
    EnumSet<Scope> customScope;
    public boolean forceSymbolResolutionErrors;
    ClientFactory clientFactory;
    Detector detector;
    File[] customRules;
    boolean ignoreUnknownGradleConstructs;
    boolean allowMissingSdk;
    boolean requireCompileSdk;
    boolean vital;
    TextFormat textFormat = TextFormat.TEXT;
    Map<String, byte[]> mockNetworkData;
    Map<String, Integer> mockNetworkErrorCodes;
    Map<String, Map<String, List<String>>> mockNetworkHeaderFields;
    boolean allowNetworkAccess;
    boolean allowDuplicates;
    boolean showSecondaryLintContent = false;
    File rootDirectory;
    File tempDir;
    TestFile baseline;
    File baselineFile;
    Map<String, String> configuredOptions = null;
    TestFile overrideConfig;
    File overrideConfigFile;
    Set<Desugaring> desugaring;
    EnumSet<Platform> platforms;
    Collection<TestMode> testModes = new ArrayList<TestMode>(TestMode.Companion.values());
    Collection<TestMode> ignoredTestModes = new ArrayList<TestMode>();
    boolean testModesIdenticalOutput = true;
    boolean useTestProject;
    boolean allowExceptions;
    public String testName = null;
    boolean useTestConfiguration = true;
    ProjectDescription reportFrom = null;
    boolean stripRoot = true;
    boolean includeSelectionMarkers = true;
    boolean allowAbsolutePathsInMessages = false;
    boolean allowNonAlphabeticalFixOrder = false;
    boolean allowKotlinClassStubs = false;
    LanguageLevel javaLanguageLevel = null;
    LanguageVersionSettings kotlinLanguageLevel = null;

    public TestLintTask() {
        LintClient.setClientName((String)"test");
        BuiltinIssueRegistry.reset();
        this.tempDir = TestFile.createTempDirectory();
        try {
            this.tempDir = this.tempDir.getCanonicalFile();
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
    }

    @CheckReturnValue
    public static TestLintTask lint() {
        return new TestLintTask();
    }

    public TestLintTask(ProjectDescription[] projects) {
        this.projects = new ProjectDescriptionList(Arrays.asList(projects), null);
    }

    public TestLintTask projects(ProjectDescription ... projects) {
        this.ensurePreRun();
        this.projects.addProjects(Arrays.asList(projects));
        return this;
    }

    public TestLintTask files(TestFile ... files2) {
        this.ensurePreRun();
        ProjectDescription project = new ProjectDescription(files2);
        this.projects.addProject(project);
        return this;
    }

    public TestLintTask allowCompilationErrors() {
        this.ensurePreRun();
        this.allowCompilationErrors = true;
        return this;
    }

    public TestLintTask allowCompilationErrors(boolean allow) {
        this.ensurePreRun();
        this.allowCompilationErrors = allow;
        return this;
    }

    public TestLintTask allowObsoleteLintChecks(boolean allow) {
        this.ensurePreRun();
        this.allowObsoleteLintChecks = allow;
        return this;
    }

    public TestLintTask allowMissingSdk() {
        return this.allowMissingSdk(true);
    }

    public TestLintTask allowMissingSdk(boolean allowMissingSdk) {
        this.ensurePreRun();
        this.allowMissingSdk = allowMissingSdk;
        return this;
    }

    public TestLintTask allowAbsolutePathsInMessages(boolean allowAbsolutePathsInMessages) {
        this.allowAbsolutePathsInMessages = allowAbsolutePathsInMessages;
        return this;
    }

    public TestLintTask allowNonAlphabeticalFixOrder(boolean allowNonAlphabeticalFixOrder) {
        this.allowNonAlphabeticalFixOrder = allowNonAlphabeticalFixOrder;
        return this;
    }

    public TestLintTask allowKotlinClassStubs(boolean allowKotlinClassStubs) {
        this.allowKotlinClassStubs = allowKotlinClassStubs;
        return this;
    }

    public TestLintTask requireCompileSdk() {
        return this.requireCompileSdk(true);
    }

    public TestLintTask requireCompileSdk(boolean requireCompileSdk) {
        this.ensurePreRun();
        this.requireCompileSdk = requireCompileSdk;
        return this;
    }

    public TestLintTask allowSystemErrors(boolean allow) {
        this.ensurePreRun();
        this.allowSystemErrors = allow;
        return this;
    }

    public TestLintTask incremental(String currentFileName) {
        return this.isolated(currentFileName);
    }

    public TestLintTask isolated(String currentFileName) {
        this.ensurePreRun();
        this.incrementalFileName = currentFileName;
        return this;
    }

    public TestLintTask detector(Detector detector) {
        this.detector = detector;
        this.checkedIssues = null;
        return this;
    }

    public TestLintTask issues(Issue ... issues) {
        this.ensurePreRun();
        this.issues = issues;
        for (Issue issue : issues) {
            if (issue != IssueRegistry.LINT_ERROR) continue;
            this.allowSystemErrors = true;
            break;
        }
        this.checkedIssues = null;
        return this;
    }

    public TestLintTask baseline(TestFile baseline) {
        this.ensurePreRun();
        this.baseline = baseline;
        return this;
    }

    public TestLintTask javaLanguageLevel(String javaLanguageLevel) {
        this.ensurePreRun();
        LanguageLevel level = LanguageLevel.parse((String)javaLanguageLevel);
        if (level == null) {
            throw new IllegalArgumentException("Invalid Java language level \"" + javaLanguageLevel + "\"");
        }
        return this.javaLanguageLevel(level);
    }

    public TestLintTask javaLanguageLevel(LanguageLevel javaLanguageLevel) {
        this.ensurePreRun();
        this.javaLanguageLevel = javaLanguageLevel;
        return this;
    }

    public TestLintTask kotlinLanguageLevel(String kotlinLanguageLevel) {
        this.ensurePreRun();
        LanguageVersion languageLevel = LanguageVersion.fromVersionString((String)kotlinLanguageLevel);
        if (languageLevel == null) {
            throw new IllegalArgumentException("Invalid Kotlin language level \"" + kotlinLanguageLevel + "\"");
        }
        ApiVersion apiVersion = ApiVersion.createByLanguageVersion((LanguageVersion)languageLevel);
        return this.kotlinLanguageLevel((LanguageVersionSettings)new LanguageVersionSettingsImpl(languageLevel, apiVersion));
    }

    public TestLintTask kotlinLanguageLevel(LanguageVersionSettings kotlinLanguageLevel) {
        this.ensurePreRun();
        this.kotlinLanguageLevel = kotlinLanguageLevel;
        return this;
    }

    public TestLintTask overrideConfig(TestFile overrideConfig) {
        this.ensurePreRun();
        this.overrideConfig = overrideConfig;
        return this;
    }

    public TestLintTask testModes(Collection<TestMode> testModes) {
        Assert.assertFalse((boolean)testModes.isEmpty());
        this.testModes = testModes;
        return this;
    }

    public TestLintTask testModes(TestMode ... testModes) {
        this.testModes = new ArrayList<TestMode>(Arrays.asList(testModes));
        return this;
    }

    public TestLintTask skipTestModes(TestMode ... modes) {
        for (TestMode mode : modes) {
            this.testModes.remove(mode);
            this.ignoredTestModes.add(mode);
        }
        return this;
    }

    public TestLintTask addTestModes(TestMode ... modes) {
        for (TestMode mode : modes) {
            if (this.testModes.contains(mode)) continue;
            this.testModes.add(mode);
        }
        return this;
    }

    public TestLintTask expectIdenticalTestModeOutput(boolean identical) {
        this.ensurePreRun();
        this.testModesIdenticalOutput = identical;
        return this;
    }

    public TestLintTask useTestConfiguration(boolean useTestConfiguration) {
        this.ensurePreRun();
        this.useTestConfiguration = useTestConfiguration;
        return this;
    }

    public TestLintTask issueIds(String ... ids) {
        this.ensurePreRun();
        this.issueIds = ids;
        for (String id : ids) {
            if (!IssueRegistry.LINT_ERROR.getId().equals(id)) continue;
            this.allowSystemErrors = true;
            break;
        }
        this.checkedIssues = null;
        return this;
    }

    public TestLintTask allowDelayedIssueRegistration(boolean allowDelayedIssueRegistration) {
        this.allowDelayedIssueRegistration = allowDelayedIssueRegistration;
        this.checkedIssues = null;
        return this;
    }

    public TestLintTask allowDelayedIssueRegistration() {
        return this.allowDelayedIssueRegistration(true);
    }

    public TestLintTask customRules(File ... customRuleJars) {
        this.customRules = customRuleJars;
        this.checkedIssues = null;
        return this;
    }

    public TestLintTask incremental() {
        return this.isolated();
    }

    public TestLintTask isolated() {
        this.ensurePreRun();
        if (this.projects.getSize() == 1 && this.projects.get(0).getFiles().length == 1) {
            this.incrementalFileName = this.projects.get(0).getFiles()[0].getTargetPath();
        } else if (this.projects.isEmpty()) {
            Assert.fail((String)"Can't use incremental mode without any projects!");
        } else {
            StringBuilder sb = new StringBuilder();
            for (ProjectDescription project : this.projects) {
                for (TestFile file : project.getFiles()) {
                    sb.append("\n");
                    if (!project.getName().isEmpty()) {
                        sb.append(project.getName()).append("/");
                    }
                    sb.append(file.getTargetPath());
                }
            }
            Assert.fail((String)("Can only use implicit incremental mode when there is a single source file; use incremental(relativePath) instead. Perhaps you meant one of the following: " + sb.toString()));
        }
        return this;
    }

    public TestLintTask listener(LintListener listener) {
        this.ensurePreRun();
        this.listeners.add(listener);
        return this;
    }

    public TestLintTask sdkHome(File sdkHomeOverride) {
        this.ensurePreRun();
        this.sdkHome = sdkHomeOverride;
        return this;
    }

    public TestLintTask testName(String testName) {
        this.testName = testName;
        return this;
    }

    public TestLintTask useTestProjectImplementation(boolean useTestProject) {
        this.ensurePreRun();
        this.useTestProject = useTestProject;
        return this;
    }

    public TestLintTask includeSelectionMarkers(boolean includeSelectionMarkers) {
        this.includeSelectionMarkers = includeSelectionMarkers;
        return this;
    }

    public TestLintTask configureDriver(LintDriverConfigurator configurator) {
        this.ensurePreRun();
        this.driverConfigurator = configurator;
        return this;
    }

    public TestLintTask configureOptions(OptionSetter setter) {
        this.ensurePreRun();
        this.optionSetter = setter;
        return this;
    }

    public TestLintTask configureOption(String key, String value) {
        this.ensurePreRun();
        if (this.configuredOptions == null) {
            this.configuredOptions = new LinkedHashMap<String, String>();
        }
        this.configuredOptions.put(key, value);
        return this;
    }

    public TestLintTask configureOption(Option option, String value) {
        this.ensurePreRun();
        return this.configureOption(option.getName(), value);
    }

    public TestLintTask configureOption(BooleanOption option, boolean value) {
        this.ensurePreRun();
        return this.configureOption(option.getName(), Boolean.toString(value));
    }

    public TestLintTask configureOption(IntOption option, int value) {
        this.ensurePreRun();
        return this.configureOption(option.getName(), Integer.toString(value));
    }

    public TestLintTask configureOption(FloatOption option, float value) {
        this.ensurePreRun();
        return this.configureOption(option.getName(), Float.toString(value));
    }

    public TestLintTask configureOption(FileOption option, File value) {
        this.ensurePreRun();
        return this.configureOption(option.getName(), LintTestUtils.portablePath(value.getPath()));
    }

    public TestLintTask customScope(EnumSet<Scope> customScope) {
        this.ensurePreRun();
        this.customScope = customScope;
        return this;
    }

    public TestLintTask checkMessage(ErrorMessageChecker checker) {
        this.ensurePreRun();
        this.messageChecker = checker;
        return this;
    }

    public TestLintTask checkProjects(ProjectInspector inspector) {
        this.ensurePreRun();
        this.projectInspector = inspector;
        return this;
    }

    @Deprecated
    public TestLintTask client(final TestLintClient client2) {
        this.ensurePreRun();
        Assert.assertNull((String)"Only specify clientFactory", (Object)this.clientFactory);
        this.clientFactory = new ClientFactory(){
            int count = 0;

            @Override
            public TestLintClient create() {
                ++this.count;
                if (this.count > 1) {
                    client2.log(null, "Warning: Using the same client more than once; make sure you call\nclientFactory() instead of the deprecated client() from your lint()\ntask. This normally just means passing in your creation code as a\nlambda; e.g. client(object : TestLintClient()...) should be converted\nto clientFactory({object: TestLintClient()...}).\n", new Object[0]);
                }
                return client2;
            }
        };
        return this;
    }

    public TestLintTask clientFactory(ClientFactory factory) {
        this.ensurePreRun();
        this.clientFactory = factory;
        return this;
    }

    public TestLintTask variant(String variantName) {
        this.ensurePreRun();
        this.variantName = variantName;
        return this;
    }

    public TestLintTask vital(boolean vital) {
        this.ensurePreRun();
        this.vital = vital;
        return this;
    }

    public TestLintTask ignoreUnknownGradleConstructs() {
        this.ensurePreRun();
        this.ignoreUnknownGradleConstructs = true;
        return this;
    }

    public TestLintTask textFormat(TextFormat textFormat) {
        this.ensurePreRun();
        this.textFormat = textFormat;
        return this;
    }

    public TestLintTask forceSymbolResolutionErrors() {
        this.ensurePreRun();
        this.forceSymbolResolutionErrors = true;
        return this;
    }

    public TestLintTask allowDuplicates() {
        this.allowDuplicates = true;
        return this;
    }

    public TestLintTask showSecondaryLintContent(boolean showSecondaryLintContent) {
        this.showSecondaryLintContent = showSecondaryLintContent;
        return this;
    }

    public TestLintTask desugaring(Set<Desugaring> desugaring) {
        this.desugaring = desugaring;
        return this;
    }

    public TestLintTask allowExceptions(boolean allowExceptions) {
        this.allowExceptions = allowExceptions;
        return this;
    }

    public TestLintTask supportResourceRepository(boolean supportResourceRepository) {
        if (!supportResourceRepository) {
            Assert.fail((String)"Resource repositories are now always supported");
        }
        return this;
    }

    public TestLintTask stripRoot(boolean stripRoot) {
        this.stripRoot = stripRoot;
        return this;
    }

    void ensureConfigured() {
        this.getCheckedIssues();
        if (this.projects.isEmpty()) {
            throw new RuntimeException("No test files to check lint in: call files() or projects()");
        }
    }

    private void ensurePreRun() {
        if (this.runner.getAlreadyRun()) {
            throw new RuntimeException("This method should only be called before run()");
        }
    }

    public String stripRoot(File rootDir, String s) {
        return this.runner.stripRoot(rootDir, s);
    }

    @CheckReturnValue
    public TestLintResult run() {
        return this.runner.run();
    }

    static void setForceUiInjection(boolean on) {
        KotlinConverter.INSTANCE.setForceUInjectionHost(on);
    }

    public List<Project> createProjects(boolean keepFiles) {
        return this.runner.createProjects(keepFiles);
    }

    public List<File> createProjects(File dir) {
        return this.runner.createProjects(dir);
    }

    public List<Issue> getCheckedIssues() {
        if (this.checkedIssues == null) {
            JarFileIssueRegistry.Factory.clearCache();
            if (this.issues != null) {
                this.checkedIssues = Arrays.asList(this.issues);
                return this.checkedIssues;
            }
            if (this.customRules != null) {
                TestLintClient client2 = this.runner.createClient();
                client2.task = this;
                List registries = JarFileIssueRegistry.Factory.get((LintClient)client2, Arrays.asList(this.customRules), null, null, false);
                IssueRegistry[] array = registries.toArray(new IssueRegistry[0]);
                IssueRegistry all = JarFileIssueRegistry.Factory.join(array);
                this.checkedIssues = all.getIssues();
                return this.checkedIssues;
            }
            if (this.detector != null) {
                this.checkedIssues = Lists.newArrayList();
                Class<?> detectorClass = this.detector.getClass();
                TestLintTask.addIssuesFromClass(this.checkedIssues, detectorClass);
                if (this.checkedIssues.isEmpty()) {
                    try {
                        Class<?> fileClass = Class.forName(detectorClass.getName() + "Kt");
                        TestLintTask.addIssuesFromClass(this.checkedIssues, fileClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.checkedIssues.isEmpty()) {
                    throw new RuntimeException("Could not find any Issue field instances in detector " + this.detector.getClass().getSimpleName() + ": call issues() to configure exact issues to check instead");
                }
                return this.checkedIssues;
            }
            if (this.issueIds != null && this.issueIds.length > 0) {
                this.checkedIssues = Lists.newArrayList();
                TestIssueRegistry registry = new TestIssueRegistry();
                for (String id : this.issueIds) {
                    Issue issue = registry.getIssue(id);
                    if (issue == null) continue;
                    this.checkedIssues.add(issue);
                }
                return this.checkedIssues;
            }
            if (this.allowDelayedIssueRegistration) {
                this.checkedIssues = Collections.emptyList();
                return this.checkedIssues;
            }
            throw new RuntimeException("No issues configured; you must call either issues(), detector() or customRules() to tell the lint infrastructure which checks should be performed");
        }
        return this.checkedIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectDescription.Type getDefaultType() {
        ProjectDescription.Type defaultType = ProjectDescription.Type.APP;
        boolean prevAllowDelayedIssueRegistration = this.allowDelayedIssueRegistration;
        try {
            this.allowDelayedIssueRegistration = true;
            for (Issue issue : this.getCheckedIssues()) {
                EnumSet platforms2 = issue.getPlatforms();
                if (platforms2.contains(Platform.JDK) && !platforms2.contains(Platform.ANDROID)) {
                    defaultType = ProjectDescription.Type.JAVA;
                    continue;
                }
                if (!platforms2.contains(Platform.ANDROID)) continue;
                ProjectDescription.Type type = ProjectDescription.Type.APP;
                return type;
            }
        }
        finally {
            this.allowDelayedIssueRegistration = prevAllowDelayedIssueRegistration;
        }
        return defaultType;
    }

    private static void addIssuesFromClass(List<Issue> checkedIssues, Class<?> detectorClass) {
        TestLintTask.addIssuesFromFields(checkedIssues, detectorClass.getFields());
        TestLintTask.addIssuesFromFields(checkedIssues, detectorClass.getDeclaredFields());
        for (Method method : detectorClass.getDeclaredMethods()) {
            if ((method.getModifiers() & 8) == 0 || method.getReturnType() != Issue.class || !method.getName().startsWith("get") || method.getParameterCount() != 0) continue;
            try {
                method.setAccessible(true);
                Issue issue = (Issue)method.invoke(null, new Object[0]);
                if (checkedIssues.contains(issue)) continue;
                checkedIssues.add(issue);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private static void addIssuesFromFields(List<Issue> checkedIssues, Field[] fields) {
        for (Field field : fields) {
            if ((field.getModifiers() & 8) == 0 || field.getName().startsWith("_") || field.getType() != Issue.class) continue;
            try {
                field.setAccessible(true);
                Issue issue = (Issue)field.get(null);
                if (checkedIssues.contains(issue)) continue;
                checkedIssues.add(issue);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public TestLintTask networkData(String url, byte[] data) {
        if (this.mockNetworkData == null) {
            this.mockNetworkData = Maps.newHashMap();
        }
        this.mockNetworkData.put(url, data);
        return this;
    }

    public TestLintTask networkData(String url, String data) {
        return this.networkData(url, data.getBytes(Charsets.UTF_8));
    }

    public TestLintTask networkData(String url, int data) {
        if (this.mockNetworkErrorCodes == null) {
            this.mockNetworkErrorCodes = Maps.newHashMap();
        }
        this.mockNetworkErrorCodes.put(url, data);
        return this;
    }

    public TestLintTask networkData(String url, int status, Map<String, List<String>> headers) {
        this.networkData(url, status);
        if (this.mockNetworkHeaderFields == null) {
            this.mockNetworkHeaderFields = Maps.newHashMap();
        }
        this.mockNetworkHeaderFields.put(url, headers);
        return this;
    }

    public TestLintTask allowNetworkAccess(boolean allowNetworkAccess) {
        this.allowNetworkAccess = allowNetworkAccess;
        return this;
    }

    public TestLintTask platforms(EnumSet<Platform> platforms2) {
        this.platforms = platforms2;
        return this;
    }

    public TestLintTask rootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        return this;
    }

    public TestLintTask reportFrom(ProjectDescription project) {
        this.reportFrom = project;
        return this;
    }

    static {
        if ("true".equals(System.getenv("LINT_FIND_DUPLICATE_TESTS")) || "true".equals(System.getProperty("lint.find-duplicate-tests"))) {
            duplicateFinder = new DuplicateProjectFinder();
        }
    }

    @FunctionalInterface
    public static interface LintDriverConfigurator {
        public void configure(LintDriver var1);
    }

    @FunctionalInterface
    public static interface OptionSetter {
        public void set(LintCliFlags var1);
    }

    @FunctionalInterface
    public static interface ErrorMessageChecker {
        public void checkReportedError(Context var1, Issue var2, Severity var3, Location var4, String var5, LintFix var6);
    }

    @FunctionalInterface
    public static interface ProjectInspector {
        public void inspect(LintDriver var1, List<Project> var2);
    }

    @FunctionalInterface
    public static interface ClientFactory {
        public TestLintClient create();
    }
}

